/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.master;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.InetAddress;
import com.aoapps.security.Identifier;
import com.aoapps.security.SecurityStreamables;
import com.aoapps.security.SmallIdentifier;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservObject;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.SingleTableObject;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Objects;

public class Process
extends AoservObject<SmallIdentifier, Process>
implements SingleTableObject<SmallIdentifier, Process> {
    static final int COLUMN_ID = 0;
    public static final String LOGIN = "login";
    public static final String RUN = "run";
    public static final String SLEEP = "sleep";
    protected SmallIdentifier id;
    protected Identifier connectorId;
    protected User.Name authenticatedUser;
    protected User.Name effectiveUser;
    protected int daemonServer;
    protected InetAddress host;
    protected String protocol;
    protected String aoservProtocol;
    protected boolean isSecure;
    protected UnmodifiableTimestamp connectTime;
    protected long useCount;
    protected long totalTime;
    protected int priority;
    protected String state;
    private String[] command;
    protected UnmodifiableTimestamp stateStartTime;
    private AoservTable<SmallIdentifier, Process> table;

    @Deprecated
    public Process() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.connectorId;
            }
            case 2: {
                return this.authenticatedUser;
            }
            case 3: {
                return this.effectiveUser;
            }
            case 4: {
                return this.daemonServer == -1 ? null : Integer.valueOf(this.daemonServer);
            }
            case 5: {
                return this.host;
            }
            case 6: {
                return this.protocol;
            }
            case 7: {
                return this.aoservProtocol;
            }
            case 8: {
                return this.isSecure;
            }
            case 9: {
                return this.connectTime;
            }
            case 10: {
                return this.useCount;
            }
            case 11: {
                return this.totalTime;
            }
            case 12: {
                return this.priority;
            }
            case 13: {
                return this.state;
            }
            case 14: {
                return Process.combineCommand(this.getCommand());
            }
            case 15: {
                return this.stateStartTime;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getDaemonServer() {
        return this.daemonServer;
    }

    public int getPriority() {
        return this.priority;
    }

    public SmallIdentifier getId() {
        return this.id;
    }

    public Identifier getConnectorId() {
        return this.connectorId;
    }

    public User.Name getAuthenticatedAdministrator_username() {
        return this.authenticatedUser;
    }

    public Administrator getAuthenticatedAdministrator() throws IOException, SQLException {
        return this.table.getConnector().getAccount().getAdministrator().get(this.authenticatedUser);
    }

    public User.Name getEffectiveAdministrator_username() {
        return this.effectiveUser;
    }

    public Administrator getEffectiveAdministrator() throws SQLException, IOException {
        Administrator obj = this.table.getConnector().getAccount().getAdministrator().get(this.effectiveUser);
        if (obj == null) {
            throw new SQLException("Unable to find Administrator: " + this.effectiveUser);
        }
        return obj;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getAoservProtocol() {
        return this.aoservProtocol;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public UnmodifiableTimestamp getConnectTime() {
        return this.connectTime;
    }

    public long getUseCount() {
        return this.useCount;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public String getState() {
        return this.state;
    }

    public UnmodifiableTimestamp getStateStartTime() {
        return this.stateStartTime;
    }

    @Override
    public SmallIdentifier getKey() {
        return this.id;
    }

    @Override
    public AoservTable<SmallIdentifier, Process> getTable() {
        return this.table;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MASTER_PROCESSES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        throw new SQLException("Should not be read from the database, should be generated.");
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.id = SecurityStreamables.readSmallIdentifier((DataInputStream)in);
            this.connectorId = SecurityStreamables.readNullIdentifier((DataInputStream)in);
            this.authenticatedUser = (User.Name)InternUtils.intern((Internable)User.Name.valueOf(in.readNullUTF()));
            this.effectiveUser = (User.Name)InternUtils.intern((Internable)User.Name.valueOf(in.readNullUTF()));
            this.daemonServer = in.readCompressedInt();
            this.host = InetAddress.valueOf((String)in.readUTF()).intern();
            this.protocol = in.readUTF().intern();
            this.aoservProtocol = InternUtils.intern((String)in.readNullUTF());
            this.isSecure = in.readBoolean();
            this.connectTime = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.useCount = in.readLong();
            this.totalTime = in.readLong();
            this.priority = in.readCompressedInt();
            this.state = in.readUTF().intern();
            int len = in.readCompressedInt();
            if (len == -1) {
                this.command = null;
            } else {
                this.command = new String[len];
                for (int i = 0; i < len; ++i) {
                    this.command[i] = in.readNullUTF();
                }
            }
            this.stateStartTime = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public static String combineCommand(String[] command) {
        if (command == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int len = command.length;
        for (int c = 0; c < len; ++c) {
            String com;
            if (c > 0) {
                sb.append(' ');
            }
            if ((com = command[c]) == null) {
                sb.append("''");
                continue;
            }
            sb.append(com);
        }
        return sb.toString();
    }

    public String[] getCommand() {
        return this.command == null ? null : Arrays.copyOf(this.command, this.command.length);
    }

    @Override
    public void setTable(AoservTable<SmallIdentifier, Process> table) {
        if (this.table != null) {
            throw new IllegalStateException("table already set");
        }
        this.table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        UnmodifiableTimestamp myStateStartTime;
        String[] myCommand;
        String myState;
        int myPriority;
        long myTotalTime;
        long myUseCount;
        UnmodifiableTimestamp myConnectTime;
        boolean myIsSecure;
        String myAoservProtocol;
        String myProtocol;
        InetAddress myHost;
        int myDaemonServer;
        User.Name myEffectiveUser;
        User.Name myAuthenticatedUser;
        Identifier myConnectorId;
        SmallIdentifier myId;
        Process process = this;
        synchronized (process) {
            myId = this.id;
            myConnectorId = this.connectorId;
            myAuthenticatedUser = this.authenticatedUser;
            myEffectiveUser = this.effectiveUser;
            myDaemonServer = this.daemonServer;
            myHost = this.host;
            myProtocol = this.protocol;
            myAoservProtocol = this.aoservProtocol;
            myIsSecure = this.isSecure;
            myConnectTime = this.connectTime;
            myUseCount = this.useCount;
            myTotalTime = this.totalTime;
            myPriority = this.priority;
            myState = this.state;
            myCommand = this.getCommand();
            myStateStartTime = this.stateStartTime;
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(myId.getValue());
            out.writeLong(myConnectorId == null ? -1L : myConnectorId.getLo());
        } else {
            SecurityStreamables.writeSmallIdentifier((SmallIdentifier)myId, (DataOutputStream)out);
            SecurityStreamables.writeNullIdentifier((Identifier)myConnectorId, (DataOutputStream)out);
        }
        out.writeNullUTF(Objects.toString(myAuthenticatedUser, null));
        out.writeNullUTF(Objects.toString(myEffectiveUser, null));
        out.writeCompressedInt(myDaemonServer);
        out.writeUTF(myHost.toString());
        out.writeUTF(myProtocol);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_101) >= 0) {
            out.writeNullUTF(myAoservProtocol);
        }
        out.writeBoolean(myIsSecure);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(myConnectTime.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)myConnectTime, (DataOutputStream)out);
        }
        out.writeLong(myUseCount);
        out.writeLong(myTotalTime);
        out.writeCompressedInt(myPriority);
        out.writeUTF(myState);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeNullUTF(Process.combineCommand(myCommand));
            out.writeLong(myStateStartTime.getTime());
        } else {
            if (myCommand == null) {
                out.writeCompressedInt(-1);
            } else {
                int len = myCommand.length;
                out.writeCompressedInt(len);
                for (int i = 0; i < len; ++i) {
                    out.writeNullUTF(myCommand[i]);
                }
            }
            SQLStreamables.writeTimestamp((Timestamp)myStateStartTime, (DataOutputStream)out);
        }
    }
}

