/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.master;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.CachedObjectUserNameKey;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class User
extends CachedObjectUserNameKey<User> {
    static final int COLUMN_USERNAME = 0;
    static final String COLUMN_USERNAME_name = "username";
    private boolean isActive;
    private boolean canAccessAccounting;
    private boolean canAccessBankAccount;
    private boolean canInvalidateTables;
    private boolean canAccessAdminWeb;
    private boolean isDnsAdmin;
    private boolean isRouter;
    private boolean isClusterAdmin;

    @Deprecated
    public User() {
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MASTER_USERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = User.Name.valueOf(result.getString(1));
            this.isActive = result.getBoolean(2);
            this.canAccessAccounting = result.getBoolean(3);
            this.canAccessBankAccount = result.getBoolean(4);
            this.canInvalidateTables = result.getBoolean(5);
            this.canAccessAdminWeb = result.getBoolean(6);
            this.isDnsAdmin = result.getBoolean(7);
            this.isRouter = result.getBoolean(8);
            this.isClusterAdmin = result.getBoolean(9);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey.toString());
        out.writeBoolean(this.isActive);
        out.writeBoolean(this.canAccessAccounting);
        out.writeBoolean(this.canAccessBankAccount);
        out.writeBoolean(this.canInvalidateTables);
        out.writeBoolean(this.canAccessAdminWeb);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_43) <= 0) {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.isDnsAdmin);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_118) < 0) {
            out.writeBoolean(false);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_65) >= 0) {
            out.writeBoolean(this.isRouter);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_73) >= 0) {
            out.writeBoolean(this.isClusterAdmin);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = User.Name.valueOf(in.readUTF()).intern();
            this.isActive = in.readBoolean();
            this.canAccessAccounting = in.readBoolean();
            this.canAccessBankAccount = in.readBoolean();
            this.canInvalidateTables = in.readBoolean();
            this.canAccessAdminWeb = in.readBoolean();
            this.isDnsAdmin = in.readBoolean();
            this.isRouter = in.readBoolean();
            this.isClusterAdmin = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.isActive;
            }
            case 2: {
                return this.canAccessAccounting;
            }
            case 3: {
                return this.canAccessBankAccount;
            }
            case 4: {
                return this.canInvalidateTables;
            }
            case 5: {
                return this.canAccessAdminWeb;
            }
            case 6: {
                return this.isDnsAdmin;
            }
            case 7: {
                return this.isRouter;
            }
            case 8: {
                return this.isClusterAdmin;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Administrator getAdministrator() throws SQLException, IOException {
        Administrator obj = this.table.getConnector().getAccount().getAdministrator().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find Administrator: " + this.pkey);
        }
        return obj;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean canAccessAccounting() {
        return this.canAccessAccounting;
    }

    public boolean canAccessBankAccount() {
        return this.canAccessBankAccount;
    }

    public boolean canInvalidateTables() {
        return this.canInvalidateTables;
    }

    public boolean isWebAdmin() {
        return this.canAccessAdminWeb;
    }

    public boolean isDnsAdmin() {
        return this.isDnsAdmin;
    }

    public boolean isRouter() {
        return this.isRouter;
    }

    public boolean isClusterAdmin() {
        return this.isClusterAdmin;
    }
}

