/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.master;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.HostAddress;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.master.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class UserAcl
extends CachedObjectIntegerKey<UserAcl> {
    static final int COLUMN_PKEY = 0;
    static final String COLUMN_USERNAME_name = "username";
    static final String COLUMN_HOST_name = "host";
    private User.Name username;
    private HostAddress host;

    @Deprecated
    public UserAcl() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        if (i == 0) {
            return this.pkey;
        }
        if (i == 1) {
            return this.username;
        }
        if (i == 2) {
            return this.host;
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public HostAddress getHost() {
        return this.host;
    }

    public User getMasterUser() throws SQLException, IOException {
        User obj = this.table.getConnector().getMaster().getUser().get(this.username);
        if (obj == null) {
            throw new SQLException("Unable to find MasterUser: " + this.username);
        }
        return obj;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MASTER_HOSTS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.username = User.Name.valueOf(result.getString(2));
            this.host = HostAddress.valueOf((String)result.getString(3));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.username = User.Name.valueOf(in.readUTF()).intern();
            this.host = HostAddress.valueOf((String)in.readUTF()).intern();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.username.toString());
        out.writeUTF(this.host.toString());
    }
}

