/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.master;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.master.User;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class UserHost
extends CachedObjectIntegerKey<UserHost> {
    static final int COLUMN_PKEY = 0;
    static final String COLUMN_USERNAME_name = "username";
    static final String COLUMN_SERVER_name = "server";
    private User.Name username;
    private int server;

    @Deprecated
    public UserHost() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.username;
            }
            case 2: {
                return this.server;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public User getMasterUser() throws SQLException, IOException {
        User obj = this.table.getConnector().getMaster().getUser().get(this.username);
        if (obj == null) {
            throw new SQLException("Unable to find MasterUser: " + this.username);
        }
        return obj;
    }

    public Host getHost() throws SQLException, IOException {
        Host obj = this.table.getConnector().getNet().getHost().get(this.server);
        if (obj == null) {
            throw new SQLException("Unable to find Host: " + this.server);
        }
        return obj;
    }

    public int getServerPkey() {
        return this.server;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MASTER_SERVERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.username = User.Name.valueOf(result.getString(2));
            this.server = result.getInt(3);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.username = User.Name.valueOf(in.readUTF()).intern();
            this.server = in.readCompressedInt();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.username.toString());
        out.writeCompressedInt(this.server);
    }
}

