/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.mysql;

import com.aoapps.hodgepodge.io.ByteCountInputStream;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.dto.DtoFactory;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.io.IoUtils;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.InvalidResult;
import com.aoapps.lang.validation.ValidResult;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import com.aoapps.net.InetAddress;
import com.aoapps.net.Port;
import com.aoapps.net.URIEncoder;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Dumpable;
import com.aoindustries.aoserv.client.JdbcProvider;
import com.aoindustries.aoserv.client.NestedInputStream;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.StreamHandler;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.backup.MysqlReplication;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.dto.MysqlDatabaseName;
import com.aoindustries.aoserv.client.monitoring.AlertLevel;
import com.aoindustries.aoserv.client.mysql.DatabaseUser;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.mysql.TableName;
import com.aoindustries.aoserv.client.mysql.UserServer;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.net.IpAddress;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Database
extends CachedObjectIntegerKey<Database>
implements Removable,
Dumpable,
JdbcProvider {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, Database.class);
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_MYSQL_SERVER = 2;
    static final int COLUMN_PACKAGE = 3;
    static final String COLUMN_NAME_name = "name";
    static final String COLUMN_MYSQL_SERVER_name = "mysql_server";
    public static final String CENTOS_JDBC_DRIVER = "com.mysql.jdbc.Driver";
    public static final String CENTOS_7_JDBC_DRIVER = "com.mysql.cj.jdbc.Driver";
    public static final String CENTOS_JDBC_DOCUMENTATION_URL = "https://dev.mysql.com/doc/connector-j/5.1/en/";
    public static final String CENTOS_7_JDBC_DOCUMENTATION_URL = "https://dev.mysql.com/doc/connector-j/8.0/en/";
    public static final Name MYSQL;
    public static final Name INFORMATION_SCHEMA;
    public static final Name PERFORMANCE_SCHEMA;
    public static final Name SYS;
    public static final Name MYSQLMON;
    private Name name;
    private int mysqlServer;
    private Account.Name packageName;
    private AlertLevel maxCheckTableAlertLevel;
    public static final Charset DUMP_ENCODING;

    public static boolean isSpecial(Name name) {
        return name.equals(MYSQL) || name.equals(INFORMATION_SCHEMA) || name.equals(PERFORMANCE_SCHEMA) || name.equals(SYS) || name.equals(MYSQLMON);
    }

    @Deprecated
    public Database() {
    }

    @Deprecated
    public int addMysqlServerUser(UserServer msu, boolean canSelect, boolean canInsert, boolean canUpdate, boolean canDelete, boolean canCreate, boolean canDrop, boolean canReference, boolean canIndex, boolean canAlter, boolean canCreateTempTable, boolean canLockTables, boolean canCreateView, boolean canShowView, boolean canCreateRoutine, boolean canAlterRoutine, boolean canExecute, boolean canEvent, boolean canTrigger) throws IOException, SQLException {
        return this.table.getConnector().getMysql().getDatabaseUser().addMysqlDbUser(this, msu, canSelect, canInsert, canUpdate, canDelete, canCreate, canDrop, canReference, canIndex, canAlter, canCreateTempTable, canLockTables, canCreateView, canShowView, canCreateRoutine, canAlterRoutine, canExecute, canEvent, canTrigger);
    }

    @Override
    public void dump(PrintWriter out) throws IOException, SQLException {
        this.dump((Writer)out);
    }

    public void dump(final Writer out) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.DUMP_MYSQL_DATABASE, new AoservConnector.UpdateRequest(){

            @Override
            public void writeRequest(StreamableOutput masterOut) throws IOException {
                masterOut.writeCompressedInt(Database.this.pkey);
                masterOut.writeBoolean(false);
            }

            @Override
            public void readResponse(StreamableInput masterIn) throws IOException, SQLException {
                long bytesRead;
                long dumpSize = masterIn.readLong();
                if (dumpSize < 0L) {
                    throw new IOException("dumpSize < 0: " + dumpSize);
                }
                try (ByteCountInputStream byteCountIn = new ByteCountInputStream((InputStream)new NestedInputStream(masterIn));
                     InputStreamReader nestedIn = new InputStreamReader((InputStream)byteCountIn, DUMP_ENCODING);){
                    IoUtils.copy((Reader)nestedIn, (Writer)out);
                    bytesRead = byteCountIn.getCount();
                }
                if (bytesRead < dumpSize) {
                    throw new IOException("Too few bytes read: " + bytesRead + " < " + dumpSize);
                }
                if (bytesRead > dumpSize) {
                    throw new IOException("Too many bytes read: " + bytesRead + " > " + dumpSize);
                }
            }

            @Override
            public void afterRelease() {
            }
        });
    }

    public void dump(final boolean gzip, final StreamHandler streamHandler) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.DUMP_MYSQL_DATABASE, new AoservConnector.UpdateRequest(){

            @Override
            public void writeRequest(StreamableOutput masterOut) throws IOException {
                masterOut.writeCompressedInt(Database.this.pkey);
                masterOut.writeBoolean(gzip);
            }

            @Override
            public void readResponse(StreamableInput masterIn) throws IOException, SQLException {
                long bytesRead;
                long dumpSize = masterIn.readLong();
                if (dumpSize < -1L) {
                    throw new IOException("dumpSize < -1: " + dumpSize);
                }
                streamHandler.onDumpSize(dumpSize);
                try (NestedInputStream nestedIn = new NestedInputStream(masterIn);){
                    bytesRead = IoUtils.copy((InputStream)nestedIn, (OutputStream)streamHandler.getOut());
                }
                if (dumpSize != -1L) {
                    if (bytesRead < dumpSize) {
                        throw new IOException("Too few bytes read: " + bytesRead + " < " + dumpSize);
                    }
                    if (bytesRead > dumpSize) {
                        throw new IOException("Too many bytes read: " + bytesRead + " > " + dumpSize);
                    }
                }
            }

            @Override
            public void afterRelease() {
            }
        });
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.mysqlServer;
            }
            case 3: {
                return this.packageName;
            }
            case 4: {
                return this.maxCheckTableAlertLevel.name();
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public String getJdbcDriver() throws SQLException, IOException {
        int osv = this.getMysqlServer().getLinuxServer().getHost().getOperatingSystemVersion_id();
        switch (osv) {
            case 67: {
                return CENTOS_JDBC_DRIVER;
            }
            case 70: {
                return CENTOS_7_JDBC_DRIVER;
            }
        }
        throw new SQLException("Unsupported OperatingSystemVersion: " + osv);
    }

    @Override
    public String getJdbcUrl(boolean ipOnly) throws SQLException, IOException {
        Server ms = this.getMysqlServer();
        com.aoindustries.aoserv.client.linux.Server ao = ms.getLinuxServer();
        StringBuilder jdbcUrl = new StringBuilder();
        jdbcUrl.append("jdbc:mysql://");
        Bind nb = ms.getBind();
        IpAddress ip = nb.getIpAddress();
        InetAddress ia = ip.getInetAddress();
        if (ipOnly) {
            if (ia.isUnspecified()) {
                jdbcUrl.append(ao.getHost().getNetDevice(ao.getDaemonDeviceId().getName()).getPrimaryIpAddress().getInetAddress().toBracketedString());
            } else {
                jdbcUrl.append(ia.toBracketedString());
            }
        } else if (ia.isUnspecified()) {
            jdbcUrl.append(ao.getHostname());
        } else if (ia.isLoopback()) {
            jdbcUrl.append(ia.toBracketedString());
        } else {
            jdbcUrl.append(ip.getHostname());
        }
        Port port = nb.getPort();
        if (!port.equals((Object)Server.DEFAULT_PORT)) {
            jdbcUrl.append(':').append(port.getPort());
        }
        jdbcUrl.append('/');
        URIEncoder.encodeURIComponent((String)this.getName().toString(), (StringBuilder)jdbcUrl);
        return jdbcUrl.toString();
    }

    @Override
    public String getJdbcDocumentationUrl() throws SQLException, IOException {
        int osv = this.getMysqlServer().getLinuxServer().getHost().getOperatingSystemVersion_id();
        switch (osv) {
            case 67: {
                return CENTOS_JDBC_DOCUMENTATION_URL;
            }
            case 70: {
                return CENTOS_7_JDBC_DOCUMENTATION_URL;
            }
        }
        throw new SQLException("Unsupported OperatingSystemVersion: " + osv);
    }

    public DatabaseUser getMysqlDbUser(UserServer msu) throws IOException, SQLException {
        return this.table.getConnector().getMysql().getDatabaseUser().getMysqlDbUser(this, msu);
    }

    public List<DatabaseUser> getMysqlDbUsers() throws IOException, SQLException {
        return this.table.getConnector().getMysql().getDatabaseUser().getMysqlDbUsers(this);
    }

    public List<UserServer> getMysqlServerUsers() throws IOException, SQLException {
        return this.table.getConnector().getMysql().getDatabaseUser().getMysqlServerUsers(this);
    }

    public Name getName() {
        return this.name;
    }

    public boolean isSpecial() {
        return Database.isSpecial(this.name);
    }

    public Account.Name getPackage_name() {
        return this.packageName;
    }

    public Package getPackage() throws SQLException, IOException {
        Package obj = this.table.getConnector().getBilling().getPackage().get(this.packageName);
        if (obj == null) {
            throw new SQLException("Unable to find Package: " + this.packageName);
        }
        return obj;
    }

    public int getMysqlServer_id() {
        return this.mysqlServer;
    }

    public Server getMysqlServer() throws SQLException, IOException {
        Server obj = this.table.getConnector().getMysql().getServer().get(this.mysqlServer);
        if (obj == null) {
            throw new SQLException("Unable to find MysqlServer: " + this.mysqlServer);
        }
        return obj;
    }

    public AlertLevel getMaxCheckTableAlertLevel() {
        return this.maxCheckTableAlertLevel;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MYSQL_DATABASES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.name = Name.valueOf(result.getString(2));
            this.mysqlServer = result.getInt(3);
            this.packageName = Account.Name.valueOf(result.getString(4));
            this.maxCheckTableAlertLevel = AlertLevel.valueOf(result.getString(5));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.name = Name.valueOf(in.readUTF());
            this.mysqlServer = in.readCompressedInt();
            this.packageName = Account.Name.valueOf(in.readUTF()).intern();
            this.maxCheckTableAlertLevel = AlertLevel.valueOf(in.readCompressedUTF());
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<Database>> getCannotRemoveReasons() throws SQLException, IOException {
        ArrayList<CannotRemoveReason<Database>> reasons = new ArrayList<CannotRemoveReason<Database>>();
        if (this.isSpecial()) {
            Server ms = this.getMysqlServer();
            reasons.add(new CannotRemoveReason<Database>("Not allowed to drop a special MySQL database: " + this.name + " on " + ms.getName() + " on " + ms.getLinuxServer().getHostname(), this));
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to remove special MySQL database: " + this);
        }
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.MYSQL_DATABASES, this.pkey});
    }

    @Override
    public String toStringImpl() {
        return this.name.toString();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.name.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_4) < 0) {
            out.writeCompressedInt(-1);
        } else {
            out.writeCompressedInt(this.mysqlServer);
        }
        out.writeUTF(this.packageName.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeShort(0);
            out.writeShort(7);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_74) >= 0) {
            out.writeCompressedUTF(this.maxCheckTableAlertLevel.name());
        }
    }

    public List<TableStatus> getTableStatus() throws IOException, SQLException {
        return this.getTableStatus(null);
    }

    public List<TableStatus> getTableStatus(final MysqlReplication mysqlSlave) throws IOException, SQLException {
        return this.table.getConnector().requestResult(true, AoservProtocol.CommandId.GET_MYSQL_TABLE_STATUS, new AoservConnector.ResultRequest<List<TableStatus>>(){
            private List<TableStatus> result;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Database.this.pkey);
                out.writeCompressedInt(mysqlSlave == null ? -1 : mysqlSlave.getPkey());
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                ArrayList<TableStatus> tableStatuses;
                byte code = in.readByte();
                if (code == 0) {
                    int size = in.readCompressedInt();
                    tableStatuses = new ArrayList<TableStatus>(size);
                    for (int c = 0; c < size; ++c) {
                        try {
                            tableStatuses.add(new TableStatus(TableName.valueOf(in.readUTF()), (Engine)in.readNullEnum(Engine.class), in.readNullInteger(), (TableStatus.RowFormat)in.readNullEnum(TableStatus.RowFormat.class), in.readNullLong(), in.readNullLong(), in.readNullLong(), in.readNullLong(), in.readNullLong(), in.readNullLong(), in.readNullLong(), in.readNullUTF(), in.readNullUTF(), in.readNullUTF(), (TableStatus.Collation)in.readNullEnum(TableStatus.Collation.class), in.readNullUTF(), in.readNullUTF(), in.readNullUTF()));
                            continue;
                        }
                        catch (ValidationException e) {
                            throw new IOException(e);
                        }
                    }
                } else {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.result = tableStatuses;
            }

            @Override
            public List<TableStatus> afterRelease() {
                return Collections.unmodifiableList(this.result);
            }
        });
    }

    public List<CheckTableResult> checkTables(Collection<TableName> tableNames) throws IOException, SQLException {
        return this.checkTables(null, tableNames);
    }

    public List<CheckTableResult> checkTables(final MysqlReplication mysqlSlave, final Collection<TableName> tableNames) throws IOException, SQLException {
        if (tableNames.isEmpty()) {
            return Collections.emptyList();
        }
        return this.table.getConnector().requestResult(true, AoservProtocol.CommandId.CHECK_MYSQL_TABLES, new AoservConnector.ResultRequest<List<CheckTableResult>>(){
            private List<CheckTableResult> result;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                int count;
                out.writeCompressedInt(Database.this.pkey);
                out.writeCompressedInt(mysqlSlave == null ? -1 : mysqlSlave.getPkey());
                int size = tableNames.size();
                out.writeCompressedInt(size);
                Iterator iter = tableNames.iterator();
                for (count = 0; count < size && iter.hasNext(); ++count) {
                    out.writeUTF(((TableName)iter.next()).toString());
                }
                if (count != size) {
                    throw new ConcurrentModificationException("count != size");
                }
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                ArrayList<CheckTableResult> checkTableResults;
                byte code = in.readByte();
                if (code == 0) {
                    int size = in.readCompressedInt();
                    checkTableResults = new ArrayList<CheckTableResult>(size);
                    for (int c = 0; c < size; ++c) {
                        try {
                            checkTableResults.add(new CheckTableResult(TableName.valueOf(in.readUTF()), in.readLong(), (CheckTableResult.MsgType)in.readNullEnum(CheckTableResult.MsgType.class), in.readNullUTF()));
                            continue;
                        }
                        catch (ValidationException e) {
                            throw new IOException(e);
                        }
                    }
                } else {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.result = checkTableResults;
            }

            @Override
            public List<CheckTableResult> afterRelease() {
                return Collections.unmodifiableList(this.result);
            }
        });
    }

    @Deprecated
    public static boolean isSafeName(String name) {
        return Name.validate(name).isValid();
    }

    static {
        try {
            MYSQL = Name.valueOf("mysql");
            INFORMATION_SCHEMA = Name.valueOf("information_schema");
            PERFORMANCE_SCHEMA = Name.valueOf("performance_schema");
            SYS = Name.valueOf("sys");
            MYSQLMON = Name.valueOf("mysqlmon");
        }
        catch (ValidationException e) {
            throw new AssertionError("These hard-coded values are valid", e);
        }
        DUMP_ENCODING = StandardCharsets.UTF_8;
    }

    public static class CheckTableResult {
        private final TableName table;
        private final long duration;
        private final MsgType msgType;
        private final String msgText;

        public CheckTableResult(TableName table, long duration, MsgType msgType, String msgText) {
            this.table = table;
            this.duration = duration;
            this.msgType = msgType;
            this.msgText = msgText;
        }

        public TableName getTable() {
            return this.table;
        }

        public long getDuration() {
            return this.duration;
        }

        public MsgType getMsgType() {
            return this.msgType;
        }

        public String getMsgText() {
            return this.msgText;
        }

        public static enum MsgType {
            status,
            error,
            info,
            warning,
            note,
            Error;

        }
    }

    public static class TableStatus {
        private final TableName name;
        private final Engine engine;
        private final Integer version;
        private final RowFormat rowFormat;
        private final Long rows;
        private final Long avgRowLength;
        private final Long dataLength;
        private final Long maxDataLength;
        private final Long indexLength;
        private final Long dataFree;
        private final Long autoIncrement;
        private final String createTime;
        private final String updateTime;
        private final String checkTime;
        private final Collation collation;
        private final String checksum;
        private final String createOptions;
        private final String comment;

        public TableStatus(TableName name, Engine engine, Integer version, RowFormat rowFormat, Long rows, Long avgRowLength, Long dataLength, Long maxDataLength, Long indexLength, Long dataFree, Long autoIncrement, String createTime, String updateTime, String checkTime, Collation collation, String checksum, String createOptions, String comment) {
            this.name = name;
            this.engine = engine;
            this.version = version;
            this.rowFormat = rowFormat;
            this.rows = rows;
            this.avgRowLength = avgRowLength;
            this.dataLength = dataLength;
            this.maxDataLength = maxDataLength;
            this.indexLength = indexLength;
            this.dataFree = dataFree;
            this.autoIncrement = autoIncrement;
            this.createTime = createTime;
            this.updateTime = updateTime;
            this.checkTime = checkTime;
            this.collation = collation;
            this.checksum = checksum;
            this.createOptions = createOptions;
            this.comment = comment;
        }

        public TableName getName() {
            return this.name;
        }

        public Engine getEngine() {
            return this.engine;
        }

        public Integer getVersion() {
            return this.version;
        }

        public RowFormat getRowFormat() {
            return this.rowFormat;
        }

        public Long getRows() {
            return this.rows;
        }

        public Long getAvgRowLength() {
            return this.avgRowLength;
        }

        public Long getDataLength() {
            return this.dataLength;
        }

        public Long getMaxDataLength() {
            return this.maxDataLength;
        }

        public Long getIndexLength() {
            return this.indexLength;
        }

        public Long getDataFree() {
            return this.dataFree;
        }

        public Long getAutoIncrement() {
            return this.autoIncrement;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public String getUpdateTime() {
            return this.updateTime;
        }

        public String getCheckTime() {
            return this.checkTime;
        }

        public Collation getCollation() {
            return this.collation;
        }

        public String getChecksum() {
            return this.checksum;
        }

        public String getCreateOptions() {
            return this.createOptions;
        }

        public String getComment() {
            return this.comment;
        }

        public static enum Collation {
            binary,
            latin1_swedish_ci,
            utf8_bin,
            utf8_general_ci,
            utf8_unicode_ci,
            utf8mb4_general_ci,
            utf8mb4_unicode_ci,
            utf8mb4_unicode_520_ci;

        }

        public static enum RowFormat {
            Compact,
            Dynamic,
            Fixed;

        }
    }

    public static enum Engine {
        CSV,
        MyISAM,
        InnoDB,
        HEAP,
        MEMORY,
        PERFORMANCE_SCHEMA;

    }

    public static final class Name
    implements Comparable<Name>,
    Serializable,
    DtoFactory<MysqlDatabaseName>,
    Internable<Name> {
        private static final long serialVersionUID = 1495532864586195961L;
        public static final int MAX_LENGTH = 64;
        private static final ConcurrentMap<String, Name> interned = new ConcurrentHashMap<String, Name>();
        private final String name;

        public static ValidationResult validate(String name) {
            if (name == null) {
                return new InvalidResult(RESOURCES, "Name.validate.isNull");
            }
            int len = name.length();
            if (len == 0) {
                return new InvalidResult(RESOURCES, "Name.validate.isEmpty");
            }
            if (len > 64) {
                return new InvalidResult(RESOURCES, "Name.validate.tooLong", new Serializable[]{Integer.valueOf(64), Integer.valueOf(len)});
            }
            for (int c = 0; c < len; ++c) {
                char ch = name.charAt(c);
                if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '-' || ch == '.' || ch == ' ') continue;
                return new InvalidResult(RESOURCES, "Name.validate.illegalCharacter");
            }
            return ValidResult.getInstance();
        }

        public static Name valueOf(String name) throws ValidationException {
            if (name == null) {
                return null;
            }
            return new Name(name, true);
        }

        private Name(String name, boolean validate) throws ValidationException {
            this.name = name;
            if (validate) {
                this.validate();
            }
        }

        private Name(String name) {
            ValidationResult result;
            assert ((result = Name.validate(name)).isValid()) : result.toString();
            this.name = name;
        }

        private void validate() throws ValidationException {
            ValidationResult result = Name.validate(this.name);
            if (!result.isValid()) {
                throw new ValidationException(result);
            }
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            try {
                this.validate();
            }
            catch (ValidationException err) {
                InvalidObjectException newErr = new InvalidObjectException(err.getMessage());
                newErr.initCause(err);
                throw newErr;
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof Name && this.name.equals(((Name)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(Name other) {
            return this == other ? 0 : this.name.compareTo(other.name);
        }

        public String toString() {
            return this.name;
        }

        public Name intern() {
            Name addMe;
            String internedName;
            Name existing = (Name)interned.get(this.name);
            if (existing == null && (existing = interned.putIfAbsent(internedName, addMe = this.name == (internedName = this.name.intern()) ? this : new Name(internedName))) == null) {
                existing = addMe;
            }
            return existing;
        }

        public MysqlDatabaseName getDto() {
            return new MysqlDatabaseName(this.name);
        }
    }
}

