/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.mysql;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.StreamHandler;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.mysql.Database;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.List;

public final class DatabaseTable
extends CachedTableIntegerKey<Database> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("name", true), new AoservTable.OrderBy("mysql_server.ao_server.hostname", true), new AoservTable.OrderBy("mysql_server.name", true)};

    DatabaseTable(AoservConnector connector) {
        super(connector, Database.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int addMysqlDatabase(Database.Name name, Server mysqlServer, Package packageObj) throws IOException, SQLException {
        if (Database.isSpecial(name)) {
            throw new SQLException("Refusing to add special MySQL database: " + name + " on " + mysqlServer);
        }
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.MYSQL_DATABASES, name, mysqlServer.getBind_id(), packageObj.getName()});
    }

    public Database.Name generateMysqlDatabaseName(String templateBase, String templateAdded) throws IOException, SQLException {
        try {
            return Database.Name.valueOf(this.connector.requestStringQuery(true, AoservProtocol.CommandId.GENERATE_MYSQL_DATABASE_NAME, templateBase, templateAdded));
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Database get(int pkey) throws IOException, SQLException {
        return (Database)this.getUniqueRow(0, pkey);
    }

    Database getMysqlDatabase(Database.Name name, Server ms) throws IOException, SQLException {
        for (Database md : this.getMysqlDatabases(ms)) {
            if (!md.getName().equals(name)) continue;
            return md;
        }
        return null;
    }

    public List<Database> getMysqlDatabases(Package pack) throws IOException, SQLException {
        return this.getIndexedRows(3, pack.getName());
    }

    List<Database> getMysqlDatabases(Server ms) throws IOException, SQLException {
        return this.getIndexedRows(2, ms.getBind_id());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MYSQL_DATABASES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_mysql_database")) {
            if (Aosh.checkParamCount("add_mysql_database", args, 4, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addMysqlDatabase(Aosh.parseMysqlDatabaseName(args[1], "database_name"), Aosh.parseMysqlServerName(args[2], "mysql_server"), args[3], Aosh.parseAccountingCode(args[4], "package")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("check_mysql_database_name")) {
            if (Aosh.checkParamCount("check_mysql_database_name", args, 1, (PrintWriter)err)) {
                ValidationResult validationResult = Database.Name.validate(args[1]);
                out.println(validationResult.isValid());
                out.flush();
                if (!validationResult.isValid()) {
                    err.print("aosh: check_mysql_database_name: ");
                    err.println(validationResult.toString());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("dump_mysql_database")) {
            if (Aosh.checkParamCount("dump_mysql_database", args, 4, (PrintWriter)err)) {
                try {
                    Database.Name dbName = Aosh.parseMysqlDatabaseName(args[1], "database_name");
                    Server.Name serverName = Aosh.parseMysqlServerName(args[2], "mysql_server");
                    String aoServer = args[3];
                    if (Aosh.parseBoolean(args[4], "gzip")) {
                        this.connector.getSimpleClient().dumpMysqlDatabase(dbName, serverName, aoServer, true, new StreamHandler(){

                            @Override
                            public void onDumpSize(long dumpSize) {
                            }

                            @Override
                            public OutputStream getOut() {
                                return System.out;
                            }
                        });
                        System.out.flush();
                    } else {
                        this.connector.getSimpleClient().dumpMysqlDatabase(dbName, serverName, aoServer, (Writer)out);
                        out.flush();
                    }
                }
                catch (IllegalArgumentException iae) {
                    err.print("aosh: dump_mysql_database: ");
                    err.println(iae.getMessage());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("generate_mysql_database_name")) {
            if (Aosh.checkParamCount("generate_mysql_database_name", args, 2, (PrintWriter)err)) {
                out.println((Object)this.connector.getSimpleClient().generateMysqlDatabaseName(args[1], args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("is_mysql_database_name_available")) {
            if (Aosh.checkParamCount("is_mysql_database_name_available", args, 3, (PrintWriter)err)) {
                try {
                    out.println(this.connector.getSimpleClient().isMysqlDatabaseNameAvailable(Aosh.parseMysqlDatabaseName(args[1], "database_name"), Aosh.parseMysqlServerName(args[2], "mysql_server"), args[3]));
                    out.flush();
                }
                catch (IllegalArgumentException iae) {
                    err.print("aosh: is_mysql_database_name_available: ");
                    err.println(iae.getMessage());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_mysql_database")) {
            if (Aosh.checkParamCount("remove_mysql_database", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeMysqlDatabase(Aosh.parseMysqlDatabaseName(args[1], "database_name"), Aosh.parseMysqlServerName(args[2], "mysql_server"), args[3]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("wait_for_mysql_database_rebuild")) {
            if (Aosh.checkParamCount("wait_for_mysql_database_rebuild", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().waitForMysqlDatabaseRebuild(args[1]);
            }
            return true;
        }
        return false;
    }

    boolean isMysqlDatabaseNameAvailable(Database.Name name, Server mysqlServer) throws IOException, SQLException {
        return this.connector.requestBooleanQuery(true, AoservProtocol.CommandId.IS_MYSQL_DATABASE_NAME_AVAILABLE, name, mysqlServer.getPkey());
    }

    public void waitForRebuild(com.aoindustries.aoserv.client.linux.Server aoServer) throws IOException, SQLException {
        this.connector.requestUpdate(true, AoservProtocol.CommandId.WAIT_FOR_REBUILD, new Object[]{Table.TableId.MYSQL_DATABASES, aoServer.getPkey()});
    }
}

