/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.mysql;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.mysql.Database;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.mysql.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class DatabaseUser
extends CachedObjectIntegerKey<DatabaseUser>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_MYSQL_DATABASE = 1;
    static final int COLUMN_MYSQL_SERVER_USER = 2;
    static final String COLUMN_MYSQL_DATABASE_name = "mysql_database";
    static final String COLUMN_MYSQL_SERVER_USER_name = "mysql_server_user";
    private int mysqlDatabase;
    private int mysqlServerUser;
    private boolean selectPriv;
    private boolean insertPriv;
    private boolean updatePriv;
    private boolean deletePriv;
    private boolean createPriv;
    private boolean dropPriv;
    private boolean grantPriv;
    private boolean referencesPriv;
    private boolean indexPriv;
    private boolean alterPriv;
    private boolean createTmpTablePriv;
    private boolean lockTablesPriv;
    private boolean createViewPriv;
    private boolean showViewPriv;
    private boolean createRoutinePriv;
    private boolean alterRoutinePriv;
    private boolean executePriv;
    private boolean eventPriv;
    private boolean triggerPriv;

    @Deprecated
    public DatabaseUser() {
    }

    public boolean canAlter() {
        return this.alterPriv;
    }

    public boolean canCreateTempTable() {
        return this.createTmpTablePriv;
    }

    public boolean canLockTables() {
        return this.lockTablesPriv;
    }

    public boolean canCreate() {
        return this.createPriv;
    }

    public boolean canDelete() {
        return this.deletePriv;
    }

    public boolean canDrop() {
        return this.dropPriv;
    }

    public boolean canGrant() {
        return this.grantPriv;
    }

    public boolean canIndex() {
        return this.indexPriv;
    }

    public boolean canInsert() {
        return this.insertPriv;
    }

    public boolean canReference() {
        return this.referencesPriv;
    }

    public boolean canSelect() {
        return this.selectPriv;
    }

    public boolean canUpdate() {
        return this.updatePriv;
    }

    public boolean canCreateView() {
        return this.createViewPriv;
    }

    public boolean canShowView() {
        return this.showViewPriv;
    }

    public boolean canCreateRoutine() {
        return this.createRoutinePriv;
    }

    public boolean canAlterRoutine() {
        return this.alterRoutinePriv;
    }

    public boolean canExecute() {
        return this.executePriv;
    }

    public boolean canEvent() {
        return this.eventPriv;
    }

    public boolean canTrigger() {
        return this.triggerPriv;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.mysqlDatabase;
            }
            case 2: {
                return this.mysqlServerUser;
            }
            case 3: {
                return this.selectPriv;
            }
            case 4: {
                return this.insertPriv;
            }
            case 5: {
                return this.updatePriv;
            }
            case 6: {
                return this.deletePriv;
            }
            case 7: {
                return this.createPriv;
            }
            case 8: {
                return this.dropPriv;
            }
            case 9: {
                return this.grantPriv;
            }
            case 10: {
                return this.referencesPriv;
            }
            case 11: {
                return this.indexPriv;
            }
            case 12: {
                return this.alterPriv;
            }
            case 13: {
                return this.createTmpTablePriv;
            }
            case 14: {
                return this.lockTablesPriv;
            }
            case 15: {
                return this.createViewPriv;
            }
            case 16: {
                return this.showViewPriv;
            }
            case 17: {
                return this.createRoutinePriv;
            }
            case 18: {
                return this.alterRoutinePriv;
            }
            case 19: {
                return this.executePriv;
            }
            case 20: {
                return this.eventPriv;
            }
            case 21: {
                return this.triggerPriv;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Database getMysqlDatabase() throws IOException, SQLException {
        return this.table.getConnector().getMysql().getDatabase().get(this.mysqlDatabase);
    }

    public int getMysqlServerUser_id() {
        return this.mysqlServerUser;
    }

    public UserServer getMysqlServerUser() throws IOException, SQLException {
        return this.table.getConnector().getMysql().getUserServer().get(this.mysqlServerUser);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MYSQL_DB_USERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.mysqlDatabase = result.getInt(2);
        this.mysqlServerUser = result.getInt(3);
        this.selectPriv = result.getBoolean(4);
        this.insertPriv = result.getBoolean(5);
        this.updatePriv = result.getBoolean(6);
        this.deletePriv = result.getBoolean(7);
        this.createPriv = result.getBoolean(8);
        this.dropPriv = result.getBoolean(9);
        this.grantPriv = result.getBoolean(10);
        this.referencesPriv = result.getBoolean(11);
        this.indexPriv = result.getBoolean(12);
        this.alterPriv = result.getBoolean(13);
        this.createTmpTablePriv = result.getBoolean(14);
        this.lockTablesPriv = result.getBoolean(15);
        this.createViewPriv = result.getBoolean(16);
        this.showViewPriv = result.getBoolean(17);
        this.createRoutinePriv = result.getBoolean(18);
        this.alterRoutinePriv = result.getBoolean(19);
        this.executePriv = result.getBoolean(20);
        this.eventPriv = result.getBoolean(21);
        this.triggerPriv = result.getBoolean(22);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.mysqlDatabase = in.readCompressedInt();
        this.mysqlServerUser = in.readCompressedInt();
        this.selectPriv = in.readBoolean();
        this.insertPriv = in.readBoolean();
        this.updatePriv = in.readBoolean();
        this.deletePriv = in.readBoolean();
        this.createPriv = in.readBoolean();
        this.dropPriv = in.readBoolean();
        this.grantPriv = in.readBoolean();
        this.referencesPriv = in.readBoolean();
        this.indexPriv = in.readBoolean();
        this.alterPriv = in.readBoolean();
        this.createTmpTablePriv = in.readBoolean();
        this.lockTablesPriv = in.readBoolean();
        this.createViewPriv = in.readBoolean();
        this.showViewPriv = in.readBoolean();
        this.createRoutinePriv = in.readBoolean();
        this.alterRoutinePriv = in.readBoolean();
        this.executePriv = in.readBoolean();
        this.eventPriv = in.readBoolean();
        this.triggerPriv = in.readBoolean();
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() throws IOException, SQLException {
        Database md;
        ArrayList reasons = new ArrayList();
        UserServer msu = this.getMysqlServerUser();
        if (msu.isSpecial()) {
            Server ms = msu.getMysqlServer();
            reasons.add(new CannotRemoveReason<DatabaseUser>("Not allowed to revoke access from a special MySQL user: " + msu.getMysqlUser_username() + " on " + ms.getName() + " on " + ms.getLinuxServer().getHostname(), this));
        }
        if ((md = this.getMysqlDatabase()).isSpecial()) {
            Server ms = md.getMysqlServer();
            reasons.add(new CannotRemoveReason<DatabaseUser>("Not allowed to revoke access to a special MySQL database: " + md.getName() + " on " + ms.getName() + " on " + ms.getLinuxServer().getHostname(), this));
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        UserServer msu = this.getMysqlServerUser();
        if (msu.isSpecial()) {
            Server ms = msu.getMysqlServer();
            throw new SQLException("Refusing to revoke access from a special MySQL user: " + msu.getMysqlUser_username() + " on " + ms.getName() + " on " + ms.getLinuxServer().getHostname());
        }
        Database md = this.getMysqlDatabase();
        if (md.isSpecial()) {
            Server ms = md.getMysqlServer();
            throw new SQLException("Refusing to revoke access to a special MySQL database: " + md.getName() + " on " + ms.getName() + " on " + ms.getLinuxServer().getHostname());
        }
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.MYSQL_DB_USERS, this.pkey});
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.mysqlDatabase);
        out.writeCompressedInt(this.mysqlServerUser);
        out.writeBoolean(this.selectPriv);
        out.writeBoolean(this.insertPriv);
        out.writeBoolean(this.updatePriv);
        out.writeBoolean(this.deletePriv);
        out.writeBoolean(this.createPriv);
        out.writeBoolean(this.dropPriv);
        out.writeBoolean(this.grantPriv);
        out.writeBoolean(this.referencesPriv);
        out.writeBoolean(this.indexPriv);
        out.writeBoolean(this.alterPriv);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_111) >= 0) {
            out.writeBoolean(this.createTmpTablePriv);
            out.writeBoolean(this.lockTablesPriv);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_4) >= 0) {
            out.writeBoolean(this.createViewPriv);
            out.writeBoolean(this.showViewPriv);
            out.writeBoolean(this.createRoutinePriv);
            out.writeBoolean(this.alterRoutinePriv);
            out.writeBoolean(this.executePriv);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_54) >= 0) {
            out.writeBoolean(this.eventPriv);
            out.writeBoolean(this.triggerPriv);
        }
    }
}

