/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.mysql;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.mysql.Database;
import com.aoindustries.aoserv.client.mysql.DatabaseUser;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.mysql.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class DatabaseUserTable
extends CachedTableIntegerKey<DatabaseUser> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("mysql_database.name", true), new AoservTable.OrderBy("mysql_database.mysql_server.ao_server.hostname", true), new AoservTable.OrderBy("mysql_database.mysql_server.name", true), new AoservTable.OrderBy("mysql_server_user.username", true)};

    DatabaseUserTable(AoservConnector connector) {
        super(connector, DatabaseUser.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int addMysqlDbUser(final Database md, final UserServer msu, final boolean canSelect, final boolean canInsert, final boolean canUpdate, final boolean canDelete, final boolean canCreate, final boolean canDrop, final boolean canReference, final boolean canIndex, final boolean canAlter, final boolean canCreateTempTable, final boolean canLockTables, final boolean canCreateView, final boolean canShowView, final boolean canCreateRoutine, final boolean canAlterRoutine, final boolean canExecute, final boolean canEvent, final boolean canTrigger) throws IOException, SQLException {
        if (msu.isSpecial()) {
            throw new SQLException("Refusing to grant access to a special MySQL user: " + msu);
        }
        if (md.isSpecial()) {
            throw new SQLException("Refusing to grant access to a special MySQL database: " + md);
        }
        return this.connector.requestResult(true, AoservProtocol.CommandId.ADD, new AoservConnector.ResultRequest<Integer>(){
            private int pkey;
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.MYSQL_DB_USERS.ordinal());
                out.writeCompressedInt(md.getPkey());
                out.writeCompressedInt(msu.getPkey());
                out.writeBoolean(canSelect);
                out.writeBoolean(canInsert);
                out.writeBoolean(canUpdate);
                out.writeBoolean(canDelete);
                out.writeBoolean(canCreate);
                out.writeBoolean(canDrop);
                out.writeBoolean(canReference);
                out.writeBoolean(canIndex);
                out.writeBoolean(canAlter);
                out.writeBoolean(canCreateTempTable);
                out.writeBoolean(canLockTables);
                out.writeBoolean(canCreateView);
                out.writeBoolean(canShowView);
                out.writeBoolean(canCreateRoutine);
                out.writeBoolean(canAlterRoutine);
                out.writeBoolean(canExecute);
                out.writeBoolean(canEvent);
                out.writeBoolean(canTrigger);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.pkey = in.readCompressedInt();
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public Integer afterRelease() {
                DatabaseUserTable.this.connector.tablesUpdated(this.invalidateList);
                return this.pkey;
            }
        });
    }

    @Override
    public DatabaseUser get(int pkey) throws IOException, SQLException {
        return (DatabaseUser)this.getUniqueRow(0, pkey);
    }

    DatabaseUser getMysqlDbUser(Database db, UserServer msu) throws IOException, SQLException {
        int msuPkey = msu.getPkey();
        List<DatabaseUser> cached = this.getMysqlDbUsers(db);
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            DatabaseUser mdu = cached.get(c);
            if (mdu.getMysqlServerUser_id() != msuPkey) continue;
            return mdu;
        }
        return null;
    }

    List<DatabaseUser> getMysqlDbUsers(Server ms) throws IOException, SQLException {
        int msPkey = ms.getBind_id();
        List cached = this.getRows();
        int size = cached.size();
        ArrayList<DatabaseUser> matches = new ArrayList<DatabaseUser>(size);
        for (int c = 0; c < size; ++c) {
            DatabaseUser mdu = (DatabaseUser)cached.get(c);
            Database md = mdu.getMysqlDatabase();
            if (md == null || md.getMysqlServer_id() != msPkey) continue;
            matches.add(mdu);
        }
        return matches;
    }

    List<DatabaseUser> getMysqlDbUsers(UserServer msu) throws IOException, SQLException {
        return this.getIndexedRows(2, msu.getPkey());
    }

    List<DatabaseUser> getMysqlDbUsers(Database md) throws IOException, SQLException {
        return this.getIndexedRows(1, md.getPkey());
    }

    List<UserServer> getMysqlServerUsers(Database md) throws IOException, SQLException {
        List<DatabaseUser> cached = this.getMysqlDbUsers(md);
        int len = cached.size();
        ArrayList<UserServer> array = new ArrayList<UserServer>(len);
        for (int c = 0; c < len; ++c) {
            array.add(cached.get(c).getMysqlServerUser());
        }
        return array;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MYSQL_DB_USERS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_mysql_db_user")) {
            if (Aosh.checkParamCount("add_mysql_db_user", args, 22, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addMysqlDbUser(Aosh.parseMysqlDatabaseName(args[1], "database_name"), Aosh.parseMysqlServerName(args[2], "mysql_server"), args[3], Aosh.parseMysqlUserName(args[4], "username"), Aosh.parseBoolean(args[5], "can_select"), Aosh.parseBoolean(args[6], "can_insert"), Aosh.parseBoolean(args[7], "can_update"), Aosh.parseBoolean(args[8], "can_delete"), Aosh.parseBoolean(args[9], "can_create"), Aosh.parseBoolean(args[10], "can_drop"), Aosh.parseBoolean(args[11], "can_reference"), Aosh.parseBoolean(args[12], "can_index"), Aosh.parseBoolean(args[13], "can_alter"), Aosh.parseBoolean(args[14], "can_create_temp_table"), Aosh.parseBoolean(args[15], "can_lock_tables"), Aosh.parseBoolean(args[16], "can_create_view"), Aosh.parseBoolean(args[17], "can_show_view"), Aosh.parseBoolean(args[18], "can_create_routine"), Aosh.parseBoolean(args[19], "can_alter_routine"), Aosh.parseBoolean(args[20], "can_execute"), Aosh.parseBoolean(args[21], "can_event"), Aosh.parseBoolean(args[22], "can_trigger")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_mysql_db_user")) {
            if (Aosh.checkParamCount("remove_mysql_db_user", args, 4, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeMysqlDbUser(Aosh.parseMysqlDatabaseName(args[1], "database_name"), Aosh.parseMysqlServerName(args[2], "mysql_server"), args[3], Aosh.parseMysqlUserName(args[4], "username"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("wait_for_mysql_db_user_rebuild")) {
            if (Aosh.checkParamCount("wait_for_mysql_db_user_rebuild", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().waitForMysqlDbUserRebuild(args[1]);
            }
            return true;
        }
        return false;
    }

    public void waitForRebuild(com.aoindustries.aoserv.client.linux.Server aoServer) throws IOException, SQLException {
        this.connector.requestUpdate(true, AoservProtocol.CommandId.WAIT_FOR_REBUILD, new Object[]{Table.TableId.MYSQL_DB_USERS, aoServer.getPkey()});
    }
}

