/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.mysql;

import com.aoapps.collections.AoCollections;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.dto.DtoFactory;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.InvalidResult;
import com.aoapps.lang.validation.ValidResult;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import com.aoapps.net.Port;
import com.aoapps.net.Protocol;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.backup.MysqlReplication;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.distribution.SoftwareVersion;
import com.aoindustries.aoserv.client.dto.MysqlServerName;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.mysql.Database;
import com.aoindustries.aoserv.client.mysql.DatabaseUser;
import com.aoindustries.aoserv.client.mysql.User;
import com.aoindustries.aoserv.client.mysql.UserServer;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Server
extends CachedObjectIntegerKey<Server> {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, Server.class);
    public static final Port DEFAULT_PORT;
    public static final String VERSION_8_0_PREFIX = "8.0.";
    public static final String VERSION_5_7_PREFIX = "5.7.";
    public static final String VERSION_5_6_PREFIX = "5.6.";
    public static final String VERSION_5_1_PREFIX = "5.1.";
    public static final String VERSION_5_0_PREFIX = "5.0.";
    public static final String VERSION_4_1_PREFIX = "4.1.";
    public static final String VERSION_4_0_PREFIX = "4.0.";
    public static final PosixPath DATA_BASE_DIR;
    public static final List<String> PREFERRED_VERSION_PREFIXES;
    static final int COLUMN_BIND = 0;
    static final int COLUMN_AO_SERVER = 2;
    public static final String COLUMN_AO_SERVER_name = "ao_server";
    public static final String COLUMN_NAME_name = "name";
    @Deprecated
    public static final int MAX_SERVER_NAME_LENGTH = 255;
    private Name name;
    private int aoServer;
    private int version;
    private int maxConnections;
    private Account.Name packageName;

    @Deprecated
    public Server() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.aoServer;
            }
            case 3: {
                return this.version;
            }
            case 4: {
                return this.maxConnections;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getBind_id() {
        return this.pkey;
    }

    public Bind getBind() throws SQLException, IOException {
        Bind nb = this.table.getConnector().getNet().getBind().get(this.pkey);
        if (nb == null) {
            throw new SQLException("Unable to find NetBind: " + this.pkey);
        }
        return nb;
    }

    public Name getName() {
        return this.name;
    }

    public int getAoServer_server_pkey() {
        return this.aoServer;
    }

    public com.aoindustries.aoserv.client.linux.Server getLinuxServer() throws SQLException, IOException {
        com.aoindustries.aoserv.client.linux.Server ao = this.table.getConnector().getLinux().getServer().get(this.aoServer);
        if (ao == null) {
            throw new SQLException("Unable to find linux.Server: " + this.aoServer);
        }
        return ao;
    }

    public SoftwareVersion getVersion() throws SQLException, IOException {
        SoftwareVersion obj = this.table.getConnector().getDistribution().getSoftwareVersion().get(this.version);
        if (obj == null) {
            throw new SQLException("Unable to find TechnologyVersion: " + this.version);
        }
        if (obj.getOperatingSystemVersion(this.table.getConnector()).getPkey() != this.getLinuxServer().getHost().getOperatingSystemVersion_id()) {
            throw new SQLException("resource/operating system version mismatch on MysqlServer: #" + this.pkey);
        }
        return obj;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.name = Name.valueOf(result.getString(pos++));
            this.aoServer = result.getInt(pos++);
            this.version = result.getInt(pos++);
            this.maxConnections = result.getInt(pos++);
            this.packageName = Account.Name.valueOf(result.getString(pos++));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.name = Name.valueOf(in.readUTF()).intern();
            this.aoServer = in.readCompressedInt();
            this.version = in.readCompressedInt();
            this.maxConnections = in.readCompressedInt();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.name.toString());
        out.writeCompressedInt(this.aoServer);
        out.writeCompressedInt(this.version);
        out.writeCompressedInt(this.maxConnections);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_17) <= 0) {
            out.writeCompressedInt(this.pkey);
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_28) >= 0) {
                out.writeUTF(this.packageName.toString());
            }
        }
    }

    public int addMysqlDatabase(Database.Name name, Package pack) throws IOException, SQLException {
        return this.table.getConnector().getMysql().getDatabase().addMysqlDatabase(name, this, pack);
    }

    public PosixPath getDataDirectory() {
        try {
            return PosixPath.valueOf(DATA_BASE_DIR.toString() + '/' + this.name.toString());
        }
        catch (ValidationException e) {
            throw new AssertionError("Generated data directory should always be valid", e);
        }
    }

    public String getMinorVersion() throws SQLException, IOException {
        String techVersion = this.getVersion().getVersion();
        int pos = techVersion.indexOf(46);
        if (pos == -1) {
            return techVersion;
        }
        int pos2 = techVersion.indexOf(46, pos + 1);
        if (pos2 == -1) {
            return techVersion;
        }
        String s = techVersion.substring(0, pos2);
        if (techVersion.endsWith("-max")) {
            return s + "-max";
        }
        return s;
    }

    public Database getMysqlDatabase(Database.Name name) throws IOException, SQLException {
        return this.table.getConnector().getMysql().getDatabase().getMysqlDatabase(name, this);
    }

    public List<MysqlReplication> getFailoverMysqlReplications() throws IOException, SQLException {
        return this.table.getConnector().getBackup().getMysqlReplication().getFailoverMysqlReplications(this);
    }

    public List<Database> getMysqlDatabases() throws IOException, SQLException {
        return this.table.getConnector().getMysql().getDatabase().getMysqlDatabases(this);
    }

    public List<DatabaseUser> getMysqlDbUsers() throws IOException, SQLException {
        return this.table.getConnector().getMysql().getDatabaseUser().getMysqlDbUsers(this);
    }

    public UserServer getMysqlServerUser(User.Name username) throws IOException, SQLException {
        return this.table.getConnector().getMysql().getUserServer().getMysqlServerUser(username, this);
    }

    public List<UserServer> getMysqlServerUsers() throws IOException, SQLException {
        return this.table.getConnector().getMysql().getUserServer().getMysqlServerUsers(this);
    }

    public List<User> getMysqlUsers() throws IOException, SQLException {
        List<UserServer> psu = this.getMysqlServerUsers();
        int len = psu.size();
        ArrayList<User> pu = new ArrayList<User>(len);
        for (int c = 0; c < len; ++c) {
            pu.add(psu.get(c).getMysqlUser());
        }
        return pu;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MYSQL_SERVERS;
    }

    public boolean isMysqlDatabaseNameAvailable(Database.Name name) throws IOException, SQLException {
        return this.table.getConnector().getMysql().getDatabase().isMysqlDatabaseNameAvailable(name, this);
    }

    public void restartMysql() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.RESTART_MYSQL, this.pkey);
    }

    public void startMysql() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.START_MYSQL, this.pkey);
    }

    public void stopMysql() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.STOP_MYSQL, this.pkey);
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.name + " on " + this.getLinuxServer().getHostname();
    }

    public MasterStatus getMasterStatus() throws IOException, SQLException {
        return this.table.getConnector().requestResult(true, AoservProtocol.CommandId.GET_MYSQL_MASTER_STATUS, new AoservConnector.ResultRequest<MasterStatus>(){
            private MasterStatus result;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Server.this.pkey);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code == 0) {
                    this.result = new MasterStatus(in.readNullUTF(), in.readNullUTF());
                } else if (code == 1) {
                    this.result = null;
                } else {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
            }

            @Override
            public MasterStatus afterRelease() {
                return this.result;
            }
        });
    }

    static {
        try {
            DEFAULT_PORT = Port.valueOf((int)3306, (Protocol)Protocol.TCP);
        }
        catch (ValidationException e) {
            throw new AssertionError("These hard-coded values are valid", e);
        }
        try {
            DATA_BASE_DIR = PosixPath.valueOf("/var/lib/mysql");
        }
        catch (ValidationException e) {
            throw new AssertionError("These hard-coded values are valid", e);
        }
        PREFERRED_VERSION_PREFIXES = Collections.unmodifiableList(Arrays.asList(VERSION_8_0_PREFIX, VERSION_5_7_PREFIX, VERSION_5_6_PREFIX, VERSION_5_1_PREFIX, VERSION_5_0_PREFIX, VERSION_4_1_PREFIX, VERSION_4_0_PREFIX));
    }

    public static final class MasterStatus {
        private final String file;
        private final String position;

        public MasterStatus(String file, String position) {
            this.file = file;
            this.position = position;
        }

        public String getFile() {
            return this.file;
        }

        public String getPosition() {
            return this.position;
        }
    }

    @Deprecated
    public static enum ReservedWord {
        ACTION,
        ADD,
        AFTER,
        AGGREGATE,
        ALL,
        ALTER,
        AND,
        AS,
        ASC,
        AUTO_INCREMENT,
        AVG,
        AVG_ROW_LENGTH,
        BETWEEN,
        BIGINT,
        BINARY,
        BIT,
        BLOB,
        BOOL,
        BOTH,
        BY,
        CASCADE,
        CASE,
        CHANGE,
        CHAR,
        CHARACTER,
        CHECK,
        CHECKSUM,
        COLUMN,
        COLUMNS,
        COMMENT,
        CONSTRAINT,
        CREATE,
        CROSS,
        CURRENT_DATE,
        CURRENT_TIME,
        CURRENT_TIMESTAMP,
        DATA,
        DATABASE,
        DATABASES,
        DATE,
        DATETIME,
        DAY,
        DAY_HOUR,
        DAY_MINUTE,
        DAY_SECOND,
        DAYOFMONTH,
        DAYOFWEEK,
        DAYOFYEAR,
        DEC,
        DECIMAL,
        DEFAULT,
        DELAY_KEY_WRITE,
        DELAYED,
        DELETE,
        DESC,
        DESCRIBE,
        DISTINCT,
        DISTINCTROW,
        DOUBLE,
        DROP,
        ELSE,
        ENCLOSED,
        END,
        ENUM,
        ESCAPE,
        ESCAPED,
        EXISTS,
        EXPLAIN,
        FIELDS,
        FILE,
        FIRST,
        FLOAT,
        FLOAT4,
        FLOAT8,
        FLUSH,
        FOR,
        FOREIGN,
        FROM,
        FULL,
        FUNCTION,
        GLOBAL,
        GRANT,
        GRANTS,
        GROUP,
        HAVING,
        HEAP,
        HIGH_PRIORITY,
        HOSTS,
        HOUR,
        HOUR_MINUTE,
        HOUR_SECOND,
        IDENTIFIED,
        IF,
        IGNORE,
        IN,
        INDEX,
        INFILE,
        INNER,
        INSERT,
        INSERT_ID,
        INT,
        INT1,
        INT2,
        INT3,
        INT4,
        INT8,
        INTEGER,
        INTERVAL,
        INTO,
        IS,
        ISAM,
        JOIN,
        KEY,
        KEYS,
        KILL,
        LAST_INSERT_ID,
        LEADING,
        LEFT,
        LENGTH,
        LIKE,
        LIMIT,
        LINES,
        LOAD,
        LOCAL,
        LOCK,
        LOGS,
        LONG,
        LONGBLOB,
        LONGTEXT,
        LOW_PRIORITY,
        MATCH,
        MAX,
        MAX_ROWS,
        MEDIUMBLOB,
        MEDIUMINT,
        MEDIUMTEXT,
        MIDDLEINT,
        MIN_ROWS,
        MINUTE,
        MINUTE_SECOND,
        MODIFY,
        MONTH,
        MONTHNAME,
        MYISAM,
        NATURAL,
        NO,
        NOT,
        NULL,
        NUMERIC,
        ON,
        OPTIMIZE,
        OPTION,
        OPTIONALLY,
        OR,
        ORDER,
        OUTER,
        OUTFILE,
        PACK_KEYS,
        PARTIAL,
        PASSWORD,
        PRECISION,
        PRIMARY,
        PRIVILEGES,
        PROCEDURE,
        PROCESS,
        PROCESSLIST,
        READ,
        REAL,
        REFERENCES,
        REGEXP,
        RELOAD,
        RENAME,
        REPLACE,
        RESTRICT,
        RETURNS,
        REVOKE,
        RLIKE,
        ROW,
        ROWS,
        SECOND,
        SELECT,
        SET,
        SHOW,
        SHUTDOWN,
        SMALLINT,
        SONAME,
        SQL_BIG_RESULT,
        SQL_BIG_SELECTS,
        SQL_BIG_TABLES,
        SQL_LOG_OFF,
        SQL_LOG_UPDATE,
        SQL_LOW_PRIORITY_UPDATES,
        SQL_SELECT_LIMIT,
        SQL_SMALL_RESULT,
        SQL_WARNINGS,
        STARTING,
        STATUS,
        STRAIGHT_JOIN,
        STRING,
        TABLE,
        TABLES,
        TEMPORARY,
        TERMINATED,
        TEXT,
        THEN,
        TIME,
        TIMESTAMP,
        TINYBLOB,
        TINYINT,
        TINYTEXT,
        TO,
        TRAILING,
        TYPE,
        UNIQUE,
        UNLOCK,
        UNSIGNED,
        UPDATE,
        USAGE,
        USE,
        USING,
        VALUES,
        VARBINARY,
        VARCHAR,
        VARIABLES,
        VARYING,
        WHEN,
        WHERE,
        WITH,
        WRITE,
        YEAR,
        YEAR_MONTH,
        ZEROFILL;

        private static volatile Set<String> reservedWords;

        public static boolean isReservedWord(String value) {
            HashSet words = reservedWords;
            if (words == null) {
                ReservedWord[] values = ReservedWord.values();
                words = AoCollections.newHashSet((int)values.length);
                for (ReservedWord word : values) {
                    words.add(word.name().toUpperCase(Locale.ROOT));
                }
                reservedWords = words;
            }
            return words.contains(value.toUpperCase(Locale.ROOT));
        }

        static {
            reservedWords = null;
        }
    }

    public static final class Name
    implements Comparable<Name>,
    Serializable,
    DtoFactory<MysqlServerName>,
    Internable<Name> {
        private static final long serialVersionUID = 6148467549389988813L;
        public static final int MAX_LENGTH = 255;
        private static final ConcurrentMap<String, Name> interned = new ConcurrentHashMap<String, Name>();
        private final String name;

        public static ValidationResult validate(String name) {
            if (name == null) {
                return new InvalidResult(RESOURCES, "Name.validate.isNull");
            }
            int len = name.length();
            if (len == 0) {
                return new InvalidResult(RESOURCES, "Name.validate.isEmpty");
            }
            if (len > 255) {
                return new InvalidResult(RESOURCES, "Name.validate.tooLong", new Serializable[]{Integer.valueOf(255), Integer.valueOf(len)});
            }
            char ch = name.charAt(0);
            if (!(ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9')) {
                return new InvalidResult(RESOURCES, "Name.validate.startAtoZor0to9");
            }
            for (int c = 1; c < len; ++c) {
                ch = name.charAt(c);
                if (ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '.' || ch == '-' || ch == '_') continue;
                return new InvalidResult(RESOURCES, "Name.validate.illegalCharacter");
            }
            return ValidResult.getInstance();
        }

        public static Name valueOf(String name) throws ValidationException {
            if (name == null) {
                return null;
            }
            return new Name(name, true);
        }

        private Name(String name, boolean validate) throws ValidationException {
            this.name = name;
            if (validate) {
                this.validate();
            }
        }

        private Name(String name) {
            ValidationResult result;
            assert ((result = Name.validate(name)).isValid()) : result.toString();
            this.name = name;
        }

        private void validate() throws ValidationException {
            ValidationResult result = Name.validate(this.name);
            if (!result.isValid()) {
                throw new ValidationException(result);
            }
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            try {
                this.validate();
            }
            catch (ValidationException err) {
                InvalidObjectException newErr = new InvalidObjectException(err.getMessage());
                newErr.initCause(err);
                throw newErr;
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof Name && this.name.equals(((Name)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(Name other) {
            return this == other ? 0 : this.name.compareTo(other.name);
        }

        public String toString() {
            return this.name;
        }

        public Name intern() {
            Name addMe;
            String internedName;
            Name existing = (Name)interned.get(this.name);
            if (existing == null && (existing = interned.putIfAbsent(internedName, addMe = this.name == (internedName = this.name.intern()) ? this : new Name(internedName))) == null) {
                existing = addMe;
            }
            return existing;
        }

        public MysqlServerName getDto() {
            return new MysqlServerName(this.name);
        }
    }
}

