/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.mysql;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.lang.validation.ValidationResult;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.distribution.SoftwareVersion;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class ServerTable
extends CachedTableIntegerKey<Server> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("ao_server.hostname", true), new AoservTable.OrderBy("name", true)};

    ServerTable(AoservConnector connector) {
        super(connector, Server.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addMysqlServer(Server.Name name, Server aoServer, SoftwareVersion version, int maxConnections) throws SQLException, IOException {
        if (!version.getTechnologyName_name().equals("MySQL")) {
            throw new SQLException("TechnologyVersion must have name of MySQL: " + version.getTechnologyName_name());
        }
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.MYSQL_SERVERS, name, aoServer.getPkey(), version.getPkey(), maxConnections});
    }

    @Override
    public Server get(int bind) throws IOException, SQLException {
        return (Server)this.getUniqueRow(0, bind);
    }

    public Server getMysqlServer(Bind nb) throws IOException, SQLException {
        return (Server)this.getUniqueRow(0, nb.getId());
    }

    public List<Server> getMysqlServers(com.aoindustries.aoserv.client.linux.Server ao) throws IOException, SQLException {
        return this.getIndexedRows(2, ao.getPkey());
    }

    public Server getMysqlServer(Server.Name name, com.aoindustries.aoserv.client.linux.Server ao) throws IOException, SQLException {
        List<Server> table = this.getMysqlServers(ao);
        int size = table.size();
        for (int c = 0; c < size; ++c) {
            Server ms = table.get(c);
            if (!ms.getName().equals(name)) continue;
            return ms;
        }
        return null;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MYSQL_SERVERS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("check_mysql_server_name")) {
            if (Aosh.checkParamCount("check_mysql_server_name", args, 1, (PrintWriter)err)) {
                ValidationResult validationResult = Server.Name.validate(args[1]);
                out.println(validationResult.isValid());
                out.flush();
                if (!validationResult.isValid()) {
                    err.print("aosh: check_mysql_server_name: ");
                    err.println(validationResult.toString());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("is_mysql_server_name_available")) {
            if (Aosh.checkParamCount("is_mysql_server_name_available", args, 2, (PrintWriter)err)) {
                try {
                    out.println(this.connector.getSimpleClient().isMysqlServerNameAvailable(Aosh.parseMysqlServerName(args[1], "server_name"), args[2]));
                    out.flush();
                }
                catch (IllegalArgumentException iae) {
                    err.print("aosh: is_mysql_server_name_available: ");
                    err.println(iae.getMessage());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("restart_mysql")) {
            if (Aosh.checkParamCount("restart_mysql", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().restartMysql(Aosh.parseMysqlServerName(args[1], "mysql_server"), args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("start_mysql")) {
            if (Aosh.checkParamCount("start_mysql", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().startMysql(Aosh.parseMysqlServerName(args[1], "mysql_server"), args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("stop_mysql")) {
            if (Aosh.checkParamCount("stop_mysql", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().stopMysql(Aosh.parseMysqlServerName(args[1], "mysql_server"), args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("wait_for_mysql_server_rebuild")) {
            if (Aosh.checkParamCount("wait_for_mysql_server_rebuild", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().waitForMysqlServerRebuild(args[1]);
            }
            return true;
        }
        return false;
    }

    public boolean isMysqlServerNameAvailable(Server.Name name, com.aoindustries.aoserv.client.linux.Server ao) throws IOException, SQLException {
        return this.connector.requestBooleanQuery(true, AoservProtocol.CommandId.IS_MYSQL_SERVER_NAME_AVAILABLE, name, ao.getPkey());
    }

    public void waitForRebuild(com.aoindustries.aoserv.client.linux.Server aoServer) throws IOException, SQLException {
        this.connector.requestUpdate(true, AoservProtocol.CommandId.WAIT_FOR_REBUILD, new Object[]{Table.TableId.MYSQL_SERVERS, aoServer.getPkey()});
    }
}

