/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.mysql;

import com.aoapps.lang.dto.DtoFactory;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.validation.InvalidResult;
import com.aoapps.lang.validation.ValidResult;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import com.aoindustries.aoserv.client.dto.MysqlTableName;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ResourceBundle;

public final class TableName
implements Comparable<TableName>,
Serializable,
DtoFactory<MysqlTableName> {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, (Package)TableName.class.getPackage(), null, (String)"Table.Name.");
    private static final long serialVersionUID = -4427431696460618301L;
    public static final int MAX_LENGTH = 64;
    private final String name;

    public static ValidationResult validate(String name) {
        if (name == null) {
            return new InvalidResult(RESOURCES, "validate.isNull");
        }
        int len = name.length();
        if (len == 0) {
            return new InvalidResult(RESOURCES, "validate.isEmpty");
        }
        if (len > 64) {
            return new InvalidResult(RESOURCES, "validate.tooLong", new Serializable[]{Integer.valueOf(64), Integer.valueOf(len)});
        }
        char ch = name.charAt(0);
        if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_')) {
            return new InvalidResult(RESOURCES, "validate.badFirstCharacter");
        }
        for (int c = 1; c < len; ++c) {
            ch = name.charAt(c);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '-' || ch == '$') continue;
            return new InvalidResult(RESOURCES, "validate.illegalCharacter");
        }
        return ValidResult.getInstance();
    }

    public static TableName valueOf(String name) throws ValidationException {
        if (name == null) {
            return null;
        }
        return new TableName(name);
    }

    private TableName(String name) throws ValidationException {
        this.name = name;
        this.validate();
    }

    private void validate() throws ValidationException {
        ValidationResult result = TableName.validate(this.name);
        if (!result.isValid()) {
            throw new ValidationException(result);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        try {
            this.validate();
        }
        catch (ValidationException err) {
            InvalidObjectException newErr = new InvalidObjectException(err.getMessage());
            newErr.initCause(err);
            throw newErr;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof TableName && this.name.equals(((TableName)obj).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(TableName other) {
        return this == other ? 0 : this.name.compareTo(other.name);
    }

    public String toString() {
        return this.name;
    }

    public MysqlTableName getDto() {
        return new MysqlTableName(this.name);
    }
}

