/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.mysql;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.io.FastExternalizable;
import com.aoapps.lang.validation.InvalidResult;
import com.aoapps.lang.validation.ValidResult;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Disablable;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.dto.MysqlUserName;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.mysql.CachedObjectUserNameKey;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.mysql.UserServer;
import com.aoindustries.aoserv.client.password.PasswordChecker;
import com.aoindustries.aoserv.client.password.PasswordProtected;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class User
extends CachedObjectUserNameKey<User>
implements PasswordProtected,
Removable,
Disablable {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, User.class);
    static final int COLUMN_USERNAME = 0;
    static final String COLUMN_USERNAME_name = "username";
    @Deprecated
    public static final int MAX_USERNAME_LENGTH = 32;
    public static final Name ROOT;
    public static final Name MYSQL_SESSION;
    public static final Name MYSQL_SYS;
    public static final Name MYSQLMON;
    public static final String NO_PASSWORD;
    public static final String NO_PASSWORD_DB_VALUE = "*";
    private boolean selectPriv;
    private boolean insertPriv;
    private boolean updatePriv;
    private boolean deletePriv;
    private boolean createPriv;
    private boolean dropPriv;
    private boolean reloadPriv;
    private boolean shutdownPriv;
    private boolean processPriv;
    private boolean filePriv;
    private boolean grantPriv;
    private boolean referencesPriv;
    private boolean indexPriv;
    private boolean alterPriv;
    private boolean showDbPriv;
    private boolean superPriv;
    private boolean createTmpTablePriv;
    private boolean lockTablesPriv;
    private boolean executePriv;
    private boolean replSlavePriv;
    private boolean replClientPriv;
    private boolean createViewPriv;
    private boolean showViewPriv;
    private boolean createRoutinePriv;
    private boolean alterRoutinePriv;
    private boolean createUserPriv;
    private boolean eventPriv;
    private boolean triggerPriv;
    private int disableLog;

    public static boolean isSpecial(Name username) {
        return username.equals(ROOT) || username.equals(MYSQL_SESSION) || username.equals(MYSQL_SYS) || username.equals(MYSQLMON);
    }

    @Deprecated
    public User() {
    }

    public int addMysqlServerUser(Server mysqlServer, String host) throws IOException, SQLException {
        return this.table.getConnector().getMysql().getUserServer().addMysqlServerUser(this.pkey, mysqlServer, host);
    }

    @Override
    public int arePasswordsSet() throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to check if passwords set on special MySQL user: " + this);
        }
        return com.aoindustries.aoserv.client.account.User.groupPasswordsSet(this.getMysqlServerUsers());
    }

    public boolean canAlter() {
        return this.alterPriv;
    }

    public boolean canShowDb() {
        return this.showDbPriv;
    }

    public boolean isSuper() {
        return this.superPriv;
    }

    public boolean canCreateTempTable() {
        return this.createTmpTablePriv;
    }

    public boolean canLockTables() {
        return this.lockTablesPriv;
    }

    public boolean canExecute() {
        return this.executePriv;
    }

    public boolean isReplicationSlave() {
        return this.replSlavePriv;
    }

    public boolean isReplicationClient() {
        return this.replClientPriv;
    }

    public boolean canCreateView() {
        return this.createViewPriv;
    }

    public boolean canShowView() {
        return this.showViewPriv;
    }

    public boolean canCreateRoutine() {
        return this.createRoutinePriv;
    }

    public boolean canAlterRoutine() {
        return this.alterRoutinePriv;
    }

    public boolean canCreateUser() {
        return this.createUserPriv;
    }

    public boolean canEvent() {
        return this.eventPriv;
    }

    public boolean canTrigger() {
        return this.triggerPriv;
    }

    public boolean canCreate() {
        return this.createPriv;
    }

    public boolean canDelete() {
        return this.deletePriv;
    }

    @Override
    public boolean canDisable() throws IOException, SQLException {
        if (this.isDisabled() || this.isSpecial()) {
            return false;
        }
        for (UserServer msu : this.getMysqlServerUsers()) {
            if (msu.isDisabled()) continue;
            return false;
        }
        return true;
    }

    public boolean canDrop() {
        return this.dropPriv;
    }

    @Override
    public boolean canEnable() throws SQLException, IOException {
        if (this.isSpecial()) {
            return false;
        }
        DisableLog dl = this.getDisableLog();
        if (dl == null) {
            return false;
        }
        return dl.canEnable() && !this.getUsername().isDisabled();
    }

    public boolean canFile() {
        return this.filePriv;
    }

    public boolean canGrant() {
        return this.grantPriv;
    }

    public boolean canIndex() {
        return this.indexPriv;
    }

    public boolean canInsert() {
        return this.insertPriv;
    }

    public boolean canProcess() {
        return this.processPriv;
    }

    public boolean canReference() {
        return this.referencesPriv;
    }

    public boolean canReload() {
        return this.reloadPriv;
    }

    public boolean canSelect() {
        return this.selectPriv;
    }

    public boolean canShutdown() {
        return this.shutdownPriv;
    }

    public boolean canUpdate() {
        return this.updatePriv;
    }

    @Override
    public List<PasswordChecker.Result> checkPassword(String password) throws IOException {
        return User.checkPassword(this.pkey, password);
    }

    public static List<PasswordChecker.Result> checkPassword(Name username, String password) throws IOException {
        return PasswordChecker.checkPassword(username, password, PasswordChecker.PasswordStrength.STRICT);
    }

    @Override
    public void disable(DisableLog dl) throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to disable special MySQL user: " + this);
        }
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.DISABLE, new Object[]{Table.TableId.MYSQL_USERS, dl.getPkey(), this.pkey});
    }

    @Override
    public void enable() throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to enable special MySQL user: " + this);
        }
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.ENABLE, new Object[]{Table.TableId.MYSQL_USERS, this.pkey});
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.selectPriv;
            }
            case 2: {
                return this.insertPriv;
            }
            case 3: {
                return this.updatePriv;
            }
            case 4: {
                return this.deletePriv;
            }
            case 5: {
                return this.createPriv;
            }
            case 6: {
                return this.dropPriv;
            }
            case 7: {
                return this.reloadPriv;
            }
            case 8: {
                return this.shutdownPriv;
            }
            case 9: {
                return this.processPriv;
            }
            case 10: {
                return this.filePriv;
            }
            case 11: {
                return this.grantPriv;
            }
            case 12: {
                return this.referencesPriv;
            }
            case 13: {
                return this.indexPriv;
            }
            case 14: {
                return this.alterPriv;
            }
            case 15: {
                return this.showDbPriv;
            }
            case 16: {
                return this.superPriv;
            }
            case 17: {
                return this.createTmpTablePriv;
            }
            case 18: {
                return this.lockTablesPriv;
            }
            case 19: {
                return this.executePriv;
            }
            case 20: {
                return this.replSlavePriv;
            }
            case 21: {
                return this.replClientPriv;
            }
            case 22: {
                return this.createViewPriv;
            }
            case 23: {
                return this.showViewPriv;
            }
            case 24: {
                return this.createRoutinePriv;
            }
            case 25: {
                return this.alterRoutinePriv;
            }
            case 26: {
                return this.createUserPriv;
            }
            case 27: {
                return this.eventPriv;
            }
            case 28: {
                return this.triggerPriv;
            }
            case 29: {
                return this.getDisableLog_id();
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public boolean isDisabled() {
        return this.disableLog != -1;
    }

    public Integer getDisableLog_id() {
        return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
    }

    @Override
    public DisableLog getDisableLog() throws SQLException, IOException {
        if (this.disableLog == -1) {
            return null;
        }
        DisableLog obj = this.table.getConnector().getAccount().getDisableLog().get(this.disableLog);
        if (obj == null) {
            throw new SQLException("Unable to find DisableLog: " + this.disableLog);
        }
        return obj;
    }

    public UserServer getMysqlServerUser(Server mysqlServer) throws IOException, SQLException {
        return this.table.getConnector().getMysql().getUserServer().getMysqlServerUser(this.pkey, mysqlServer);
    }

    public List<UserServer> getMysqlServerUsers() throws IOException, SQLException {
        return this.table.getConnector().getMysql().getUserServer().getMysqlServerUsers(this);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MYSQL_USERS;
    }

    public Name getUsername_id() {
        return this.pkey;
    }

    public com.aoindustries.aoserv.client.account.User getUsername() throws SQLException, IOException {
        com.aoindustries.aoserv.client.account.User obj = this.table.getConnector().getAccount().getUser().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find Username: " + this.pkey);
        }
        return obj;
    }

    public boolean isSpecial() {
        return User.isSpecial(this.pkey);
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = Name.valueOf(result.getString(1));
            this.selectPriv = result.getBoolean(2);
            this.insertPriv = result.getBoolean(3);
            this.updatePriv = result.getBoolean(4);
            this.deletePriv = result.getBoolean(5);
            this.createPriv = result.getBoolean(6);
            this.dropPriv = result.getBoolean(7);
            this.reloadPriv = result.getBoolean(8);
            this.shutdownPriv = result.getBoolean(9);
            this.processPriv = result.getBoolean(10);
            this.filePriv = result.getBoolean(11);
            this.grantPriv = result.getBoolean(12);
            this.referencesPriv = result.getBoolean(13);
            this.indexPriv = result.getBoolean(14);
            this.alterPriv = result.getBoolean(15);
            this.showDbPriv = result.getBoolean(16);
            this.superPriv = result.getBoolean(17);
            this.createTmpTablePriv = result.getBoolean(18);
            this.lockTablesPriv = result.getBoolean(19);
            this.executePriv = result.getBoolean(20);
            this.replSlavePriv = result.getBoolean(21);
            this.replClientPriv = result.getBoolean(22);
            this.createViewPriv = result.getBoolean(23);
            this.showViewPriv = result.getBoolean(24);
            this.createRoutinePriv = result.getBoolean(25);
            this.alterRoutinePriv = result.getBoolean(26);
            this.createUserPriv = result.getBoolean(27);
            this.eventPriv = result.getBoolean(28);
            this.triggerPriv = result.getBoolean(29);
            this.disableLog = result.getInt(30);
            if (result.wasNull()) {
                this.disableLog = -1;
            }
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = Name.valueOf(in.readUTF()).intern();
            this.selectPriv = in.readBoolean();
            this.insertPriv = in.readBoolean();
            this.updatePriv = in.readBoolean();
            this.deletePriv = in.readBoolean();
            this.createPriv = in.readBoolean();
            this.dropPriv = in.readBoolean();
            this.reloadPriv = in.readBoolean();
            this.shutdownPriv = in.readBoolean();
            this.processPriv = in.readBoolean();
            this.filePriv = in.readBoolean();
            this.grantPriv = in.readBoolean();
            this.referencesPriv = in.readBoolean();
            this.indexPriv = in.readBoolean();
            this.alterPriv = in.readBoolean();
            this.showDbPriv = in.readBoolean();
            this.superPriv = in.readBoolean();
            this.createTmpTablePriv = in.readBoolean();
            this.lockTablesPriv = in.readBoolean();
            this.executePriv = in.readBoolean();
            this.replSlavePriv = in.readBoolean();
            this.replClientPriv = in.readBoolean();
            this.createViewPriv = in.readBoolean();
            this.showViewPriv = in.readBoolean();
            this.createRoutinePriv = in.readBoolean();
            this.alterRoutinePriv = in.readBoolean();
            this.createUserPriv = in.readBoolean();
            this.eventPriv = in.readBoolean();
            this.triggerPriv = in.readBoolean();
            this.disableLog = in.readCompressedInt();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<User>> getCannotRemoveReasons() {
        ArrayList<CannotRemoveReason<User>> reasons = new ArrayList<CannotRemoveReason<User>>();
        if (this.isSpecial()) {
            reasons.add(new CannotRemoveReason<User>("Not allowed to remove a special MySQL user: " + this.pkey, this));
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to remove special MySQL user: " + this);
        }
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.MYSQL_USERS, this.pkey});
    }

    @Override
    public void setPassword(String password) throws IOException, SQLException {
        for (UserServer user : this.getMysqlServerUsers()) {
            user.setPassword(password);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey.toString());
        out.writeBoolean(this.selectPriv);
        out.writeBoolean(this.insertPriv);
        out.writeBoolean(this.updatePriv);
        out.writeBoolean(this.deletePriv);
        out.writeBoolean(this.createPriv);
        out.writeBoolean(this.dropPriv);
        out.writeBoolean(this.reloadPriv);
        out.writeBoolean(this.shutdownPriv);
        out.writeBoolean(this.processPriv);
        out.writeBoolean(this.filePriv);
        out.writeBoolean(this.grantPriv);
        out.writeBoolean(this.referencesPriv);
        out.writeBoolean(this.indexPriv);
        out.writeBoolean(this.alterPriv);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_111) >= 0) {
            out.writeBoolean(this.showDbPriv);
            out.writeBoolean(this.superPriv);
            out.writeBoolean(this.createTmpTablePriv);
            out.writeBoolean(this.lockTablesPriv);
            out.writeBoolean(this.executePriv);
            out.writeBoolean(this.replSlavePriv);
            out.writeBoolean(this.replClientPriv);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_4) >= 0) {
            out.writeBoolean(this.createViewPriv);
            out.writeBoolean(this.showViewPriv);
            out.writeBoolean(this.createRoutinePriv);
            out.writeBoolean(this.alterRoutinePriv);
            out.writeBoolean(this.createUserPriv);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_54) >= 0) {
            out.writeBoolean(this.eventPriv);
            out.writeBoolean(this.triggerPriv);
        }
        out.writeCompressedInt(this.disableLog);
    }

    @Override
    public boolean canSetPassword() {
        return !this.isDisabled() && !this.isSpecial();
    }

    static {
        try {
            ROOT = Name.valueOf("root").intern();
            MYSQL_SESSION = Name.valueOf("mysql.session").intern();
            MYSQL_SYS = Name.valueOf("mysql.sys").intern();
            MYSQLMON = Name.valueOf("mysqlmon").intern();
        }
        catch (ValidationException e) {
            throw new AssertionError("These hard-coded values are valid", e);
        }
        NO_PASSWORD = null;
    }

    public static final class Name
    extends User.Name
    implements FastExternalizable {
        public static final int MYSQL_NAME_MAX_LENGTH = 32;
        private static final ConcurrentMap<String, Name> interned = new ConcurrentHashMap<String, Name>();
        private static final long serialVersionUID = 2L;

        public static ValidationResult validate(String name) {
            if (name == null) {
                return new InvalidResult(RESOURCES, "Name.validate.isNull");
            }
            if (!"mysql.sys".equals(name) && !"mysql.session".equals(name)) {
                int len = name.length();
                if (len == 0) {
                    return new InvalidResult(RESOURCES, "Name.validate.isEmpty");
                }
                if (len > 32) {
                    return new InvalidResult(RESOURCES, "Name.validate.tooLong", new Serializable[]{Integer.valueOf(32), Integer.valueOf(len)});
                }
                char ch = name.charAt(0);
                if (!(ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9')) {
                    return new InvalidResult(RESOURCES, "Name.validate.startAtoZor0to9");
                }
                for (int c = 1; c < len; ++c) {
                    ch = name.charAt(c);
                    if (ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_') continue;
                    return new InvalidResult(RESOURCES, "Name.validate.illegalCharacter");
                }
            }
            assert (User.Name.validate(name).isValid()) : "A MySQL User.Name is always a valid Linux User.Name.";
            return ValidResult.getInstance();
        }

        public static Name valueOf(String name) throws ValidationException {
            if (name == null) {
                return null;
            }
            return new Name(name, true);
        }

        private Name(String name, boolean validate) throws ValidationException {
            super(name, validate);
        }

        private Name(String name) {
            super(name);
        }

        @Override
        protected void validate() throws ValidationException {
            ValidationResult result = Name.validate(this.name);
            if (!result.isValid()) {
                throw new ValidationException(result);
            }
        }

        @Override
        public Name intern() {
            Name addMe;
            String internedId;
            Name existing = (Name)interned.get(this.name);
            if (existing == null && (existing = interned.putIfAbsent(internedId, addMe = this.name == (internedId = this.name.intern()) ? this : new Name(internedId))) == null) {
                existing = addMe;
            }
            return existing;
        }

        @Override
        public MysqlUserName getDto() {
            return new MysqlUserName(this.name);
        }

        @Deprecated
        public Name() {
        }

        @Override
        public long getSerialVersionUID() {
            return 2L;
        }
    }
}

