/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.mysql;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Disablable;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.mysql.DatabaseUser;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.mysql.User;
import com.aoindustries.aoserv.client.password.PasswordChecker;
import com.aoindustries.aoserv.client.password.PasswordProtected;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class UserServer
extends CachedObjectIntegerKey<UserServer>
implements Removable,
PasswordProtected,
Disablable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_USERNAME = 1;
    static final int COLUMN_MYSQL_SERVER = 2;
    static final String COLUMN_USERNAME_name = "username";
    static final String COLUMN_MYSQL_SERVER_name = "mysql_server";
    public static final int UNLIMITED_QUESTIONS = 0;
    public static final int DEFAULT_MAX_QUESTIONS = 0;
    public static final int UNLIMITED_UPDATES = 0;
    public static final int DEFAULT_MAX_UPDATES = 0;
    public static final int UNLIMITED_CONNECTIONS = 0;
    public static final int DEFAULT_MAX_CONNECTIONS = 0;
    public static final int UNLIMITED_USER_CONNECTIONS = 0;
    public static final int DEFAULT_MAX_USER_CONNECTIONS = 0;
    public static final int MAX_HOST_LENGTH = 60;
    public static final String ANY_HOST = "%";
    public static final String ANY_LOCAL_HOST = null;
    private User.Name username;
    private int mysqlServer;
    private String host;
    private int disableLog;
    private String predisablePassword;
    private int maxQuestions;
    private int maxUpdates;
    private int maxConnections;
    private int maxUserConnections;

    @Deprecated
    public UserServer() {
    }

    @Override
    public int arePasswordsSet() throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to check if passwords set on special MySQL user: " + this);
        }
        return this.table.getConnector().requestBooleanQuery(true, AoservProtocol.CommandId.IS_MYSQL_SERVER_USER_PASSWORD_SET, this.pkey) ? 2 : 0;
    }

    @Override
    public boolean canDisable() {
        return !this.isDisabled() && !this.isSpecial();
    }

    @Override
    public boolean canEnable() throws SQLException, IOException {
        if (this.isSpecial()) {
            return false;
        }
        DisableLog dl = this.getDisableLog();
        if (dl == null) {
            return false;
        }
        return dl.canEnable() && !this.getMysqlUser().isDisabled();
    }

    @Override
    public List<PasswordChecker.Result> checkPassword(String password) throws IOException {
        return User.checkPassword(this.username, password);
    }

    @Override
    public void disable(DisableLog dl) throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to disable special MySQL user: " + this);
        }
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.DISABLE, new Object[]{Table.TableId.MYSQL_SERVER_USERS, dl.getPkey(), this.pkey});
    }

    @Override
    public void enable() throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to enable special MySQL user: " + this);
        }
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.ENABLE, new Object[]{Table.TableId.MYSQL_SERVER_USERS, this.pkey});
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.username;
            }
            case 2: {
                return this.mysqlServer;
            }
            case 3: {
                return this.host;
            }
            case 4: {
                return this.getDisableLog_id();
            }
            case 5: {
                return this.predisablePassword;
            }
            case 6: {
                return this.maxQuestions;
            }
            case 7: {
                return this.maxUpdates;
            }
            case 8: {
                return this.maxConnections;
            }
            case 9: {
                return this.maxUserConnections;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public boolean isDisabled() {
        return this.disableLog != -1;
    }

    public Integer getDisableLog_id() {
        return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
    }

    @Override
    public DisableLog getDisableLog() throws SQLException, IOException {
        if (this.disableLog == -1) {
            return null;
        }
        DisableLog obj = this.table.getConnector().getAccount().getDisableLog().get(this.disableLog);
        if (obj == null) {
            throw new SQLException("Unable to find DisableLog: " + this.disableLog);
        }
        return obj;
    }

    public String getHost() {
        return this.host;
    }

    public List<DatabaseUser> getMysqlDbUsers() throws IOException, SQLException {
        return this.table.getConnector().getMysql().getDatabaseUser().getMysqlDbUsers(this);
    }

    public User.Name getMysqlUser_username() {
        return this.username;
    }

    public User getMysqlUser() throws SQLException, IOException {
        User obj = this.table.getConnector().getMysql().getUser().get(this.username);
        if (obj == null) {
            throw new SQLException("Unable to find MysqlUser: " + this.username);
        }
        return obj;
    }

    public boolean isSpecial() {
        return User.isSpecial(this.username);
    }

    public String getPredisablePassword() {
        return this.predisablePassword;
    }

    public int getMaxQuestions() {
        return this.maxQuestions;
    }

    public int getMaxUpdates() {
        return this.maxUpdates;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMaxUserConnections() {
        return this.maxUserConnections;
    }

    public int getMysqlServer_id() {
        return this.mysqlServer;
    }

    public Server getMysqlServer() throws IOException, SQLException {
        return this.table.getConnector().getMysql().getServer().get(this.mysqlServer);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MYSQL_SERVER_USERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.username = User.Name.valueOf(result.getString(2));
            this.mysqlServer = result.getInt(3);
            this.host = result.getString(4);
            this.disableLog = result.getInt(5);
            if (result.wasNull()) {
                this.disableLog = -1;
            }
            this.predisablePassword = result.getString(6);
            this.maxQuestions = result.getInt(7);
            this.maxUpdates = result.getInt(8);
            this.maxConnections = result.getInt(9);
            this.maxUserConnections = result.getInt(10);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.username = User.Name.valueOf(in.readUTF()).intern();
            this.mysqlServer = in.readCompressedInt();
            this.host = InternUtils.intern((String)in.readNullUTF());
            this.disableLog = in.readCompressedInt();
            this.predisablePassword = in.readNullUTF();
            this.maxQuestions = in.readCompressedInt();
            this.maxUpdates = in.readCompressedInt();
            this.maxConnections = in.readCompressedInt();
            this.maxUserConnections = in.readCompressedInt();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<UserServer>> getCannotRemoveReasons() throws SQLException, IOException {
        ArrayList<CannotRemoveReason<UserServer>> reasons = new ArrayList<CannotRemoveReason<UserServer>>();
        if (this.isSpecial()) {
            Server ms = this.getMysqlServer();
            reasons.add(new CannotRemoveReason<UserServer>("Not allowed to remove a special MySQL user: " + this.username + " on " + ms.getName() + " on " + ms.getLinuxServer().getHostname(), this));
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to remove special MySQL user: " + this);
        }
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.MYSQL_SERVER_USERS, this.pkey});
    }

    @Override
    public void setPassword(final String password) throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to set the password for a special MySQL user: " + this);
        }
        AoservConnector connector = this.table.getConnector();
        if (!connector.isSecure()) {
            throw new IOException("Passwords for MySQL users may only be set when using secure protocols.  Currently using the " + connector.getProtocol() + " protocol, which is not secure.");
        }
        connector.requestUpdate(true, AoservProtocol.CommandId.SET_MYSQL_SERVER_USER_PASSWORD, new AoservConnector.UpdateRequest(){

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(UserServer.this.pkey);
                out.writeNullUTF(password);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
            }

            @Override
            public void afterRelease() {
            }
        });
    }

    public void setPredisablePassword(final String password) throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("May not disable special MySQL user: " + this.username);
        }
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.SET_MYSQL_SERVER_USER_PREDISABLE_PASSWORD, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(UserServer.this.pkey);
                out.writeNullUTF(password);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                UserServer.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }

    @Override
    public String toStringImpl() throws IOException, SQLException {
        return this.username + " on " + this.getMysqlServer().toStringImpl();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.username.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_4) < 0) {
            out.writeCompressedInt(-1);
        } else {
            out.writeCompressedInt(this.mysqlServer);
        }
        out.writeNullUTF(this.host);
        out.writeCompressedInt(this.disableLog);
        out.writeNullUTF(this.predisablePassword);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_4) >= 0) {
            out.writeCompressedInt(this.maxQuestions);
            out.writeCompressedInt(this.maxUpdates);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_111) >= 0) {
            out.writeCompressedInt(this.maxConnections);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_4) >= 0) {
            out.writeCompressedInt(this.maxUserConnections);
        }
    }

    @Override
    public boolean canSetPassword() throws SQLException, IOException {
        return !this.isDisabled() && !this.isSpecial();
    }
}

