/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.mysql;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.mysql.User;
import com.aoindustries.aoserv.client.mysql.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class UserServerTable
extends CachedTableIntegerKey<UserServer> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("username", true), new AoservTable.OrderBy("mysql_server.ao_server.hostname", true), new AoservTable.OrderBy("mysql_server.name", true)};

    UserServerTable(AoservConnector connector) {
        super(connector, UserServer.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addMysqlServerUser(final User.Name username, final Server mysqlServer, final String host) throws IOException, SQLException {
        if (User.isSpecial(username)) {
            throw new SQLException("Refusing to add special MySQL user: " + username + " on " + mysqlServer);
        }
        return this.connector.requestResult(true, AoservProtocol.CommandId.ADD, new AoservConnector.ResultRequest<Integer>(){
            private int pkey;
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.MYSQL_SERVER_USERS.ordinal());
                out.writeUTF(username.toString());
                out.writeCompressedInt(mysqlServer.getPkey());
                out.writeBoolean(host != null);
                if (host != null) {
                    out.writeUTF(host);
                }
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.pkey = in.readCompressedInt();
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public Integer afterRelease() {
                UserServerTable.this.connector.tablesUpdated(this.invalidateList);
                return this.pkey;
            }
        });
    }

    @Override
    public UserServer get(int pkey) throws IOException, SQLException {
        return (UserServer)this.getUniqueRow(0, pkey);
    }

    UserServer getMysqlServerUser(User.Name username, Server ms) throws IOException, SQLException {
        int msPkey = ms.getPkey();
        List table = this.getRows();
        int size = table.size();
        for (int c = 0; c < size; ++c) {
            UserServer msu = (UserServer)table.get(c);
            if (msu.getMysqlServer_id() != msPkey || !msu.getMysqlUser_username().equals(username)) continue;
            return msu;
        }
        return null;
    }

    List<UserServer> getMysqlServerUsers(User mu) throws IOException, SQLException {
        return this.getIndexedRows(1, mu.getUsername_id());
    }

    List<UserServer> getMysqlServerUsers(Server ms) throws IOException, SQLException {
        return this.getIndexedRows(2, ms.getBind_id());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MYSQL_SERVER_USERS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, SQLException, IOException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_mysql_server_user")) {
            if (Aosh.checkParamCount("add_mysql_server_user", args, 4, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addMysqlServerUser(Aosh.parseMysqlUserName(args[1], "username"), Aosh.parseMysqlServerName(args[2], "mysql_server"), args[3], args[4]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("disable_mysql_server_user")) {
            if (Aosh.checkParamCount("disable_mysql_server_user", args, 4, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().disableMysqlServerUser(Aosh.parseMysqlUserName(args[1], "username"), Aosh.parseMysqlServerName(args[2], "mysql_server"), args[3], args[4]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("enable_mysql_server_user")) {
            if (Aosh.checkParamCount("enable_mysql_server_user", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().enableMysqlServerUser(Aosh.parseMysqlUserName(args[1], "username"), Aosh.parseMysqlServerName(args[2], "mysql_server"), args[3]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("is_mysql_server_user_password_set")) {
            if (Aosh.checkParamCount("is_mysql_server_user_password_set", args, 3, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().isMysqlServerUserPasswordSet(Aosh.parseMysqlUserName(args[1], "username"), Aosh.parseMysqlServerName(args[2], "mysql_server"), args[3]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_mysql_server_user")) {
            if (Aosh.checkParamCount("remove_mysql_server_user", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeMysqlServerUser(Aosh.parseMysqlUserName(args[1], "username"), Aosh.parseMysqlServerName(args[2], "mysql_server"), args[3]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_mysql_server_user_password")) {
            if (Aosh.checkParamCount("set_mysql_server_user_password", args, 4, (PrintWriter)err)) {
                this.connector.getSimpleClient().setMysqlServerUserPassword(Aosh.parseMysqlUserName(args[1], "username"), Aosh.parseMysqlServerName(args[2], "mysql_server"), args[3], args[4]);
            }
            return true;
        }
        return false;
    }
}

