/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.net;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.Port;
import com.aoapps.net.Protocol;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.GlobalObjectStringKey;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.tomcat.JkProtocol;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;

public final class AppProtocol
extends GlobalObjectStringKey<AppProtocol> {
    static final int COLUMN_PROTOCOL = 0;
    static final String COLUMN_PORT_name = "port";
    public static final String AOSERV_DAEMON = "aoserv-daemon";
    public static final String AOSERV_DAEMON_SSL = "aoserv-daemon-ssl";
    public static final String AOSERV_MASTER = "aoserv-master";
    public static final String AOSERV_MASTER_SSL = "aoserv-master-ssl";
    public static final String AUTH = "auth";
    public static final String CVSPSERVER = "cvspserver";
    public static final String DNS = "DNS";
    public static final String FTP = "FTP";
    public static final String FTP_DATA = "FTP-DATA";
    public static final String HTTP = "HTTP";
    public static final String HTTPS = "HTTPS";
    public static final String HYPERSONIC = "hypersonic";
    public static final String IMAP2 = "IMAP2";
    public static final String JMX = "JMX";
    public static final String JNP = "JNP";
    public static final String MEMCACHED = "memcached";
    public static final String MILTER = "milter";
    public static final String MYSQL = "MySQL";
    public static final String NTALK = "ntalk";
    public static final String POP3 = "POP3";
    public static final String POSTGRESQL = "PostgreSQL";
    public static final String REDIS = "redis";
    public static final String REDIS_CLUSTER = "redis-cluster";
    public static final String REDIS_SENTINEL = "redis-sentinel";
    public static final String RFB = "RFB";
    public static final String RMI = "RMI";
    public static final String SIEVE = "sieve";
    public static final String SIMAP = "SIMAP";
    public static final String SPAMD = "spamd";
    public static final String SPOP3 = "SPOP3";
    public static final String SSH = "SSH";
    public static final String SMTP = "SMTP";
    public static final String SMTPS = "SMTPS";
    public static final String SUBMISSION = "submission";
    public static final String TALK = "talk";
    public static final String TELNET = "Telnet";
    public static final String TOMCAT4_SHUTDOWN = "tomcat4-shutdown";
    public static final String WEBSERVER = "webserver";
    private Port port;
    private String name;
    private boolean isUserService;

    @Deprecated
    public AppProtocol() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.port;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return this.isUserService;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public JkProtocol getHttpdJkProtocol(AoservConnector connector) throws IOException, SQLException {
        return connector.getWeb_tomcat().getJkProtocol().get(this.pkey);
    }

    public String getName() {
        return this.name;
    }

    public boolean isUserService() {
        return this.isUserService;
    }

    public Port getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.pkey;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.PROTOCOLS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getString(1);
            int portNum = result.getInt(2);
            this.name = result.getString(3);
            this.isUserService = result.getBoolean(4);
            this.port = Port.valueOf((int)portNum, (Protocol)Protocol.valueOf((String)result.getString(5).toUpperCase(Locale.ROOT)));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readUTF().intern();
            int portNum = in.readCompressedInt();
            this.name = in.readUTF();
            this.isUserService = in.readBoolean();
            this.port = Port.valueOf((int)portNum, (Protocol)((Protocol)in.readEnum(Protocol.class)));
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey);
        out.writeCompressedInt(this.port.getPort());
        out.writeUTF(this.name);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_105) >= 0) {
            out.writeBoolean(this.isUserService);
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_80_0) < 0) {
                out.writeUTF(this.port.getProtocol().name().toLowerCase(Locale.ROOT));
            } else {
                out.writeEnum((Enum)this.port.getProtocol());
            }
        }
    }
}

