/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.net;

import com.aoapps.collections.AoCollections;
import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoapps.net.EmptyURIParameters;
import com.aoapps.net.Port;
import com.aoapps.net.Protocol;
import com.aoapps.net.URIParameters;
import com.aoapps.net.URIParametersMap;
import com.aoapps.net.URIParametersUtils;
import com.aoapps.net.UnmodifiableURIParameters;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.distribution.OperatingSystemVersion;
import com.aoindustries.aoserv.client.email.CyrusImapdBind;
import com.aoindustries.aoserv.client.email.CyrusImapdServer;
import com.aoindustries.aoserv.client.email.SendmailBind;
import com.aoindustries.aoserv.client.email.SendmailServer;
import com.aoindustries.aoserv.client.ftp.PrivateServer;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.net.AppProtocol;
import com.aoindustries.aoserv.client.net.BindFirewallZone;
import com.aoindustries.aoserv.client.net.FirewallZone;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.net.IpAddress;
import com.aoindustries.aoserv.client.net.TcpRedirect;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.HttpdBind;
import com.aoindustries.aoserv.client.web.HttpdServer;
import com.aoindustries.aoserv.client.web.jboss.Site;
import com.aoindustries.aoserv.client.web.tomcat.PrivateTomcatSite;
import com.aoindustries.aoserv.client.web.tomcat.SharedTomcat;
import com.aoindustries.aoserv.client.web.tomcat.SharedTomcatSite;
import com.aoindustries.aoserv.client.web.tomcat.Worker;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Bind
extends CachedObjectIntegerKey<Bind>
implements Removable {
    static final int COLUMN_ID = 0;
    static final int COLUMN_PACKAGE = 1;
    static final int COLUMN_SERVER = 2;
    static final int COLUMN_IP_ADDRESS = 3;
    public static final String COLUMN_SERVER_name = "server";
    public static final String COLUMN_IP_ADDRESS_name = "ipAddress";
    public static final String COLUMN_PORT_name = "port";
    private Account.Name packageName;
    private int server;
    private int ipAddress;
    private Port port;
    private String appProtocol;
    private boolean monitoringEnabled;
    private String monitoringParameters;
    private boolean openFirewall;
    private static final ConcurrentMap<String, URIParameters> getMonitoringParametersCache = new ConcurrentHashMap<String, URIParameters>();

    @Deprecated
    public Bind() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.packageName;
            }
            case 2: {
                return this.server;
            }
            case 3: {
                return this.ipAddress;
            }
            case 4: {
                return this.port;
            }
            case 5: {
                return this.appProtocol;
            }
            case 6: {
                return this.monitoringEnabled;
            }
            case 7: {
                return this.monitoringParameters;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getId() {
        return this.pkey;
    }

    public Account.Name getPackage_name() {
        return this.packageName;
    }

    public Package getPackage() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getPackage().get(this.packageName);
    }

    public int getServer_pkey() {
        return this.server;
    }

    public Host getHost() throws SQLException, IOException {
        Host obj = this.table.getConnector().getNet().getHost().get(this.server);
        if (obj == null) {
            throw new SQLException("Unable to find Host: " + this.server);
        }
        return obj;
    }

    public int getIpAddress_id() {
        return this.ipAddress;
    }

    public IpAddress getIpAddress() throws SQLException, IOException {
        IpAddress obj = this.table.getConnector().getNet().getIpAddress().get(this.ipAddress);
        if (obj == null) {
            throw new SQLException("Unable to find IpAddress: " + this.ipAddress);
        }
        return obj;
    }

    public Port getPort() {
        return this.port;
    }

    public String getAppProtocol_protocol() {
        return this.appProtocol;
    }

    public AppProtocol getAppProtocol() throws SQLException, IOException {
        AppProtocol obj = this.table.getConnector().getNet().getAppProtocol().get(this.appProtocol);
        if (obj == null) {
            throw new SQLException("Unable to find Protocol: " + this.appProtocol);
        }
        return obj;
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public URIParameters getMonitoringParameters() {
        URIParameters previous;
        String myParamString = this.monitoringParameters;
        if (myParamString == null) {
            return EmptyURIParameters.getInstance();
        }
        URIParameters params = (URIParameters)getMonitoringParametersCache.get(myParamString);
        if (params == null && (previous = getMonitoringParametersCache.putIfAbsent(myParamString, params = UnmodifiableURIParameters.wrap((URIParameters)Bind.decodeParameters(myParamString)))) != null) {
            params = previous;
        }
        return params;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.packageName = Account.Name.valueOf(result.getString(2));
            this.server = result.getInt(3);
            this.ipAddress = result.getInt(4);
            this.port = Port.valueOf((int)result.getInt(5), (Protocol)Protocol.valueOf((String)result.getString(6)));
            this.appProtocol = result.getString(7);
            this.monitoringEnabled = result.getBoolean(8);
            this.monitoringParameters = result.getString(9);
            this.openFirewall = result.getBoolean(10);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.packageName = Account.Name.valueOf(in.readUTF()).intern();
            this.server = in.readCompressedInt();
            this.ipAddress = in.readCompressedInt();
            this.port = Port.valueOf((int)in.readCompressedInt(), (Protocol)((Protocol)in.readEnum(Protocol.class)));
            this.appProtocol = in.readUTF().intern();
            this.monitoringEnabled = in.readBoolean();
            this.monitoringParameters = in.readNullUTF();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.packageName.toString());
        out.writeCompressedInt(this.server);
        out.writeCompressedInt(this.ipAddress);
        out.writeCompressedInt(this.port.getPort());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_80_0) < 0) {
            out.writeUTF(this.port.getProtocol().name().toLowerCase(Locale.ROOT));
        } else {
            out.writeEnum((Enum)this.port.getProtocol());
        }
        out.writeUTF(this.appProtocol);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_80_2) <= 0) {
            out.writeBoolean(this.openFirewall);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_104) >= 0) {
            out.writeBoolean(this.monitoringEnabled);
        } else {
            out.writeCompressedInt(this.monitoringEnabled ? 300000 : -1);
            out.writeNullUTF(null);
            out.writeNullUTF(null);
            out.writeNullUTF(null);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_58) >= 0) {
            out.writeNullUTF(this.monitoringParameters);
        }
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.NET_BINDS;
    }

    @Override
    public String toStringImpl() throws IOException, SQLException {
        return this.getHost().toStringImpl() + "|" + this.getIpAddress().toStringImpl() + "|" + this.getPort();
    }

    public String getDetails() throws SQLException, IOException {
        SharedTomcat hst;
        com.aoindustries.aoserv.client.linux.Server aoServer = this.getAoserverByDaemonNetBind();
        if (aoServer != null) {
            return "AoservDaemon";
        }
        com.aoindustries.aoserv.client.linux.Server jilterServer = this.getAoserverByJilterNetBind();
        if (jilterServer != null) {
            return "AoservDaemon.JilterManager";
        }
        com.aoindustries.aoserv.client.postgresql.Server ps = this.getPostgresServer();
        if (ps != null) {
            return "PostgreSQL version " + ps.getVersion().getTechnologyVersion(this.table.getConnector()).getVersion() + " in " + ps.getDataDirectory();
        }
        CyrusImapdBind cib = this.getCyrusImapdBind();
        if (cib != null) {
            CyrusImapdServer ciServer = cib.getCyrusImapdServer();
            DomainName servername = cib.getServername();
            if (servername == null) {
                servername = ciServer.getServername();
            }
            if (servername == null || servername.equals((Object)ciServer.getLinuxServer().getHostname())) {
                return "Cyrus IMAPD";
            }
            return "Cyrus IMAPD @ " + servername;
        }
        CyrusImapdServer cis = this.getCyrusImapdServerBySieveNetBind();
        if (cis != null) {
            DomainName servername = cis.getServername();
            if (servername == null || servername.equals((Object)cis.getLinuxServer().getHostname())) {
                return "Cyrus IMAPD";
            }
            return "Cyrus IMAPD @ " + servername;
        }
        Worker hw = this.getHttpdWorker();
        if (hw != null) {
            hst = hw.getHttpdSharedTomcat();
            if (hst != null) {
                return hw.getHttpdJkProtocol(this.table.getConnector()).getProtocol(this.table.getConnector()).getProtocol() + " connector for Multi-Site Tomcat JVM version " + hst.getHttpdTomcatVersion().getTechnologyVersion(this.table.getConnector()).getVersion() + " in " + hst.getInstallDirectory();
            }
            com.aoindustries.aoserv.client.web.tomcat.Site hts = hw.getTomcatSite();
            if (hts != null) {
                return hw.getHttpdJkProtocol(this.table.getConnector()).getProtocol(this.table.getConnector()).getProtocol() + " connector for Single-Site Tomcat JVM version " + hts.getHttpdTomcatVersion().getTechnologyVersion(this.table.getConnector()).getVersion() + " in " + hts.getHttpdSite().getInstallDirectory();
            }
        }
        if ((hst = this.getHttpdSharedTomcatByShutdownPort()) != null) {
            return "Shutdown port for Multi-Site Tomcat JVM version " + hst.getHttpdTomcatVersion().getTechnologyVersion(this.table.getConnector()).getVersion() + " in " + hst.getInstallDirectory();
        }
        PrivateTomcatSite htss = this.getHttpdTomcatStdSiteByShutdownPort();
        if (htss != null) {
            return "Shutdown port for Single-Site Tomcat JVM version " + htss.getHttpdTomcatSite().getHttpdTomcatVersion().getTechnologyVersion(this.table.getConnector()).getVersion() + " in " + htss.getHttpdTomcatSite().getHttpdSite().getInstallDirectory();
        }
        HttpdBind hb = this.getHttpdBind();
        if (hb != null) {
            HttpdServer hs = hb.getHttpdServer();
            String name = hs.getName();
            OperatingSystemVersion osv = hs.getLinuxServer().getHost().getOperatingSystemVersion();
            int osvId = osv.getPkey();
            if (osvId == 67) {
                int number = name == null ? 1 : Integer.parseInt(name);
                return "Apache HTTP Server #" + number + " configured in /etc/httpd/conf/httpd" + number + ".conf";
            }
            if (osvId == 70) {
                if (name == null) {
                    return "Apache HTTP Server configured in /etc/httpd/conf/httpd.conf";
                }
                return "Apache HTTP Server (" + name + ") configured in /etc/httpd/conf/httpd@" + hs.getSystemdEscapedName() + ".conf";
            }
            throw new AssertionError((Object)("Unexpected OperatingSystemVersion: " + osv));
        }
        Site hjs = this.getHttpdJbossSiteByJnpPort();
        if (hjs != null) {
            return "JNP port for JBoss version " + hjs.getHttpdJbossVersion().getTechnologyVersion(this.table.getConnector()).getVersion() + " in " + hjs.getHttpdTomcatSite().getHttpdSite().getInstallDirectory();
        }
        Site hjbs = this.getHttpdJbossSiteByWebserverPort();
        if (hjbs != null) {
            return "Webserver port for JBoss version " + hjbs.getHttpdJbossVersion().getTechnologyVersion(this.table.getConnector()).getVersion() + " in " + hjbs.getHttpdTomcatSite().getHttpdSite().getInstallDirectory();
        }
        hjbs = this.getHttpdJbossSiteByRmiPort();
        if (hjbs != null) {
            return "RMI port for JBoss version " + hjbs.getHttpdJbossVersion().getTechnologyVersion(this.table.getConnector()).getVersion() + " in " + hjbs.getHttpdTomcatSite().getHttpdSite().getInstallDirectory();
        }
        hjbs = this.getHttpdJbossSiteByHypersonicPort();
        if (hjbs != null) {
            return "Hypersonic port for JBoss version " + hjbs.getHttpdJbossVersion().getTechnologyVersion(this.table.getConnector()).getVersion() + " in " + hjbs.getHttpdTomcatSite().getHttpdSite().getInstallDirectory();
        }
        hjbs = this.getHttpdJbossSiteByJmxPort();
        if (hjbs != null) {
            return "JMX port for JBoss version " + hjbs.getHttpdJbossVersion().getTechnologyVersion(this.table.getConnector()).getVersion() + " in " + hjbs.getHttpdTomcatSite().getHttpdSite().getInstallDirectory();
        }
        SendmailBind sb = this.getSendmailBind();
        if (sb != null) {
            SendmailServer ss = sb.getSendmailServer();
            DomainName hostname = ss.getHostname();
            if (hostname == null || hostname.equals((Object)ss.getLinuxServer().getHostname())) {
                String name = ss.getName();
                if (name == null) {
                    return "Sendmail";
                }
                return "Sendmail (" + name + ')';
            }
            return "Sendmail @ " + hostname;
        }
        TcpRedirect ntr = this.getNetTcpRedirect();
        if (ntr != null) {
            return "Port redirected to " + ntr.getDestinationHost().toBracketedString() + ':' + ntr.getDestinationPort().getPort();
        }
        PrivateServer pfs = this.getPrivateFtpServer();
        if (pfs != null) {
            return "Private FTP server in " + pfs.getLinuxServerAccount().getHome();
        }
        return null;
    }

    public boolean isDisabled() throws SQLException, IOException {
        Site hjbs;
        PrivateTomcatSite htss;
        SharedTomcat hst;
        boolean foundDisablable = false;
        Worker hw = this.getHttpdWorker();
        if (hw != null) {
            com.aoindustries.aoserv.client.web.tomcat.Site hts;
            hst = hw.getHttpdSharedTomcat();
            if (hst != null) {
                boolean hasEnabledSite = false;
                for (SharedTomcatSite htss2 : hst.getHttpdTomcatSharedSites()) {
                    if (htss2.getHttpdTomcatSite().getHttpdSite().isDisabled()) continue;
                    hasEnabledSite = true;
                    break;
                }
                if (!hst.isDisabled() && hasEnabledSite) {
                    return false;
                }
                foundDisablable = true;
            }
            if ((hts = hw.getTomcatSite()) != null) {
                if (!hts.getHttpdSite().isDisabled()) {
                    return false;
                }
                foundDisablable = true;
            }
        }
        if ((hst = this.getHttpdSharedTomcatByShutdownPort()) != null) {
            boolean hasEnabledSite = false;
            for (SharedTomcatSite htss2 : hst.getHttpdTomcatSharedSites()) {
                if (htss2.getHttpdTomcatSite().getHttpdSite().isDisabled()) continue;
                hasEnabledSite = true;
                break;
            }
            if (!hst.isDisabled() && hasEnabledSite) {
                return false;
            }
            foundDisablable = true;
        }
        if ((htss = this.getHttpdTomcatStdSiteByShutdownPort()) != null) {
            if (!htss.getHttpdTomcatSite().getHttpdSite().isDisabled()) {
                return false;
            }
            foundDisablable = true;
        }
        if ((hjbs = this.getHttpdJbossSiteByJnpPort()) != null) {
            if (!hjbs.getHttpdTomcatSite().getHttpdSite().isDisabled()) {
                return false;
            }
            foundDisablable = true;
        }
        if ((hjbs = this.getHttpdJbossSiteByWebserverPort()) != null) {
            if (!hjbs.getHttpdTomcatSite().getHttpdSite().isDisabled()) {
                return false;
            }
            foundDisablable = true;
        }
        if ((hjbs = this.getHttpdJbossSiteByRmiPort()) != null) {
            if (!hjbs.getHttpdTomcatSite().getHttpdSite().isDisabled()) {
                return false;
            }
            foundDisablable = true;
        }
        if ((hjbs = this.getHttpdJbossSiteByHypersonicPort()) != null) {
            if (!hjbs.getHttpdTomcatSite().getHttpdSite().isDisabled()) {
                return false;
            }
            foundDisablable = true;
        }
        if ((hjbs = this.getHttpdJbossSiteByJmxPort()) != null) {
            if (!hjbs.getHttpdTomcatSite().getHttpdSite().isDisabled()) {
                return false;
            }
            foundDisablable = true;
        }
        return foundDisablable;
    }

    public com.aoindustries.aoserv.client.linux.Server getAoserverByDaemonNetBind() throws IOException, SQLException {
        return this.table.getConnector().getLinux().getServer().getAoserverByDaemonNetBind(this);
    }

    public com.aoindustries.aoserv.client.linux.Server getAoserverByJilterNetBind() throws IOException, SQLException {
        return this.table.getConnector().getLinux().getServer().getAoserverByJilterNetBind(this);
    }

    public CyrusImapdBind getCyrusImapdBind() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getCyrusImapdBind().get(this.pkey);
    }

    public CyrusImapdServer getCyrusImapdServerBySieveNetBind() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getCyrusImapdServer().getCyrusImapdServerBySieveNetBind(this);
    }

    public HttpdBind getHttpdBind() throws IOException, SQLException {
        return this.table.getConnector().getWeb().getHttpdBind().get(this.pkey);
    }

    public Site getHttpdJbossSiteByJnpPort() throws IOException, SQLException {
        return this.table.getConnector().getWeb_jboss().getSite().getHttpdJbossSiteByJnpPort(this);
    }

    public Site getHttpdJbossSiteByWebserverPort() throws IOException, SQLException {
        return this.table.getConnector().getWeb_jboss().getSite().getHttpdJbossSiteByWebserverPort(this);
    }

    public Site getHttpdJbossSiteByRmiPort() throws IOException, SQLException {
        return this.table.getConnector().getWeb_jboss().getSite().getHttpdJbossSiteByRmiPort(this);
    }

    public Site getHttpdJbossSiteByHypersonicPort() throws IOException, SQLException {
        return this.table.getConnector().getWeb_jboss().getSite().getHttpdJbossSiteByHypersonicPort(this);
    }

    public Site getHttpdJbossSiteByJmxPort() throws IOException, SQLException {
        return this.table.getConnector().getWeb_jboss().getSite().getHttpdJbossSiteByJmxPort(this);
    }

    public Worker getHttpdWorker() throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getWorker().getHttpdWorker(this);
    }

    public SharedTomcat getHttpdSharedTomcatByShutdownPort() throws SQLException, IOException {
        return this.table.getConnector().getWeb_tomcat().getSharedTomcat().getHttpdSharedTomcatByShutdownPort(this);
    }

    public PrivateTomcatSite getHttpdTomcatStdSiteByShutdownPort() throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getPrivateTomcatSite().getHttpdTomcatStdSiteByShutdownPort(this);
    }

    public SendmailBind getSendmailBind() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getSendmailBind().get(this.pkey);
    }

    public List<BindFirewallZone> getNetBindFirewalldZones() throws IOException, SQLException {
        return this.table.getConnector().getNet().getBindFirewallZone().getNetBindFirewalldZones(this);
    }

    public List<FirewallZone> getFirewalldZones() throws IOException, SQLException {
        List<BindFirewallZone> nbfzs = this.getNetBindFirewalldZones();
        ArrayList<FirewallZone> fzs = new ArrayList<FirewallZone>(nbfzs.size());
        for (BindFirewallZone nbfz : nbfzs) {
            fzs.add(nbfz.getFirewalldZone());
        }
        return fzs;
    }

    public Set<FirewallZone.Name> getFirewalldZoneNames() throws IOException, SQLException {
        List<BindFirewallZone> nbfzs = this.getNetBindFirewalldZones();
        LinkedHashSet fzns = AoCollections.newLinkedHashSet((int)nbfzs.size());
        for (BindFirewallZone nbfz : nbfzs) {
            fzns.add(nbfz.getFirewalldZone().getName());
        }
        return fzns;
    }

    public TcpRedirect getNetTcpRedirect() throws IOException, SQLException {
        return this.table.getConnector().getNet().getTcpRedirect().get(this.pkey);
    }

    public Server getMysqlServer() throws IOException, SQLException {
        return this.table.getConnector().getMysql().getServer().getMysqlServer(this);
    }

    public com.aoindustries.aoserv.client.postgresql.Server getPostgresServer() throws IOException, SQLException {
        return this.table.getConnector().getPostgresql().getServer().getPostgresServer(this);
    }

    public PrivateServer getPrivateFtpServer() throws IOException, SQLException {
        return this.table.getConnector().getFtp().getPrivateServer().get(this.pkey);
    }

    public static String encodeParameters(URIParameters monitoringParameters) {
        return Objects.toString(URIParametersUtils.toQueryString((URIParameters)monitoringParameters), "");
    }

    public static URIParameters decodeParameters(String monitoringParameters) {
        if (monitoringParameters == null) {
            return EmptyURIParameters.getInstance();
        }
        return new URIParametersMap(monitoringParameters);
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() throws IOException, SQLException {
        com.aoindustries.aoserv.client.postgresql.Server ps;
        CachedObjectIntegerKey hs;
        ArrayList reasons = new ArrayList();
        AoservConnector conn = this.table.getConnector();
        if (this.getPackage() == null) {
            reasons.add(new CannotRemoveReason("Unable to access package: " + this.packageName));
        }
        for (com.aoindustries.aoserv.client.linux.Server ao : conn.getLinux().getServer().getRows()) {
            Integer jilterBind_id;
            Integer daemonBind_id = ao.getDaemonBind_id();
            Integer daemonConnectBind_id = ao.getDaemonConnectBind_id();
            if (daemonBind_id != null && this.pkey == daemonBind_id || daemonConnectBind_id != null && this.pkey == daemonConnectBind_id) {
                reasons.add(new CannotRemoveReason<com.aoindustries.aoserv.client.linux.Server>("Used as aoserv-daemon port for server: " + ao.getHostname(), ao));
            }
            if ((jilterBind_id = ao.getJilterBind_id()) == null || this.pkey != jilterBind_id) continue;
            reasons.add(new CannotRemoveReason<com.aoindustries.aoserv.client.linux.Server>("Used as aoserv-daemon jilter port for server: " + ao.getHostname(), ao));
        }
        for (HttpdBind hb : conn.getWeb().getHttpdBind().getRows()) {
            if (!this.equals(hb.getNetBind())) continue;
            hs = hb.getHttpdServer();
            String name = ((HttpdServer)hs).getName();
            reasons.add(new CannotRemoveReason<HttpdBind>(name == null ? "Used by Apache HTTP Server on " + ((HttpdServer)hs).getLinuxServer().getHostname() : "Used by Apache HTTP Server (" + name + ") on " + ((HttpdServer)hs).getLinuxServer().getHostname(), hb));
        }
        for (Site hjb : conn.getWeb_jboss().getSite().getRows()) {
            hs = hjb.getHttpdTomcatSite().getHttpdSite();
            if (this.equals(hjb.getJnpBind())) {
                reasons.add(new CannotRemoveReason<Site>("Used as JNP port for JBoss site " + ((com.aoindustries.aoserv.client.web.Site)hs).getInstallDirectory() + " on " + ((com.aoindustries.aoserv.client.web.Site)hs).getLinuxServer().getHostname(), hjb));
            }
            if (this.equals(hjb.getWebserverBind())) {
                reasons.add(new CannotRemoveReason<Site>("Used as Webserver port for JBoss site " + ((com.aoindustries.aoserv.client.web.Site)hs).getInstallDirectory() + " on " + ((com.aoindustries.aoserv.client.web.Site)hs).getLinuxServer().getHostname(), hjb));
            }
            if (this.equals(hjb.getRmiBind())) {
                reasons.add(new CannotRemoveReason<Site>("Used as RMI port for JBoss site " + ((com.aoindustries.aoserv.client.web.Site)hs).getInstallDirectory() + " on " + ((com.aoindustries.aoserv.client.web.Site)hs).getLinuxServer().getHostname(), hjb));
            }
            if (this.equals(hjb.getHypersonicBind())) {
                reasons.add(new CannotRemoveReason<Site>("Used as Hypersonic port for JBoss site " + ((com.aoindustries.aoserv.client.web.Site)hs).getInstallDirectory() + " on " + ((com.aoindustries.aoserv.client.web.Site)hs).getLinuxServer().getHostname(), hjb));
            }
            if (!this.equals(hjb.getJmxBind())) continue;
            reasons.add(new CannotRemoveReason<Site>("Used as JMX port for JBoss site " + ((com.aoindustries.aoserv.client.web.Site)hs).getInstallDirectory() + " on " + ((com.aoindustries.aoserv.client.web.Site)hs).getLinuxServer().getHostname(), hjb));
        }
        for (SharedTomcat hst : conn.getWeb_tomcat().getSharedTomcat().getRows()) {
            if (!this.equals(hst.getTomcat4ShutdownPort())) continue;
            reasons.add(new CannotRemoveReason<SharedTomcat>("Used as shutdown port for Multi-Site Tomcat JVM " + hst.getInstallDirectory() + " on " + hst.getLinuxServer().getHostname(), hst));
        }
        for (PrivateTomcatSite hts : conn.getWeb_tomcat().getPrivateTomcatSite().getRows()) {
            hs = hts.getHttpdTomcatSite().getHttpdSite();
            if (!this.equals(hts.getTomcat4ShutdownPort())) continue;
            reasons.add(new CannotRemoveReason<PrivateTomcatSite>("Used as shutdown port for Single-Site Tomcat JVM " + ((com.aoindustries.aoserv.client.web.Site)hs).getInstallDirectory() + " on " + ((com.aoindustries.aoserv.client.web.Site)hs).getLinuxServer().getHostname(), hts));
        }
        for (Worker hw : conn.getWeb_tomcat().getWorker().getRows()) {
            com.aoindustries.aoserv.client.web.tomcat.Site hts;
            if (!this.equals(hw.getBind())) continue;
            SharedTomcat hst = hw.getHttpdSharedTomcat();
            if (hst != null) {
                reasons.add(new CannotRemoveReason<SharedTomcat>("Used as mod_jk worker for Multi-Site Tomcat JVM " + hst.getInstallDirectory() + " on " + hst.getLinuxServer().getHostname(), hst));
            }
            if ((hts = hw.getTomcatSite()) == null) continue;
            com.aoindustries.aoserv.client.web.Site hs2 = hts.getHttpdSite();
            reasons.add(new CannotRemoveReason<com.aoindustries.aoserv.client.web.tomcat.Site>("Used as mod_jk worker for Tomcat JVM " + hs2.getInstallDirectory() + " on " + hs2.getLinuxServer().getHostname(), hts));
        }
        Server ms = this.getMysqlServer();
        if (ms != null) {
            reasons.add(new CannotRemoveReason<Server>("Used for MySQL server " + ms.getName() + " on " + ms.getLinuxServer().getHostname(), ms));
        }
        if ((ps = this.getPostgresServer()) != null) {
            reasons.add(new CannotRemoveReason<com.aoindustries.aoserv.client.postgresql.Server>("Used for PostgreSQL server " + ps.getName() + " on " + ps.getLinuxServer().getHostname(), ps));
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.NET_BINDS, this.pkey});
    }

    public void setMonitoringEnabled(boolean monitoringEnabled) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_NET_BIND_MONITORING, this.pkey, monitoringEnabled);
    }

    public void setFirewalldZones(final Set<FirewallZone.Name> firewalldZones) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.SET_NET_BIND_FIREWALLD_ZONES, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Bind.this.pkey);
                int size = firewalldZones.size();
                out.writeCompressedInt(size);
                int count = 0;
                for (FirewallZone.Name firewalldZone : firewalldZones) {
                    out.writeUTF(firewalldZone.toString());
                    ++count;
                }
                if (size != count) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                Bind.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }
}

