/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.net;

import com.aoapps.collections.AoCollections;
import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.net.Port;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.net.AppProtocol;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.net.FirewallZone;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.net.IpAddress;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class BindTable
extends CachedTableIntegerKey<Bind> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("server.package.name", true), new AoservTable.OrderBy("server.name", true), new AoservTable.OrderBy("ipAddress.inetAddress", true), new AoservTable.OrderBy("ipAddress.device.deviceId", true), new AoservTable.OrderBy("port", true)};

    BindTable(AoservConnector connector) {
        super(connector, Bind.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addNetBind(final Host se, final Package pk, final IpAddress ia, final Port port, final AppProtocol appProtocol, final boolean monitoringEnabled, final Set<FirewallZone.Name> firewalldZones) throws IOException, SQLException {
        return this.connector.requestResult(true, AoservProtocol.CommandId.ADD, new AoservConnector.ResultRequest<Integer>(){
            private int pkey;
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.NET_BINDS.ordinal());
                out.writeCompressedInt(se.getPkey());
                out.writeUTF(pk.getName().toString());
                out.writeCompressedInt(ia.getId());
                out.writeCompressedInt(port.getPort());
                out.writeEnum((Enum)port.getProtocol());
                out.writeUTF(appProtocol.getProtocol());
                out.writeBoolean(monitoringEnabled);
                int size = firewalldZones.size();
                out.writeCompressedInt(size);
                int count = 0;
                for (FirewallZone.Name firewalldZone : firewalldZones) {
                    out.writeUTF(firewalldZone.toString());
                    ++count;
                }
                if (size != count) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.pkey = in.readCompressedInt();
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public Integer afterRelease() {
                BindTable.this.connector.tablesUpdated(this.invalidateList);
                return this.pkey;
            }
        });
    }

    @Override
    public Bind get(int id) throws IOException, SQLException {
        return (Bind)this.getUniqueRow(0, id);
    }

    List<Bind> getNetBinds(IpAddress ia) throws IOException, SQLException {
        return this.getIndexedRows(3, ia.getPkey());
    }

    public List<Bind> getNetBinds(Package pk) throws IOException, SQLException {
        return this.getIndexedRows(1, pk.getName());
    }

    public List<Bind> getNetBinds(Package pk, IpAddress ip) throws IOException, SQLException {
        Account.Name packageName = pk.getName();
        List<Bind> cached = this.getNetBinds(ip);
        int size = cached.size();
        ArrayList<Bind> matches = new ArrayList<Bind>(size);
        for (int c = 0; c < size; ++c) {
            Bind nb = cached.get(c);
            if (!nb.getPackage_name().equals(packageName)) continue;
            matches.add(nb);
        }
        return matches;
    }

    List<Bind> getNetBinds(Host se) throws IOException, SQLException {
        return this.getIndexedRows(2, se.getPkey());
    }

    List<Bind> getNetBinds(Host se, IpAddress ip) throws IOException, SQLException {
        int ipAddress = ip.getPkey();
        List<Bind> cached = this.getNetBinds(se);
        int size = cached.size();
        ArrayList<Bind> matches = new ArrayList<Bind>(size);
        for (Bind nb : cached) {
            if (nb.getIpAddress_id() != ipAddress) continue;
            matches.add(nb);
        }
        return matches;
    }

    Bind getNetBind(Host se, IpAddress ip, Port port) throws IOException, SQLException {
        int sePkey = se.getPkey();
        List<Bind> cached = this.getNetBinds(ip);
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            Bind nb = cached.get(c);
            if (nb.getServer_pkey() != sePkey || nb.getPort() != port) continue;
            return nb;
        }
        return null;
    }

    List<Bind> getNetBinds(Host se, AppProtocol protocol) throws IOException, SQLException {
        String prot = protocol.getProtocol();
        List<Bind> cached = this.getNetBinds(se);
        int size = cached.size();
        ArrayList<Bind> matches = new ArrayList<Bind>(size);
        for (int c = 0; c < size; ++c) {
            Bind nb = cached.get(c);
            if (!nb.getAppProtocol_protocol().equals(prot)) continue;
            matches.add(nb);
        }
        return matches;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.NET_BINDS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, SQLException, IOException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_net_bind")) {
            if (Aosh.checkMinParamCount("add_net_bind", args, 8, (PrintWriter)err)) {
                int varargStart = 9;
                LinkedHashSet firewalldZones = AoCollections.newLinkedHashSet((int)(args.length - 9));
                for (int i = 9; i < args.length; ++i) {
                    FirewallZone.Name name = Aosh.parseFirewalldZoneName(args[i], "firewalld_zone[" + (i - 9) + "]");
                    if (firewalldZones.add(name)) continue;
                    throw new IllegalArgumentException("Duplicate firewalld zone name: " + name);
                }
                out.println(this.connector.getSimpleClient().addNetBind(args[1], Aosh.parseAccountingCode(args[2], "package"), Aosh.parseInetAddress(args[3], "ip_address"), args[4], Aosh.parsePort(args[5], "port", args[6], "net_protocol"), args[7], Aosh.parseBoolean(args[8], "monitoring_enabled"), firewalldZones));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_net_bind")) {
            if (Aosh.checkParamCount("remove_net_bind", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeNetBind(Aosh.parseInt(args[1], "pkey"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_net_bind_firewalld_zones")) {
            if (Aosh.checkMinParamCount("set_net_bind_firewalld_zones", args, 1, (PrintWriter)err)) {
                int varargStart = 2;
                LinkedHashSet firewalldZones = AoCollections.newLinkedHashSet((int)(args.length - 2));
                for (int i = 2; i < args.length; ++i) {
                    FirewallZone.Name name = Aosh.parseFirewalldZoneName(args[i], "firewalld_zone[" + (i - 2) + "]");
                    if (firewalldZones.add(name)) continue;
                    throw new IllegalArgumentException("Duplicate firewalld zone name: " + name);
                }
                this.connector.getSimpleClient().setNetBindFirewalldZones(Aosh.parseInt(args[1], "pkey"), firewalldZones);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_net_bind_monitoring_enabled")) {
            if (Aosh.checkParamCount("set_net_bind_monitoring_enabled", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().setNetBindMonitoringEnabled(Aosh.parseInt(args[1], "pkey"), Aosh.parseBoolean(args[2], "enabled"));
            }
            return true;
        }
        return false;
    }
}

