/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.net;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.InetAddress;
import com.aoapps.net.MacAddress;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.net.DeviceId;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.net.IpAddress;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class Device
extends CachedObjectIntegerKey<Device> {
    static final int COLUMN_ID = 0;
    static final int COLUMN_SERVER = 1;
    public static final String COLUMN_SERVER_name = "server";
    public static final String COLUMN_DEVICE_ID_name = "deviceId";
    private int server;
    private String deviceId;
    private String description;
    private String deleteRoute;
    private InetAddress gateway;
    private InetAddress network;
    private InetAddress broadcast;
    private MacAddress macAddress;
    private long maxBitRate;
    private long monitoringBitRateLow;
    private long monitoringBitTateMedium;
    private long monitoringBitRateHigh;
    private long monitoringBitRateCritical;
    private boolean monitoringEnabled;

    @Deprecated
    public Device() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.server;
            }
            case 2: {
                return this.deviceId;
            }
            case 3: {
                return this.description;
            }
            case 4: {
                return this.deleteRoute;
            }
            case 5: {
                return this.gateway;
            }
            case 6: {
                return this.network;
            }
            case 7: {
                return this.broadcast;
            }
            case 8: {
                return this.macAddress;
            }
            case 9: {
                return this.maxBitRate == -1L ? null : Long.valueOf(this.maxBitRate);
            }
            case 10: {
                return this.monitoringBitRateLow == -1L ? null : Long.valueOf(this.monitoringBitRateLow);
            }
            case 11: {
                return this.monitoringBitTateMedium == -1L ? null : Long.valueOf(this.monitoringBitTateMedium);
            }
            case 12: {
                return this.monitoringBitRateHigh == -1L ? null : Long.valueOf(this.monitoringBitRateHigh);
            }
            case 13: {
                return this.monitoringBitRateCritical == -1L ? null : Long.valueOf(this.monitoringBitRateCritical);
            }
            case 14: {
                return this.monitoringEnabled;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getId() {
        return this.pkey;
    }

    public int getServer_pkey() {
        return this.server;
    }

    public Host getHost() throws SQLException, IOException {
        Host se = this.table.getConnector().getNet().getHost().get(this.server);
        if (se == null) {
            throw new SQLException("Unable to find Host: " + this.server);
        }
        return se;
    }

    public String getDeviceId_name() {
        return this.deviceId;
    }

    public DeviceId getDeviceId() throws SQLException, IOException {
        DeviceId obj = this.table.getConnector().getNet().getDeviceId().get(this.deviceId);
        if (obj == null) {
            throw new SQLException("Unable to find DeviceId: " + this.deviceId);
        }
        return obj;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDeleteRoute() {
        return this.deleteRoute;
    }

    public InetAddress getGateway() {
        return this.gateway;
    }

    public InetAddress getNetwork() {
        return this.network;
    }

    public InetAddress getBroadcast() {
        return this.broadcast;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public long getMaxBitRate() {
        return this.maxBitRate;
    }

    public long getMonitoringBitRateLow() {
        return this.monitoringBitRateLow;
    }

    public long getMonitoringBitRateMedium() {
        return this.monitoringBitTateMedium;
    }

    public long getMonitoringBitRateHigh() {
        return this.monitoringBitRateHigh;
    }

    public long getMonitoringBitRateCritical() {
        return this.monitoringBitRateCritical;
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.server = result.getInt(pos++);
            this.deviceId = result.getString(pos++);
            this.description = result.getString(pos++);
            this.deleteRoute = result.getString(pos++);
            this.gateway = InetAddress.valueOf((String)result.getString(pos++));
            this.network = InetAddress.valueOf((String)result.getString(pos++));
            this.broadcast = InetAddress.valueOf((String)result.getString(pos++));
            this.macAddress = MacAddress.valueOf((String)result.getString(pos++));
            this.maxBitRate = result.getLong(pos++);
            if (result.wasNull()) {
                this.maxBitRate = -1L;
            }
            this.monitoringBitRateLow = result.getLong(pos++);
            if (result.wasNull()) {
                this.monitoringBitRateLow = -1L;
            }
            this.monitoringBitTateMedium = result.getLong(pos++);
            if (result.wasNull()) {
                this.monitoringBitTateMedium = -1L;
            }
            this.monitoringBitRateHigh = result.getLong(pos++);
            if (result.wasNull()) {
                this.monitoringBitRateHigh = -1L;
            }
            this.monitoringBitRateCritical = result.getLong(pos++);
            if (result.wasNull()) {
                this.monitoringBitRateCritical = -1L;
            }
            this.monitoringEnabled = result.getBoolean(pos++);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.server = in.readCompressedInt();
            this.deviceId = in.readUTF().intern();
            this.description = in.readUTF();
            this.deleteRoute = InternUtils.intern((String)in.readNullUTF());
            this.gateway = (InetAddress)InternUtils.intern((Internable)InetAddress.valueOf((String)in.readNullUTF()));
            this.network = (InetAddress)InternUtils.intern((Internable)InetAddress.valueOf((String)in.readNullUTF()));
            this.broadcast = (InetAddress)InternUtils.intern((Internable)InetAddress.valueOf((String)in.readNullUTF()));
            this.macAddress = MacAddress.valueOf((String)in.readNullUTF());
            this.maxBitRate = in.readLong();
            this.monitoringBitRateLow = in.readLong();
            this.monitoringBitTateMedium = in.readLong();
            this.monitoringBitRateHigh = in.readLong();
            this.monitoringBitRateCritical = in.readLong();
            this.monitoringEnabled = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.server);
        out.writeUTF(this.deviceId);
        out.writeUTF(this.description);
        out.writeNullUTF(this.deleteRoute);
        out.writeNullUTF(Objects.toString(this.gateway, null));
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_37) <= 0) {
            out.writeUTF("255.255.255.0");
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_112) >= 0) {
            out.writeNullUTF(Objects.toString(this.network, null));
            out.writeNullUTF(Objects.toString(this.broadcast, null));
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_128) >= 0) {
            out.writeNullUTF(Objects.toString(this.macAddress, null));
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_2) >= 0) {
            out.writeLong(this.maxBitRate);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_35) >= 0) {
            out.writeLong(this.monitoringBitRateLow);
            out.writeLong(this.monitoringBitTateMedium);
            out.writeLong(this.monitoringBitRateHigh);
            out.writeLong(this.monitoringBitRateCritical);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_70) >= 0) {
            out.writeBoolean(this.monitoringEnabled);
        }
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.NET_DEVICES;
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getHost().toStringImpl() + '|' + this.deviceId;
    }

    public IpAddress getIpAddress(InetAddress inetAddress) throws IOException, SQLException {
        return this.table.getConnector().getNet().getIpAddress().getIpAddress(this, inetAddress);
    }

    public List<IpAddress> getIpAddresses() throws IOException, SQLException {
        return this.table.getConnector().getNet().getIpAddress().getIpAddresses(this);
    }

    public IpAddress getPrimaryIpAddress() throws SQLException, IOException {
        List<IpAddress> ips = this.getIpAddresses();
        ArrayList<IpAddress> matches = new ArrayList<IpAddress>();
        for (IpAddress ip : ips) {
            if (ip.isAlias()) continue;
            matches.add(ip);
        }
        if (matches.isEmpty()) {
            throw new SQLException("Unable to find primary IpAddress for NetDevice: " + this.deviceId + " on " + this.server);
        }
        if (matches.size() > 1) {
            throw new SQLException("Found more than one primary IpAddress for NetDevice: " + this.deviceId + " on " + this.server);
        }
        return (IpAddress)matches.get(0);
    }

    public String getBondingReport() throws IOException, SQLException {
        if (!this.deviceId.startsWith("bond")) {
            return null;
        }
        return this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.GET_NET_DEVICE_BONDING_REPORT, this.pkey);
    }

    public String getStatisticsReport() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.GET_NET_DEVICE_STATISTICS_REPORT, this.pkey);
    }
}

