/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.net;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.net.Device;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public final class DeviceTable
extends CachedTableIntegerKey<Device> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("server.package.name", true), new AoservTable.OrderBy("server.name", true), new AoservTable.OrderBy("deviceId", true)};

    DeviceTable(AoservConnector connector) {
        super(connector, Device.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public Device get(int id) throws IOException, SQLException {
        return (Device)this.getUniqueRow(0, id);
    }

    List<Device> getNetDevices(Host se) throws IOException, SQLException {
        return this.getIndexedRows(1, se.getPkey());
    }

    Device getNetDevice(Host se, String deviceId) throws IOException, SQLException {
        List<Device> cached = this.getNetDevices(se);
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            Device dev = cached.get(c);
            if (!dev.getDeviceId_name().equals(deviceId)) continue;
            return dev;
        }
        return null;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.NET_DEVICES;
    }
}

