/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.net;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.dto.DtoFactory;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.InvalidResult;
import com.aoapps.lang.validation.ValidResult;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.dto.FirewallZoneName;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.net.BindFirewallZone;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class FirewallZone
extends CachedObjectIntegerKey<FirewallZone> {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, FirewallZone.class);
    public static final Name DMZ;
    public static final Name EXTERNAL;
    public static final Name HOME;
    public static final Name INTERNAL;
    public static final Name PUBLIC;
    public static final Name WORK;
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_SERVER = 1;
    static final String COLUMN_SERVER_name = "server";
    static final String COLUMN_NAME_name = "name";
    private int server;
    private Name name;
    private String shart;
    private String description;
    private boolean fail2ban;

    @Deprecated
    public FirewallZone() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.server;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return this.shart;
            }
            case 4: {
                return this.description;
            }
            case 5: {
                return this.fail2ban;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Host getHost() throws SQLException, IOException {
        Host se = this.table.getConnector().getNet().getHost().get(this.server);
        if (se == null) {
            throw new SQLException("Unable to find Host: " + this.server);
        }
        return se;
    }

    public Name getName() {
        return this.name;
    }

    public String getShort() {
        return this.shart;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getFail2ban() {
        return this.fail2ban;
    }

    public List<BindFirewallZone> getNetBindFirewalldZones() throws IOException, SQLException {
        return this.table.getConnector().getNet().getBindFirewallZone().getNetBindFirewalldZones(this);
    }

    public List<Bind> getNetBinds() throws IOException, SQLException {
        List<BindFirewallZone> nbfzs = this.getNetBindFirewalldZones();
        ArrayList<Bind> nbs = new ArrayList<Bind>(nbfzs.size());
        for (BindFirewallZone nbfz : nbfzs) {
            nbs.add(nbfz.getNetBind());
        }
        return nbs;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.FIREWALLD_ZONES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.server = result.getInt(2);
            this.name = Name.valueOf(result.getString(3));
            this.shart = result.getString(4);
            this.description = result.getString(5);
            this.fail2ban = result.getBoolean(6);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.server = in.readCompressedInt();
            this.name = Name.valueOf(in.readUTF()).intern();
            this.shart = InternUtils.intern((String)in.readNullUTF());
            this.description = InternUtils.intern((String)in.readNullUTF());
            this.fail2ban = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String toStringImpl() {
        return this.server + ":" + this.name;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.server);
        out.writeUTF(this.name.toString());
        out.writeNullUTF(this.shart);
        out.writeNullUTF(this.description);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_9) >= 0) {
            out.writeBoolean(this.fail2ban);
        }
    }

    static {
        try {
            DMZ = Name.valueOf("dmz");
            EXTERNAL = Name.valueOf("external");
            HOME = Name.valueOf("home");
            INTERNAL = Name.valueOf("internal");
            PUBLIC = Name.valueOf("public");
            WORK = Name.valueOf("work");
        }
        catch (ValidationException e) {
            throw new AssertionError("These hard-coded values are valid", e);
        }
    }

    public static final class Name
    implements Comparable<Name>,
    Serializable,
    DtoFactory<FirewallZoneName>,
    Internable<Name> {
        private static final long serialVersionUID = 1L;
        public static final int MAX_LENGTH = 17;
        private static final ConcurrentMap<String, Name> interned = new ConcurrentHashMap<String, Name>();
        private final String name;

        public static ValidationResult validate(String name) {
            if (name == null) {
                return new InvalidResult(RESOURCES, "Name.validate.isNull");
            }
            int len = name.length();
            if (len == 0) {
                return new InvalidResult(RESOURCES, "Name.validate.isEmpty");
            }
            if (len > 17) {
                return new InvalidResult(RESOURCES, "Name.validate.tooLong", new Serializable[]{Integer.valueOf(17), Integer.valueOf(len)});
            }
            for (int c = 0; c < len; ++c) {
                char ch = name.charAt(c);
                if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '-' || ch == '/') continue;
                return new InvalidResult(RESOURCES, "Name.validate.illegalCharacter");
            }
            if (name.charAt(0) == '/') {
                return new InvalidResult(RESOURCES, "Name.validate.startsWithSlash");
            }
            if (name.charAt(len - 1) == '/') {
                return new InvalidResult(RESOURCES, "Name.validate.endsWithSlash");
            }
            int slashPos = name.indexOf(47);
            if (slashPos != -1 && name.indexOf(47, slashPos + 1) != -1) {
                return new InvalidResult(RESOURCES, "Name.validate.moreThanOneSlash");
            }
            return ValidResult.getInstance();
        }

        public static Name valueOf(String name) throws ValidationException {
            if (name == null) {
                return null;
            }
            return new Name(name, true);
        }

        private Name(String name, boolean validate) throws ValidationException {
            this.name = name;
            if (validate) {
                this.validate();
            }
        }

        private Name(String name) {
            ValidationResult result;
            assert ((result = Name.validate(name)).isValid()) : result.toString();
            this.name = name;
        }

        private void validate() throws ValidationException {
            ValidationResult result = Name.validate(this.name);
            if (!result.isValid()) {
                throw new ValidationException(result);
            }
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            try {
                this.validate();
            }
            catch (ValidationException err) {
                InvalidObjectException newErr = new InvalidObjectException(err.getMessage());
                newErr.initCause(err);
                throw newErr;
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof Name && this.name.equals(((Name)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(Name other) {
            return this == other ? 0 : this.name.compareTo(other.name);
        }

        public String toString() {
            return this.name;
        }

        public Name intern() {
            Name addMe;
            String internedName;
            Name existing = (Name)interned.get(this.name);
            if (existing == null && (existing = interned.putIfAbsent(internedName, addMe = this.name == (internedName = this.name.intern()) ? this : new Name(internedName))) == null) {
                existing = addMe;
            }
            return existing;
        }

        public FirewallZoneName getDto() {
            return new FirewallZoneName(this.name);
        }
    }
}

