/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.net;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.exception.WrappedException;
import com.aoapps.net.Port;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.backup.FileReplication;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.distribution.OperatingSystemVersion;
import com.aoindustries.aoserv.client.infrastructure.PhysicalServer;
import com.aoindustries.aoserv.client.infrastructure.ServerFarm;
import com.aoindustries.aoserv.client.infrastructure.VirtualServer;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.net.AppProtocol;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.net.Device;
import com.aoindustries.aoserv.client.net.FirewallZone;
import com.aoindustries.aoserv.client.net.IpAddress;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public final class Host
extends CachedObjectIntegerKey<Host>
implements Comparable<Host> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_PACKAGE = 4;
    public static final String COLUMN_PACKAGE_name = "package";
    public static final String COLUMN_NAME_name = "name";
    public static final String HIDDEN_PASSWORD = "*";
    private String farm;
    private String description;
    private int operatingSystemVersion;
    private int packageId;
    private String name;
    private boolean monitoringEnabled;

    @Deprecated
    public Host() {
    }

    public void addAccount(Account.Name accounting, String contractVersion, Account parent, boolean canAddBackupServers, boolean canAddBusinesses, boolean canSeePrices, boolean billParent) throws IOException, SQLException {
        this.table.getConnector().getAccount().getAccount().addAccount(accounting, contractVersion, this, parent.getName(), canAddBackupServers, canAddBusinesses, canSeePrices, billParent);
    }

    public int addNetBind(Package pk, IpAddress ia, Port port, AppProtocol appProtocol, boolean monitoringEnabled, Set<FirewallZone.Name> firewalldZones) throws IOException, SQLException {
        return this.table.getConnector().getNet().getBind().addNetBind(this, pk, ia, port, appProtocol, monitoringEnabled, firewalldZones);
    }

    public Server getLinuxServer() throws IOException, SQLException {
        return this.table.getConnector().getLinux().getServer().get(this.pkey);
    }

    public PhysicalServer getPhysicalServer() throws IOException, SQLException {
        return this.table.getConnector().getInfrastructure().getPhysicalServer().get(this.pkey);
    }

    public VirtualServer getVirtualServer() throws IOException, SQLException {
        return this.table.getConnector().getInfrastructure().getVirtualServer().get(this.pkey);
    }

    public List<Account> getAccounts() throws IOException, SQLException {
        return this.table.getConnector().getAccount().getAccountHost().getAccounts(this);
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.farm;
            }
            case 2: {
                return this.description;
            }
            case 3: {
                return this.operatingSystemVersion == -1 ? null : Integer.valueOf(this.operatingSystemVersion);
            }
            case 4: {
                return this.packageId;
            }
            case 5: {
                return this.name;
            }
            case 6: {
                return this.monitoringEnabled;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getOperatingSystemVersion_id() {
        return this.operatingSystemVersion;
    }

    public OperatingSystemVersion getOperatingSystemVersion() throws SQLException, IOException {
        if (this.operatingSystemVersion == -1) {
            return null;
        }
        OperatingSystemVersion osv = this.table.getConnector().getDistribution().getOperatingSystemVersion().get(this.operatingSystemVersion);
        if (osv == null) {
            throw new SQLException("Unable to find OperatingSystemVersion: " + this.operatingSystemVersion);
        }
        return osv;
    }

    public Package getPackage() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getPackage().get(this.packageId);
    }

    public int getPackageId() {
        return this.packageId;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public ServerFarm getServerFarm() throws SQLException, IOException {
        ServerFarm sf = this.table.getConnector().getInfrastructure().getServerFarm().get(this.farm);
        if (sf == null) {
            throw new SQLException("Unable to find ServerFarm: " + this.farm);
        }
        return sf;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SERVERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.farm = result.getString(2);
        this.description = result.getString(3);
        this.operatingSystemVersion = result.getInt(4);
        if (result.wasNull()) {
            this.operatingSystemVersion = -1;
        }
        this.packageId = result.getInt(5);
        this.name = result.getString(6);
        this.monitoringEnabled = result.getBoolean(7);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.farm = in.readUTF().intern();
        this.description = in.readUTF();
        this.operatingSystemVersion = in.readCompressedInt();
        this.packageId = in.readCompressedInt();
        this.name = in.readUTF();
        this.monitoringEnabled = in.readBoolean();
    }

    @Override
    public String toStringImpl() throws IOException, SQLException {
        Server aoServer = this.getLinuxServer();
        if (aoServer != null) {
            return aoServer.toStringImpl();
        }
        Package pk = this.getPackage();
        if (pk != null) {
            return pk.getName().toString() + '/' + this.name;
        }
        return Integer.toString(this.pkey);
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeUTF(this.name);
        }
        out.writeUTF(this.farm);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeUTF("AOINDUSTRIES");
            out.writeUTF("orion");
        }
        out.writeUTF(this.description);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_107) <= 0) {
            out.writeUTF("i686");
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeCompressedInt(0);
            out.writeLong(-1L);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeCompressedInt(this.operatingSystemVersion == -1 ? 70 : this.operatingSystemVersion);
        } else {
            out.writeCompressedInt(this.operatingSystemVersion);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_108) >= 0 && protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeNullUTF(null);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_16) >= 0 && protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeFloat(Float.NaN);
            out.writeFloat(Float.NaN);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_31) >= 0) {
            out.writeCompressedInt(this.packageId);
            out.writeUTF(this.name);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_32) >= 0) {
            out.writeBoolean(this.monitoringEnabled);
        }
    }

    public List<FileReplication> getFailoverFileReplications() throws IOException, SQLException {
        return this.table.getConnector().getBackup().getFileReplication().getFailoverFileReplications(this);
    }

    public List<FirewallZone> getFirewalldZones() throws IOException, SQLException {
        return this.table.getConnector().getNet().getFirewallZone().getFirewalldZones(this);
    }

    public Bind getNetBind(IpAddress ipAddress, Port port) throws IOException, SQLException {
        return this.table.getConnector().getNet().getBind().getNetBind(this, ipAddress, port);
    }

    public List<Bind> getNetBinds() throws IOException, SQLException {
        return this.table.getConnector().getNet().getBind().getNetBinds(this);
    }

    public List<Bind> getNetBinds(IpAddress ipAddress) throws IOException, SQLException {
        return this.table.getConnector().getNet().getBind().getNetBinds(this, ipAddress);
    }

    public List<Bind> getNetBinds(AppProtocol protocol) throws IOException, SQLException {
        return this.table.getConnector().getNet().getBind().getNetBinds(this, protocol);
    }

    public Device getNetDevice(String deviceId) throws IOException, SQLException {
        return this.table.getConnector().getNet().getDevice().getNetDevice(this, deviceId);
    }

    public List<Device> getNetDevices() throws IOException, SQLException {
        return this.table.getConnector().getNet().getDevice().getNetDevices(this);
    }

    public List<IpAddress> getIpAddresses() throws IOException, SQLException {
        return this.table.getConnector().getNet().getIpAddress().getIpAddresses(this);
    }

    public IpAddress getAvailableIpAddress() throws SQLException, IOException {
        for (IpAddress ip : this.getIpAddresses()) {
            if (!ip.isAvailable() || !ip.isAlias() || ip.getDevice().getDeviceId().isLoopback()) continue;
            return ip;
        }
        return null;
    }

    @Override
    public int compareTo(Host o) {
        try {
            Package pk1 = this.getPackage();
            Package pk2 = o.getPackage();
            if (pk1 == null || pk2 == null) {
                int id2;
                int id1 = this.getPackageId();
                return id1 < (id2 = o.getPackageId()) ? -1 : (id1 == id2 ? 0 : 1);
            }
            int diff = pk1.compareTo(pk2);
            if (diff != 0) {
                return diff;
            }
            diff = this.name.compareToIgnoreCase(o.name);
            if (diff != 0) {
                return diff;
            }
            return this.name.compareTo(o.name);
        }
        catch (IOException | SQLException err) {
            throw new WrappedException((Throwable)err);
        }
    }
}

