/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.net;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.distribution.OperatingSystemVersion;
import com.aoindustries.aoserv.client.infrastructure.ServerFarm;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class HostTable
extends CachedTableIntegerKey<Host> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("package.name", true), new AoservTable.OrderBy("name", true)};

    HostTable(AoservConnector connector) {
        super(connector, Host.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int addBackupHost(final String hostname, final ServerFarm farm, final Package owner, final String description, final int backupHour, final OperatingSystemVersion osVersion, final User.Name username, final String password, final String contactPhone, final String contactEmail) throws IOException, SQLException {
        return this.connector.requestResult(true, AoservProtocol.CommandId.ADD_BACKUP_SERVER, new AoservConnector.ResultRequest<Integer>(){
            private int pkey;
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeUTF(hostname);
                out.writeUTF(farm.getName());
                out.writeCompressedInt(owner.getPkey());
                out.writeUTF(description);
                out.writeCompressedInt(backupHour);
                out.writeCompressedInt(osVersion.getPkey());
                out.writeUTF(username.toString());
                out.writeUTF(password);
                out.writeUTF(contactPhone);
                out.writeUTF(contactEmail);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.pkey = in.readCompressedInt();
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public Integer afterRelease() {
                HostTable.this.connector.tablesUpdated(this.invalidateList);
                return this.pkey;
            }
        });
    }

    @Override
    @Deprecated
    public Host get(Object pkey) throws IOException, SQLException {
        if (pkey == null) {
            return null;
        }
        if (pkey instanceof Integer) {
            return this.get((Integer)pkey);
        }
        if (pkey instanceof String) {
            return this.get((String)pkey);
        }
        throw new IllegalArgumentException("Must be an Integer or a String");
    }

    public Host get(String server) throws SQLException, IOException {
        String packageName;
        try {
            Server aoServer;
            Server server2 = aoServer = DomainName.validate((String)server).isValid() ? this.connector.getLinux().getServer().get(DomainName.valueOf((String)server)) : null;
            if (aoServer != null) {
                return aoServer.getHost();
            }
        }
        catch (ValidationException e) {
            throw new AssertionError("Already validated", e);
        }
        Host match = null;
        int numMatches = 0;
        for (Host se : this.connector.getNet().getHost().getRows()) {
            if (!server.equals(se.getName())) continue;
            match = se;
            ++numMatches;
        }
        if (match != null && numMatches == 1) {
            return match;
        }
        int slashPos = server.indexOf(47);
        if (slashPos != -1 && Account.Name.validate(packageName = server.substring(0, slashPos)).isValid()) {
            try {
                String name = server.substring(slashPos + 1);
                Package pk = this.connector.getBilling().getPackage().get(Account.Name.valueOf(packageName));
                if (pk == null) {
                    return null;
                }
                return pk.getHost(name);
            }
            catch (ValidationException e) {
                throw new AssertionError("Already validated", e);
            }
        }
        try {
            int pkey = Integer.parseInt(server);
            return this.connector.getNet().getHost().get(pkey);
        }
        catch (NumberFormatException err) {
            return null;
        }
    }

    @Override
    public Host get(int pkey) throws IOException, SQLException {
        return (Host)this.getUniqueRow(0, pkey);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SERVERS;
    }

    public Host getHost(Package pk, String name) throws IOException, SQLException {
        for (Host se : this.getServers(pk)) {
            if (!se.getName().equals(name)) continue;
            return se;
        }
        return null;
    }

    public List<Host> getServers(Package pk) throws IOException, SQLException {
        return this.getIndexedRows(4, pk.getPkey());
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_backup_server")) {
            if (Aosh.checkParamCount("add_backup_server", args, 12, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addBackupHost(args[1], args[2], Aosh.parseAccountingCode(args[3], "owner"), args[4], Aosh.parseInt(args[5], "backup_hour"), args[6], args[7], args[8], Aosh.parseUserName(args[9], "username"), args[10], args[11], args[12]));
                out.flush();
            }
            return true;
        }
        return false;
    }
}

