/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.net;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.Strings;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoapps.net.InetAddress;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.net.Device;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.net.monitoring.IpAddressMonitoring;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class IpAddress
extends CachedObjectIntegerKey<IpAddress> {
    static final int COLUMN_ID = 0;
    static final int COLUMN_DEVICE = 2;
    static final int COLUMN_PACKAGE = 5;
    public static final String COLUMN_IP_ADDRESS_name = "inetAddress";
    public static final String COLUMN_DEVICE_name = "device";
    public static final String LOOPBACK_IP = "127.0.0.1";
    public static final String WILDCARD_IP = "0.0.0.0";
    private static final ConcurrentMap<String, Integer> intForIpAddressCache = new ConcurrentHashMap<String, Integer>();
    private InetAddress inetAddress;
    private int device;
    private boolean isAlias;
    private DomainName hostname;
    private int package_id;
    private UnmodifiableTimestamp created;
    private boolean isAvailable;
    private boolean isOverflow;
    private boolean isDhcp;
    private InetAddress externalInetAddress;
    private String netmask;
    private Account.Name packageName;
    private boolean pingMonitorEnabled;
    private boolean checkBlacklistsOverSmtp;
    private boolean monitoringEnabled;

    public static Integer getIntForIpAddress(String ipAddress) throws IllegalArgumentException {
        Integer result = (Integer)intForIpAddressCache.get(ipAddress);
        if (result == null) {
            List octets = Strings.split((String)ipAddress, (char)'.');
            if (octets.size() != 4) {
                throw new IllegalArgumentException("Invalid IP address: " + ipAddress);
            }
            for (int c = 0; c < 4; ++c) {
                String tet = (String)octets.get(c);
                int tetLen = tet.length();
                if (tetLen < 1 || tetLen > 3) {
                    throw new IllegalArgumentException("Invalid IP address: " + ipAddress);
                }
                for (int d = 0; d < tetLen; ++d) {
                    char ch = tet.charAt(d);
                    if (ch >= '0' && ch <= '9') continue;
                    throw new IllegalArgumentException("Invalid IP address: " + ipAddress);
                }
                int val = Integer.parseInt(tet);
                if (val >= 0 && val <= 255) continue;
                throw new IllegalArgumentException("Invalid IP address: " + ipAddress);
            }
            result = Integer.parseInt((String)octets.get(0)) << 24 | Integer.parseInt((String)octets.get(1)) << 16 | Integer.parseInt((String)octets.get(2)) << 8 | Integer.parseInt((String)octets.get(3)) & 0xFF;
            Integer existing = intForIpAddressCache.putIfAbsent(ipAddress, result);
            if (existing != null) {
                result = existing;
            }
        }
        return result;
    }

    public static String getIpAddressForInt(int i) {
        return new StringBuilder(15).append(i >>> 24 & 0xFF).append('.').append(i >>> 16 & 0xFF).append('.').append(i >>> 8 & 0xFF).append('.').append(i & 0xFF).toString();
    }

    @Deprecated
    public IpAddress() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.inetAddress;
            }
            case 2: {
                return this.device == -1 ? null : Integer.valueOf(this.device);
            }
            case 3: {
                return this.isAlias;
            }
            case 4: {
                return this.hostname;
            }
            case 5: {
                return this.package_id;
            }
            case 6: {
                return this.created;
            }
            case 7: {
                return this.isAvailable;
            }
            case 8: {
                return this.isOverflow;
            }
            case 9: {
                return this.isDhcp;
            }
            case 10: {
                return this.externalInetAddress;
            }
            case 11: {
                return this.netmask;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getId() {
        return this.pkey;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public int getDevice_id() {
        return this.device;
    }

    public Device getDevice() throws SQLException, IOException {
        if (this.device == -1) {
            return null;
        }
        Device nd = this.table.getConnector().getNet().getDevice().get(this.device);
        if (nd == null) {
            throw new SQLException("Unable to find NetDevice: " + this.device);
        }
        return nd;
    }

    public boolean isAlias() {
        return this.isAlias;
    }

    public DomainName getHostname() {
        return this.hostname;
    }

    public int getPackage_id() {
        return this.package_id;
    }

    public Package getPackage() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getPackage().get(this.package_id);
    }

    public UnmodifiableTimestamp getCreated() {
        return this.created;
    }

    public List<Bind> getNetBinds() throws IOException, SQLException {
        return this.table.getConnector().getNet().getBind().getNetBinds(this);
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public boolean isOverflow() {
        return this.isOverflow;
    }

    public boolean isDhcp() {
        return this.isDhcp;
    }

    public InetAddress getExternalInetAddress() {
        return this.externalInetAddress;
    }

    public String getNetMask() {
        return this.netmask;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.IP_ADDRESSES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.inetAddress = InetAddress.valueOf((String)result.getString(pos++));
            this.device = result.getInt(pos++);
            if (result.wasNull()) {
                this.device = -1;
            }
            this.isAlias = result.getBoolean(pos++);
            this.hostname = DomainName.valueOf((String)result.getString(pos++));
            this.package_id = result.getInt(pos++);
            this.created = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
            this.isAvailable = result.getBoolean(pos++);
            this.isOverflow = result.getBoolean(pos++);
            this.isDhcp = result.getBoolean(pos++);
            this.externalInetAddress = InetAddress.valueOf((String)result.getString(pos++));
            this.netmask = result.getString(pos++);
            this.packageName = Account.Name.valueOf(result.getString(pos++));
            this.pingMonitorEnabled = result.getBoolean(pos++);
            this.checkBlacklistsOverSmtp = result.getBoolean(pos++);
            this.monitoringEnabled = result.getBoolean(pos++);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.inetAddress = InetAddress.valueOf((String)in.readUTF()).intern();
            this.device = in.readCompressedInt();
            this.isAlias = in.readBoolean();
            this.hostname = DomainName.valueOf((String)in.readNullUTF());
            this.package_id = in.readCompressedInt();
            this.created = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.isAvailable = in.readBoolean();
            this.isOverflow = in.readBoolean();
            this.isDhcp = in.readBoolean();
            this.externalInetAddress = InetAddress.valueOf((String)in.readNullUTF());
            this.netmask = in.readUTF().intern();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_68) <= 0) {
            out.writeUTF(this.inetAddress.isUnspecified() ? WILDCARD_IP : this.inetAddress.toString());
        } else {
            out.writeUTF(this.inetAddress.toString());
        }
        out.writeCompressedInt(this.device);
        out.writeBoolean(this.isAlias);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_68) <= 0) {
            out.writeUTF(this.hostname == null ? "*" : this.hostname.toString());
        } else {
            out.writeNullUTF(Objects.toString(this.hostname, null));
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_17) <= 0) {
            out.writeUTF(this.packageName.toString());
        } else {
            out.writeCompressedInt(this.package_id);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_122) <= 0) {
            out.writeCompressedInt(0);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.created.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.created, (DataOutputStream)out);
        }
        out.writeBoolean(this.isAvailable);
        out.writeBoolean(this.isOverflow);
        out.writeBoolean(this.isDhcp);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) >= 0 && protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_17) <= 0) {
            out.writeBoolean(this.pingMonitorEnabled);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_34) >= 0) {
            out.writeNullUTF(Objects.toString(this.externalInetAddress, null));
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_38) >= 0) {
            out.writeUTF(this.netmask);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_17) <= 0) {
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_75) >= 0) {
                out.writeBoolean(this.checkBlacklistsOverSmtp);
            }
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_17) >= 0) {
                out.writeBoolean(this.monitoringEnabled);
            }
        }
    }

    public boolean isUsed() throws IOException, SQLException {
        return !this.getNetBinds().isEmpty();
    }

    @Deprecated
    public boolean isWildcard() {
        return this.inetAddress.isUnspecified();
    }

    public void moveTo(Host server) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.MOVE_IP_ADDRESS, this.inetAddress.toString(), server.getPkey());
    }

    public void setHostname(DomainName hostname) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_IP_ADDRESS_HOSTNAME, this.pkey, hostname);
    }

    public void setPackage(Package pk) throws IOException, SQLException {
        if (this.isUsed()) {
            throw new SQLException("Unable to set Package, IpAddress in use: #" + this.pkey);
        }
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_IP_ADDRESS_PACKAGE, this.pkey, pk.getName());
    }

    public void setDhcpAddress(InetAddress ipAddress) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_IP_ADDRESS_DHCP_ADDRESS, this.pkey, ipAddress);
    }

    public IpAddressMonitoring getMonitoring() throws IOException, SQLException {
        return this.table.getConnector().getNet().getMonitoring().getIpAddressMonitoring().get(this.pkey);
    }
}

