/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.net;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.net.InetAddress;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.net.Device;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.net.IpAddress;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class IpAddressTable
extends CachedTableIntegerKey<IpAddress> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("inetAddress", true), new AoservTable.OrderBy("device.server.package.name", true), new AoservTable.OrderBy("device.server.name", true), new AoservTable.OrderBy("device.deviceId", true)};

    IpAddressTable(AoservConnector connector) {
        super(connector, IpAddress.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public IpAddress get(int id) throws IOException, SQLException {
        return (IpAddress)this.getUniqueRow(0, id);
    }

    IpAddress getIpAddress(Device device, InetAddress inetAddress) throws IOException, SQLException {
        int device_id = device.getPkey();
        List cached = this.getRows();
        int len = cached.size();
        for (int c = 0; c < len; ++c) {
            IpAddress address = (IpAddress)cached.get(c);
            if (address.getDevice_id() != device_id || !address.getInetAddress().equals((Object)inetAddress)) continue;
            return address;
        }
        return null;
    }

    List<IpAddress> getIpAddresses(Device device) throws IOException, SQLException {
        return this.getIndexedRows(2, device.getId());
    }

    public List<IpAddress> getIpAddresses(InetAddress inetAddress) throws IOException, SQLException {
        List cached = this.getRows();
        int len = cached.size();
        ArrayList<IpAddress> matches = new ArrayList<IpAddress>(len);
        for (int c = 0; c < len; ++c) {
            IpAddress address = (IpAddress)cached.get(c);
            if (!address.getInetAddress().equals((Object)inetAddress)) continue;
            matches.add(address);
        }
        return matches;
    }

    public List<IpAddress> getIpAddresses(Package pack) throws IOException, SQLException {
        return this.getIndexedRows(5, pack.getPkey());
    }

    public List<IpAddress> getIpAddresses(Host se) throws IOException, SQLException {
        int sePkey = se.getPkey();
        List cached = this.getRows();
        int len = cached.size();
        ArrayList<IpAddress> matches = new ArrayList<IpAddress>(len);
        for (IpAddress address : cached) {
            if (address.getDevice_id() == -1 && address.getInetAddress().isUnspecified()) {
                matches.add(address);
                continue;
            }
            Device device = address.getDevice();
            if (device == null || device.getServer_pkey() != sePkey) continue;
            matches.add(address);
        }
        return matches;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.IP_ADDRESSES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("is_ip_address_used")) {
            if (Aosh.checkParamCount("is_ip_address_used", args, 3, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().isIpAddressUsed(Aosh.parseInetAddress(args[1], "ip_address"), args[2], args[3]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("move_ip_address")) {
            if (Aosh.checkParamCount("move_ip_address", args, 4, (PrintWriter)err)) {
                this.connector.getSimpleClient().moveIpAddress(Aosh.parseInetAddress(args[1], "ip_address"), args[2], args[3], args[4]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_ip_address_dhcp_address")) {
            if (Aosh.checkParamCount("set_ip_address_dhcp_address", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().setIpAddressDhcpAddress(Aosh.parseInt(args[1], "pkey"), Aosh.parseInetAddress(args[2], "ip_address"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_ip_address_hostname")) {
            if (Aosh.checkParamCount("set_ip_address_hostname", args, 4, (PrintWriter)err)) {
                this.connector.getSimpleClient().setIpAddressHostname(Aosh.parseInetAddress(args[1], "ip_address"), args[2], args[3], Aosh.parseDomainName(args[4], "hostname"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_ip_address_package")) {
            if (Aosh.checkParamCount("set_ip_address_package", args, 4, (PrintWriter)err)) {
                this.connector.getSimpleClient().setIpAddressPackage(Aosh.parseInetAddress(args[1], "ip_address"), args[2], args[3], Aosh.parseAccountingCode(args[4], "package"));
            }
            return true;
        }
        return false;
    }
}

