/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.net;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.HostAddress;
import com.aoapps.net.Port;
import com.aoapps.net.Protocol;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class TcpRedirect
extends CachedObjectIntegerKey<TcpRedirect> {
    static final int COLUMN_NET_BIND = 0;
    static final String COLUMN_NET_BIND_name = "net_bind";
    private int cps;
    private int cpsOverloadSleepTime;
    private HostAddress destinationHost;
    private Port destinationPort;

    @Deprecated
    public TcpRedirect() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.cps;
            }
            case 2: {
                return this.cpsOverloadSleepTime;
            }
            case 3: {
                return this.destinationHost;
            }
            case 4: {
                return this.destinationPort;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Bind getNetBind() throws IOException, SQLException {
        Bind nb = this.table.getConnector().getNet().getBind().get(this.pkey);
        if (nb == null) {
            throw new SQLException("Unable to find NetBind: " + this.pkey);
        }
        return nb;
    }

    public int getConnectionsPerSecond() {
        return this.cps;
    }

    public int getConnectionsPerSecondOverloadSleepTime() {
        return this.cpsOverloadSleepTime;
    }

    public HostAddress getDestinationHost() {
        return this.destinationHost;
    }

    public Port getDestinationPort() {
        return this.destinationPort;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.NET_TCP_REDIRECTS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.cps = result.getInt(2);
            this.cpsOverloadSleepTime = result.getInt(3);
            this.destinationHost = HostAddress.valueOf((String)result.getString(4));
            this.destinationPort = Port.valueOf((int)result.getInt(5), (Protocol)Protocol.TCP);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.cps = in.readCompressedInt();
            this.cpsOverloadSleepTime = in.readCompressedInt();
            this.destinationHost = HostAddress.valueOf((String)in.readUTF()).intern();
            this.destinationPort = Port.valueOf((int)in.readCompressedInt(), (Protocol)Protocol.TCP);
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getNetBind().toStringImpl() + "->" + this.destinationHost.toBracketedString() + ':' + this.destinationPort.getPort();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.cps);
        out.writeCompressedInt(this.cpsOverloadSleepTime);
        out.writeUTF(this.destinationHost.toString());
        out.writeCompressedInt(this.destinationPort.getPort());
    }
}

