/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.net.monitoring;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.net.IpAddress;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class IpAddressMonitoring
extends CachedObjectIntegerKey<IpAddressMonitoring> {
    static final int COLUMN_ID = 0;
    static final String COLUMN_ID_name = "id";
    private boolean enabled;
    private boolean pingMonitorEnabled;
    private boolean checkBlacklistsOverSmtp;
    private boolean verifyDnsPtr;
    private boolean verifyDnsA;

    @Deprecated
    public IpAddressMonitoring() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.enabled;
            }
            case 2: {
                return this.pingMonitorEnabled;
            }
            case 3: {
                return this.checkBlacklistsOverSmtp;
            }
            case 4: {
                return this.verifyDnsPtr;
            }
            case 5: {
                return this.verifyDnsA;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getId() {
        return this.pkey;
    }

    public IpAddress getIpAddress() throws SQLException, IOException {
        IpAddress obj = this.table.getConnector().getNet().getIpAddress().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find IpAddress: " + this.pkey);
        }
        return obj;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean getPingMonitorEnabled() {
        return this.pingMonitorEnabled;
    }

    public boolean getCheckBlacklistsOverSmtp() {
        return this.checkBlacklistsOverSmtp;
    }

    public boolean getVerifyDnsPtr() {
        return this.verifyDnsPtr;
    }

    public boolean getVerifyDnsA() {
        return this.verifyDnsA;
    }

    public void setEnabled(boolean enabled) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_IP_ADDRESS_MONITORING_ENABLED, this.pkey, enabled);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.IpAddressMonitoring;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getInt(pos++);
        this.enabled = result.getBoolean(pos++);
        this.pingMonitorEnabled = result.getBoolean(pos++);
        this.checkBlacklistsOverSmtp = result.getBoolean(pos++);
        this.verifyDnsPtr = result.getBoolean(pos++);
        this.verifyDnsA = result.getBoolean(pos++);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.enabled = in.readBoolean();
        this.pingMonitorEnabled = in.readBoolean();
        this.checkBlacklistsOverSmtp = in.readBoolean();
        this.verifyDnsPtr = in.readBoolean();
        this.verifyDnsA = in.readBoolean();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeBoolean(this.enabled);
        out.writeBoolean(this.pingMonitorEnabled);
        out.writeBoolean(this.checkBlacklistsOverSmtp);
        out.writeBoolean(this.verifyDnsPtr);
        out.writeBoolean(this.verifyDnsA);
    }
}

