/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.net.monitoring;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.net.monitoring.IpAddressMonitoring;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;

public final class IpAddressMonitoringTable
extends CachedTableIntegerKey<IpAddressMonitoring> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("id.inetAddress", true), new AoservTable.OrderBy("id.device.server.package.name", true), new AoservTable.OrderBy("id.device.server.name", true), new AoservTable.OrderBy("id.device.deviceId", true)};

    IpAddressMonitoringTable(AoservConnector connector) {
        super(connector, IpAddressMonitoring.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public IpAddressMonitoring get(int id) throws IOException, SQLException {
        return (IpAddressMonitoring)this.getUniqueRow(0, id);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.IpAddressMonitoring;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("set_ip_address_monitoring_enabled")) {
            if (Aosh.checkParamCount("set_ip_address_monitoring_enabled", args, 4, (PrintWriter)err)) {
                this.connector.getSimpleClient().setIpAddressMonitoringEnabled(Aosh.parseInetAddress(args[1], "ip_address"), args[2], args[3], Aosh.parseBoolean(args[4], "enabled"));
            }
            return true;
        }
        return false;
    }
}

