/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.net.reputation;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.math.LongLong;
import com.aoapps.lang.math.SafeMath;
import com.aoapps.net.InetAddress;
import com.aoindustries.aoserv.client.CachedObjectLongKey;
import com.aoindustries.aoserv.client.net.reputation.Set;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class Host
extends CachedObjectLongKey<Host> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_SET = 1;
    static final String COLUMN_SET_name = "set";
    static final String COLUMN_HOST_name = "host";
    private int set;
    private int host;
    private short goodReputation;
    private short badReputation;

    @Deprecated
    public Host() {
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.IP_REPUTATION_SET_HOSTS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getLong(pos++);
        this.set = result.getInt(pos++);
        this.host = result.getInt(pos++);
        this.goodReputation = result.getShort(pos++);
        this.badReputation = result.getShort(pos++);
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeLong(this.pkey);
        out.writeCompressedInt(this.set);
        out.writeInt(this.host);
        out.writeShort((int)this.goodReputation);
        out.writeShort((int)this.badReputation);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readLong();
        this.set = in.readCompressedInt();
        this.host = in.readInt();
        this.goodReputation = in.readShort();
        this.badReputation = in.readShort();
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.set;
            }
            case 2: {
                return this.getHostAddress();
            }
            case 3: {
                return this.goodReputation;
            }
            case 4: {
                return this.badReputation;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Set getSet() throws SQLException, IOException {
        Set obj = this.table.getConnector().getNet().getReputation().getSet().get(this.set);
        if (obj == null) {
            throw new SQLException("Unable to find IpReputationSet: " + this.set);
        }
        return obj;
    }

    public int getHost() {
        return this.host;
    }

    public InetAddress getHostAddress() {
        return InetAddress.valueOf((LongLong)LongLong.valueOf((long)0L, (long)((long)this.host & 0xFFFFFFFFL)));
    }

    public short getGoodReputation() {
        return this.goodReputation;
    }

    public short getBadReputation() {
        return this.badReputation;
    }

    public short getReputation() {
        return SafeMath.castShort((int)(this.goodReputation - this.badReputation));
    }
}

