/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.net.reputation;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.net.Device;
import com.aoindustries.aoserv.client.net.reputation.LimiterClass;
import com.aoindustries.aoserv.client.net.reputation.LimiterSet;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public final class Limiter
extends CachedObjectIntegerKey<Limiter> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_NET_DEVICE = 1;
    static final String COLUMN_NET_DEVICE_name = "net_device";
    static final String COLUMN_IDENTIFIER_name = "identifier";
    private int netDevice;
    private String identifier;
    private String description;

    @Deprecated
    public Limiter() {
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.IP_REPUTATION_LIMITERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getInt(pos++);
        this.netDevice = result.getInt(pos++);
        this.identifier = result.getString(pos++);
        this.description = result.getString(pos++);
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.netDevice);
        out.writeUTF(this.identifier);
        out.writeNullUTF(this.description);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.netDevice = in.readCompressedInt();
        this.identifier = in.readUTF();
        this.description = in.readNullUTF();
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.netDevice;
            }
            case 2: {
                return this.identifier;
            }
            case 3: {
                return this.description;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Device getNetDevice() throws SQLException, IOException {
        Device nd = this.table.getConnector().getNet().getDevice().get(this.netDevice);
        if (nd == null) {
            throw new SQLException("Unable to find NetDevice: " + this.netDevice);
        }
        return nd;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDescription() {
        return this.description;
    }

    public List<LimiterClass> getLimits() throws IOException, SQLException {
        return this.table.getConnector().getNet().getReputation().getLimiterClass().getLimits(this);
    }

    public List<LimiterSet> getSets() throws IOException, SQLException {
        return this.table.getConnector().getNet().getReputation().getLimiterSet().getSets(this);
    }
}

