/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.net.reputation;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.math.LongLong;
import com.aoapps.net.InetAddress;
import com.aoindustries.aoserv.client.CachedObjectLongKey;
import com.aoindustries.aoserv.client.net.reputation.Set;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class Network
extends CachedObjectLongKey<Network> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_SET = 1;
    static final String COLUMN_SET_name = "set";
    static final String COLUMN_NETWORK_name = "network";
    private int set;
    private int network;
    private int counter;

    @Deprecated
    public Network() {
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.IP_REPUTATION_SET_NETWORKS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getLong(pos++);
        this.set = result.getInt(pos++);
        this.network = result.getInt(pos++);
        this.counter = result.getInt(pos++);
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeLong(this.pkey);
        out.writeCompressedInt(this.set);
        out.writeInt(this.network);
        out.writeInt(this.counter);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readLong();
        this.set = in.readCompressedInt();
        this.network = in.readInt();
        this.counter = in.readInt();
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.set;
            }
            case 2: {
                return this.getNetworkAddress();
            }
            case 3: {
                return this.counter;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Set getSet() throws SQLException, IOException {
        Set obj = this.table.getConnector().getNet().getReputation().getSet().get(this.set);
        if (obj == null) {
            throw new SQLException("Unable to find IpReputationSet: " + this.set);
        }
        return obj;
    }

    public int getNetwork() {
        return this.network;
    }

    public InetAddress getNetworkAddress() {
        return InetAddress.valueOf((LongLong)LongLong.valueOf((long)0L, (long)((long)this.network & 0xFFFFFFFFL)));
    }

    public int getCounter() {
        return this.counter;
    }
}

