/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.net.reputation;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.net.reputation.Host;
import com.aoindustries.aoserv.client.net.reputation.Network;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;

public final class Set
extends CachedObjectIntegerKey<Set> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_ACCOUNTING = 1;
    static final int COLUMN_IDENTIFIER = 2;
    static final String COLUMN_IDENTIFIER_name = "identifier";
    private Account.Name accounting;
    private String identifier;
    private boolean allowSubaccountUse;
    private int maxHosts;
    private short maxUncertainReputation;
    private short maxDefiniteReputation;
    private short networkPrefix;
    private short maxNetworkReputation;
    private int hostDecayInterval;
    private UnmodifiableTimestamp lastHostDecay;
    private int networkDecayInterval;
    private UnmodifiableTimestamp lastNetworkDecay;
    private UnmodifiableTimestamp lastReputationAdded;

    @Deprecated
    public Set() {
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.IP_REPUTATION_SETS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.accounting = Account.Name.valueOf(result.getString(pos++));
            this.identifier = result.getString(pos++);
            this.allowSubaccountUse = result.getBoolean(pos++);
            this.maxHosts = result.getInt(pos++);
            this.maxUncertainReputation = result.getShort(pos++);
            this.maxDefiniteReputation = result.getShort(pos++);
            this.networkPrefix = result.getShort(pos++);
            this.maxNetworkReputation = result.getShort(pos++);
            this.hostDecayInterval = result.getInt(pos++);
            this.lastHostDecay = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
            this.networkDecayInterval = result.getInt(pos++);
            this.lastNetworkDecay = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
            this.lastReputationAdded = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedUTF(this.accounting.toString(), 0);
        out.writeUTF(this.identifier);
        out.writeBoolean(this.allowSubaccountUse);
        out.writeCompressedInt(this.maxHosts);
        out.writeShort((int)this.maxUncertainReputation);
        out.writeShort((int)this.maxDefiniteReputation);
        out.writeShort((int)this.networkPrefix);
        out.writeShort((int)this.maxNetworkReputation);
        out.writeCompressedInt(this.hostDecayInterval);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.lastHostDecay.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.lastHostDecay, (DataOutputStream)out);
        }
        out.writeCompressedInt(this.networkDecayInterval);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.lastNetworkDecay.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.lastNetworkDecay, (DataOutputStream)out);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_67) >= 0) {
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
                out.writeLong(this.lastReputationAdded.getTime());
            } else {
                SQLStreamables.writeTimestamp((Timestamp)this.lastReputationAdded, (DataOutputStream)out);
            }
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.accounting = Account.Name.valueOf(in.readCompressedUTF()).intern();
            this.identifier = in.readUTF();
            this.allowSubaccountUse = in.readBoolean();
            this.maxHosts = in.readCompressedInt();
            this.maxUncertainReputation = in.readShort();
            this.maxDefiniteReputation = in.readShort();
            this.networkPrefix = in.readShort();
            this.maxNetworkReputation = in.readShort();
            this.hostDecayInterval = in.readCompressedInt();
            this.lastHostDecay = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.networkDecayInterval = in.readCompressedInt();
            this.lastNetworkDecay = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.lastReputationAdded = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.accounting;
            }
            case 2: {
                return this.identifier;
            }
            case 3: {
                return this.allowSubaccountUse;
            }
            case 4: {
                return this.maxHosts;
            }
            case 5: {
                return this.maxUncertainReputation;
            }
            case 6: {
                return this.maxDefiniteReputation;
            }
            case 7: {
                return this.networkPrefix;
            }
            case 8: {
                return this.maxNetworkReputation;
            }
            case 9: {
                return this.hostDecayInterval;
            }
            case 10: {
                return this.lastHostDecay;
            }
            case 11: {
                return this.networkDecayInterval;
            }
            case 12: {
                return this.lastNetworkDecay;
            }
            case 13: {
                return this.lastReputationAdded;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Account.Name getAccount_name() {
        return this.accounting;
    }

    public Account getAccount() throws SQLException, IOException {
        return this.table.getConnector().getAccount().getAccount().get(this.accounting);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean getAllowSubaccountUse() {
        return this.allowSubaccountUse;
    }

    public int getMaxHosts() {
        return this.maxHosts;
    }

    public short getMaxUncertainReputation() {
        return this.maxUncertainReputation;
    }

    public short getMaxDefiniteReputation() {
        return this.maxDefiniteReputation;
    }

    public short getNetworkPrefix() {
        return this.networkPrefix;
    }

    public short getMaxNetworkReputation() {
        return this.maxNetworkReputation;
    }

    public int getHostDecayInterval() {
        return this.hostDecayInterval;
    }

    public UnmodifiableTimestamp getLastHostDecay() {
        return this.lastHostDecay;
    }

    public int getNetworkDecayInterval() {
        return this.networkDecayInterval;
    }

    public UnmodifiableTimestamp getLastNetworkDecay() {
        return this.lastNetworkDecay;
    }

    public UnmodifiableTimestamp getLastReputationAdded() {
        return this.lastReputationAdded;
    }

    public List<Host> getHosts() throws IOException, SQLException {
        return this.table.getConnector().getNet().getReputation().getHost().getHosts(this);
    }

    public List<Network> getNetworks() throws IOException, SQLException {
        return this.table.getConnector().getNet().getReputation().getNetwork().getNetworks(this);
    }

    public void addReputation(int host, ConfidenceType confidence, ReputationType reputationType, short score) throws IOException, SQLException {
        this.addReputation(Collections.singletonList(new AddReputation(host, confidence, reputationType, score)));
    }

    public void addReputation(final Collection<AddReputation> addReputations) throws IOException, SQLException {
        final int size = addReputations.size();
        if (size > 0) {
            this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.ADD_IP_REPUTATION, new AoservConnector.UpdateRequest(){
                private IntList invalidateList;

                @Override
                public void writeRequest(StreamableOutput out) throws IOException {
                    out.writeCompressedInt(Set.this.pkey);
                    out.writeCompressedInt(size);
                    int count = 0;
                    for (AddReputation addRep : addReputations) {
                        out.writeInt(addRep.host);
                        out.writeChar((int)addRep.confidence.toChar());
                        out.writeChar((int)addRep.reputationType.toChar());
                        out.writeShort((int)addRep.score);
                        ++count;
                    }
                    if (count != size) {
                        throw new ConcurrentModificationException("size != count: " + size + " != " + count);
                    }
                }

                @Override
                public void readResponse(StreamableInput in) throws IOException, SQLException {
                    byte code = in.readByte();
                    if (code != 1) {
                        AoservProtocol.checkResult(code, in);
                        throw new IOException("Unexpected response code: " + code);
                    }
                    this.invalidateList = AoservConnector.readInvalidateList(in);
                }

                @Override
                public void afterRelease() {
                    Set.this.table.getConnector().tablesUpdated(this.invalidateList);
                }
            });
        }
    }

    public static final class AddReputation {
        final int host;
        final ConfidenceType confidence;
        final ReputationType reputationType;
        final short score;

        public AddReputation(int host, ConfidenceType confidence, ReputationType reputationType, short score) {
            this.host = host;
            this.confidence = confidence;
            this.reputationType = reputationType;
            this.score = score;
        }

        public int getHost() {
            return this.host;
        }

        public ConfidenceType getConfidence() {
            return this.confidence;
        }

        public ReputationType getReputationType() {
            return this.reputationType;
        }

        public short getScore() {
            return this.score;
        }
    }

    public static enum ReputationType {
        GOOD{

            @Override
            public char toChar() {
                return 'G';
            }
        }
        ,
        BAD{

            @Override
            public char toChar() {
                return 'B';
            }
        };


        public abstract char toChar();

        public static ReputationType fromChar(char ch) {
            switch (ch) {
                case 'G': {
                    return GOOD;
                }
                case 'B': {
                    return BAD;
                }
            }
            throw new IllegalArgumentException("Unexpected ReputationType character: " + ch);
        }
    }

    public static enum ConfidenceType {
        UNCERTAIN{

            @Override
            public char toChar() {
                return 'U';
            }
        }
        ,
        DEFINITE{

            @Override
            public char toChar() {
                return 'D';
            }
        };


        public abstract char toChar();

        public static ConfidenceType fromChar(char ch) {
            switch (ch) {
                case 'U': {
                    return UNCERTAIN;
                }
                case 'D': {
                    return DEFINITE;
                }
            }
            throw new IllegalArgumentException("Unexpected ConfidenceType character: " + ch);
        }
    }
}

