/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.password;

import com.aoapps.hodgepodge.util.EncodingUtils;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.io.IoUtils;
import com.aoapps.lang.zip.CorrectedGZIPInputStream;
import com.aoindustries.aoserv.client.account.User;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public final class PasswordChecker {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, PasswordChecker.class);
    private static final String[] months = new String[]{"jan", "january", "feb", "february", "mar", "march", "apr", "april", "may", "jun", "june", "jul", "july", "aug", "august", "sep", "september", "nov", "november", "dec", "december"};
    private static final String GOOD_KEY = "good";
    private static final String[] categoryKeys = new String[]{"category.length", "category.characters", "category.case", "category.dates", "category.dictionary"};
    public static final int NUM_CATEGORIES = categoryKeys.length;
    private static byte[] cachedWords;
    private static final String EOL;

    private PasswordChecker() {
        throw new AssertionError();
    }

    public static List<Result> getAllGoodResults() {
        ArrayList<Result> results = new ArrayList<Result>(NUM_CATEGORIES);
        for (int c = 0; c < NUM_CATEGORIES; ++c) {
            results.add(new Result(RESOURCES.getMessage(categoryKeys[c])));
        }
        return results;
    }

    public static List<Result> checkPassword(User.Name username, String password, PasswordStrength strength) throws IOException {
        if (strength == null) {
            throw new IllegalArgumentException("strength == null");
        }
        List<Result> results = PasswordChecker.getAllGoodResults();
        int passwordLen = password.length();
        if (passwordLen > 0) {
            if (passwordLen < (strength == PasswordStrength.SUPER_LAX ? 6 : 8)) {
                results.get(0).result = PasswordChecker.RESOURCES.getMessage(strength == PasswordStrength.SUPER_LAX ? "length.atLeastSix" : "length.atLeastEight");
            }
            int lowercount = 0;
            int uppercount = 0;
            int numbercount = 0;
            int specialcount = 0;
            for (int c = 0; c < passwordLen; ++c) {
                char ch = password.charAt(c);
                if (ch >= 'A' && ch <= 'Z') {
                    ++uppercount;
                    continue;
                }
                if (ch >= 'a' && ch <= 'z') {
                    ++lowercount;
                    continue;
                }
                if (ch >= '0' && ch <= '9') {
                    ++numbercount;
                    continue;
                }
                if (ch > ' ') continue;
                ++specialcount;
            }
            if (numbercount + specialcount == passwordLen) {
                results.get(1).result = PasswordChecker.RESOURCES.getMessage("characters.notOnlyNumbers");
            } else if (strength != PasswordStrength.SUPER_LAX && lowercount + uppercount + specialcount == passwordLen) {
                results.get(1).result = PasswordChecker.RESOURCES.getMessage("characters.numbersAndPunctuation");
            } else if (password.indexOf(32) != -1) {
                results.get(1).result = PasswordChecker.RESOURCES.getMessage("characters.notContainSpace");
            }
            if (strength != PasswordStrength.SUPER_LAX && (lowercount > 1 && uppercount == 0 || uppercount > 1 && lowercount == 0 || lowercount == 0 && uppercount == 0)) {
                results.get(2).result = PasswordChecker.RESOURCES.getMessage("case.capitalAndLower");
            }
            char[] backwardsChars = new char[passwordLen];
            for (int c = 0; c < passwordLen; ++c) {
                backwardsChars[c] = password.charAt(passwordLen - c - 1);
            }
            String backwards = new String(backwardsChars);
            if (username != null && username.toString().equalsIgnoreCase(password)) {
                results.get(4).result = PasswordChecker.RESOURCES.getMessage("dictionary.notSameAsUsername");
            }
            if (strength != PasswordStrength.SUPER_LAX) {
                String lowerf = password.toLowerCase();
                String lowerb = backwards.toLowerCase();
                boolean goodb = true;
                int len = months.length;
                for (int c = 0; c < len; ++c) {
                    String month = months[c].toLowerCase();
                    if (!lowerf.contains(month) && !lowerb.contains(month)) continue;
                    goodb = false;
                    break;
                }
                if (!goodb) {
                    results.get(3).result = PasswordChecker.RESOURCES.getMessage("dates.noDate");
                }
                if (results.get(4).result.equals(RESOURCES.getMessage(GOOD_KEY))) {
                    byte[] words = PasswordChecker.getDictionary();
                    int maxAllowedDictLen = strength == PasswordStrength.STRICT ? 3 : passwordLen / 2;
                    int wordslen = words.length;
                    int pos = 0;
                    String longest = "";
                    boolean longestForwards = true;
                    while (pos < wordslen) {
                        while (pos < wordslen && words[pos] <= 32) {
                            ++pos;
                        }
                        int startpos = pos;
                        while (pos < wordslen && words[pos] > 32) {
                            ++pos;
                        }
                        int wordlen = pos - startpos;
                        if (wordlen <= maxAllowedDictLen) continue;
                        if (PasswordChecker.indexOfIgnoreCase(password, words, startpos, wordlen) != -1) {
                            if (!(longestForwards ? wordlen > longest.length() : wordlen >= longest.length())) continue;
                            longest = new String(words, startpos, wordlen);
                            longestForwards = true;
                            continue;
                        }
                        if (PasswordChecker.indexOfIgnoreCase(backwards, words, startpos, wordlen) == -1 || wordlen <= longest.length()) continue;
                        longest = new String(words, startpos, wordlen);
                        longestForwards = false;
                    }
                    if (longest.length() > 0) {
                        results.get(4).result = PasswordChecker.RESOURCES.getMessage("dictionary.basedOnWord", new Object[]{longest});
                    }
                }
            }
        } else {
            results.get(0).result = PasswordChecker.RESOURCES.getMessage("length.noPassword");
        }
        return results;
    }

    private static synchronized byte[] getDictionary() throws IOException {
        if (cachedWords == null) {
            try (CorrectedGZIPInputStream in = new CorrectedGZIPInputStream(PasswordChecker.class.getResourceAsStream("linux.words.gz"));
                 ByteArrayOutputStream bout = new ByteArrayOutputStream();){
                IoUtils.copy((InputStream)in, (OutputStream)bout);
                cachedWords = bout.toByteArray();
            }
        }
        return cachedWords;
    }

    public static boolean hasResults(List<Result> results) {
        if (results == null) {
            return false;
        }
        String good = RESOURCES.getMessage(GOOD_KEY);
        for (Result result : results) {
            if (result.result.equals(good)) continue;
            return true;
        }
        return false;
    }

    public static int indexOfIgnoreCase(String string, byte[] buffer, int wordstart, int wordlen) {
        int endpos = string.length() - wordlen;
        int wordend = wordstart + wordlen;
        block0: for (int c = 0; c <= endpos; ++c) {
            int spos = c;
            for (int wpos = wordstart; wpos < wordend; ++wpos) {
                int ch1 = string.charAt(spos++);
                int ch2 = buffer[wpos];
                if (ch1 >= 65 && ch1 <= 90) {
                    ch1 += 32;
                }
                if (ch2 >= 65 && ch2 <= 90) {
                    ch2 += 32;
                }
                if (ch1 != ch2) continue block0;
            }
            return c;
        }
        return -1;
    }

    public static String yearOf(int year) {
        if (year >= 0 && year <= 9) {
            return "0" + year;
        }
        return String.valueOf(year);
    }

    public static void printResults(List<Result> results, Appendable out) throws IOException {
        for (Result result : results) {
            out.append(result.getCategory());
            out.append(": ");
            out.append(result.getResult());
            out.append(EOL);
        }
    }

    public static void printResultsHtml(List<Result> results, Appendable out, boolean isXhtml) throws IOException {
        out.append("    <table style=\"border:0px\" cellspacing=\"0\" cellpadding=\"4\">\n      <tbody>\n");
        for (Result result : results) {
            out.append("        <tr><td style=\"white-space:nowrap\">");
            EncodingUtils.encodeHtml((Object)result.getCategory(), (Appendable)out, (boolean)isXhtml);
            out.append(":</td><td style=\"white-space:nowrap\">");
            EncodingUtils.encodeHtml((Object)result.getResult(), (Appendable)out, (boolean)isXhtml);
            out.append("</td></tr>\n");
        }
        out.append("      </tbody>\n    </table>\n");
    }

    public static String getResultsHtml(List<Result> results, boolean isXhtml) throws IOException {
        StringBuilder out = new StringBuilder();
        PasswordChecker.printResultsHtml(results, out, isXhtml);
        return out.toString();
    }

    public static String getResultsString(List<Result> results) {
        StringBuilder sb = new StringBuilder();
        for (Result result : results) {
            sb.append(result.getCategory()).append(": ").append(result.getResult()).append('\n');
        }
        return sb.toString();
    }

    static {
        EOL = System.lineSeparator();
    }

    public static enum PasswordStrength {
        SUPER_LAX,
        MODERATE,
        STRICT;

    }

    public static class Result {
        private final String category;
        private String result;

        private Result(String category) {
            this.category = category;
            this.result = RESOURCES.getMessage(PasswordChecker.GOOD_KEY);
        }

        public String getCategory() {
            return this.category;
        }

        public String getResult() {
            return this.result;
        }

        public String toString() {
            return this.category + ": " + this.result;
        }
    }
}

