/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.password;

import com.aoapps.lang.Strings;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.password.PasswordChecker;
import java.io.IOException;
import java.security.SecureRandom;

public final class PasswordGenerator {
    private static final long MINIMUM_ENTROPY = 413000000000L;
    private static final String[] CONS = new String[]{"b", "bl", "br", "c", "cl", "cr", "ch", "d", "dr", "dw", "f", "fl", "fr", "g", "gl", "gr", "gw", "h", "j", "k", "kl", "kr", "l", "m", "n", "p", "ph", "pl", "pr", "qu", "r", "s", "sc", "scr", "sk", "sl", "sm", "sn", "sp", "spl", "spr", "st", "str", "sw", "sh", "t", "tr", "tw", "th", "thr", "v", "w", "wh", "y", "z"};
    private static final String[] TERM_CONS = new String[]{"b", "ch", "tch", "ck", "d", "f", "ff", "g", "k", "l", "lch", "ld", "lf", "lk", "lm", "lp", "lsh", "lt", "lth", "lve", "ll", "m", "mp", "n", "nd", "ng", "nk", "nt", "p", "r", "rch", "rd", "rf", "rg", "rk", "rm", "rn", "rp", "rsh", "rt", "rth", "rve", "sk", "sp", "ss", "st", "sh", "t", "tt", "th", "ve", "x", "z", "zz"};
    private static final String[] VOWS = new String[]{"a", "e", "i", "o", "u"};
    private static final String[] TERM_VOWS = new String[]{"a", "ay", "ya", "ah", "ar", "al", "ey", "ee", "er", "el", "i", "io", "yo", "o", "oi", "oy", "oh", "or", "ol", "uh", "ul", "y"};

    private PasswordGenerator() {
        throw new AssertionError();
    }

    public static String generatePassword() throws IOException {
        return PasswordGenerator.generatePassword(AoservConnector.getSecureRandom());
    }

    public static String generatePassword(SecureRandom secureRandom) throws IOException {
        String password;
        long entropy;
        StringBuilder pw = new StringBuilder();
        do {
            pw.setLength(0);
            entropy = 1L;
            int temp1 = 0;
            int temp2 = 0;
            int template = secureRandom.nextInt(3);
            entropy *= 3L;
            switch (template) {
                case 0: {
                    temp1 = secureRandom.nextBoolean() ? 321 : 412;
                    temp2 = secureRandom.nextBoolean() ? 321 : 412;
                    entropy *= 4L;
                    break;
                }
                case 1: {
                    if (secureRandom.nextBoolean()) {
                        temp1 = secureRandom.nextBoolean() ? 361 : 412;
                        temp2 = secureRandom.nextBoolean() ? 4161 : 3612;
                    } else {
                        temp2 = secureRandom.nextBoolean() ? 361 : 412;
                        temp1 = secureRandom.nextBoolean() ? 4161 : 3612;
                    }
                    entropy *= 8L;
                    break;
                }
                case 2: {
                    temp1 = secureRandom.nextBoolean() ? 416161 : 361612;
                    entropy *= 2L;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            StringBuilder word1 = new StringBuilder();
            StringBuilder word2 = new StringBuilder();
            for (int i = 0; i < 2; ++i) {
                StringBuilder currWord = i == 0 ? word1 : word2;
                int currTemp = i == 0 ? temp1 : temp2;
                int digit = currTemp % 10;
                while (digit > 0) {
                    currTemp /= 10;
                    switch (digit) {
                        case 1: {
                            currWord.append(VOWS[secureRandom.nextInt(VOWS.length)]);
                            entropy *= (long)VOWS.length;
                            break;
                        }
                        case 2: {
                            currWord.append(CONS[secureRandom.nextInt(CONS.length)]);
                            entropy *= (long)CONS.length;
                            break;
                        }
                        case 3: {
                            currWord.append(TERM_VOWS[secureRandom.nextInt(TERM_VOWS.length)]);
                            entropy *= (long)TERM_VOWS.length;
                            break;
                        }
                        case 4: {
                            currWord.append(TERM_CONS[secureRandom.nextInt(TERM_CONS.length)]);
                            entropy *= (long)TERM_CONS.length;
                            break;
                        }
                        case 6: {
                            boolean a = secureRandom.nextBoolean();
                            currWord.append(a ? CONS[secureRandom.nextInt(CONS.length)] : TERM_CONS[secureRandom.nextInt(TERM_CONS.length)]);
                            entropy *= (long)(a ? CONS : TERM_CONS).length;
                            break;
                        }
                    }
                    digit = currTemp % 10;
                }
                if (currWord.length() <= 0) continue;
                String ppWord = currWord.toString();
                ppWord = Strings.replace((String)ppWord, (String)"uu", (String)"ui");
                ppWord = Strings.replace((String)ppWord, (String)"iw", (String)"u");
                ppWord = Strings.replace((String)ppWord, (String)"yy", (String)"y");
                ppWord = Strings.replace((String)ppWord, (String)"lal", (String)(secureRandom.nextBoolean() ? "ral" : "lar"));
                ppWord = Strings.replace((String)ppWord, (String)"rar", (String)"ral");
                ppWord = Strings.replace((String)ppWord, (String)"lel", (String)(secureRandom.nextBoolean() ? "rel" : "ler"));
                ppWord = Strings.replace((String)ppWord, (String)"rer", (String)"rel");
                ppWord = Strings.replace((String)ppWord, (String)"lol", (String)(secureRandom.nextBoolean() ? "rol" : "lor"));
                ppWord = Strings.replace((String)ppWord, (String)"ror", (String)"rol");
                ppWord = Strings.replace((String)ppWord, (String)"lul", (String)(secureRandom.nextBoolean() ? "rul" : "lur"));
                ppWord = Strings.replace((String)ppWord, (String)"rur", (String)"rul");
                ppWord = Strings.replace((String)ppWord, (String)"lil", (String)(secureRandom.nextBoolean() ? "ril" : "lir"));
                ppWord = Strings.replace((String)ppWord, (String)"rir", (String)"ril");
                ppWord = Strings.replace((String)ppWord, (String)"lyl", (String)(secureRandom.nextBoolean() ? "ryl" : "lyr"));
                if ((ppWord = Strings.replace((String)ppWord, (String)"ryr", (String)"ryl")).indexOf("rve") < ppWord.length() - 3) {
                    ppWord = Strings.replace((String)ppWord, (String)"rve", (String)"rv");
                }
                if (ppWord.indexOf("lve") < ppWord.length() - 3) {
                    ppWord = Strings.replace((String)ppWord, (String)"lve", (String)"lv");
                }
                currWord.setLength(0);
                currWord.append(ppWord);
            }
            int dig1 = secureRandom.nextInt(8) + 2;
            int dig2 = secureRandom.nextInt(8) + 2;
            entropy *= 64L;
            int dig1pos = secureRandom.nextInt(3);
            int dig2pos = secureRandom.nextInt(3);
            entropy *= 6L;
            if (dig1pos == 0) {
                pw.append(dig1);
            }
            if (dig2pos == 0) {
                pw.append(dig2);
            }
            PasswordGenerator.appendCapped(pw, word1);
            if (dig1pos == 1) {
                pw.append(dig1);
            }
            if (dig2pos == 1) {
                pw.append(dig2);
            }
            PasswordGenerator.appendCapped(pw, word2);
            if (dig1pos == 2) {
                pw.append(dig1);
            }
            if (dig2pos != 2) continue;
            pw.append(dig2);
        } while (entropy < 413000000000L || PasswordChecker.hasResults(PasswordChecker.checkPassword(null, password = pw.toString(), PasswordChecker.PasswordStrength.STRICT)));
        return password;
    }

    private static void appendCapped(StringBuilder to, StringBuilder from) {
        int len = from.length();
        if (len > 0) {
            int ch = from.charAt(0);
            if (ch >= 97 && ch <= 122) {
                ch -= 32;
            }
            to.append((char)ch);
            for (int c = 1; c < len; ++c) {
                to.append(from.charAt(c));
            }
        }
    }
}

