/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.payment;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.GlobalTableStringKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Profile;
import com.aoindustries.aoserv.client.payment.CountryCode;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public final class CountryCodeTable
extends GlobalTableStringKey<CountryCode> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("name", true)};

    CountryCodeTable(AoservConnector connector) {
        super(connector, CountryCode.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public CountryCode get(String code) throws IOException, SQLException {
        return (CountryCode)this.getUniqueRow(0, code);
    }

    public List<CountryCode> getCountryCodesByPriority(int prioritySize, int[] priorityCounter) throws IOException, SQLException {
        HashMap<String, int[]> counts = new HashMap<String, int[]>();
        HashSet<Account.Name> finishedAccounts = new HashSet<Account.Name>();
        for (Profile profile : this.connector.getAccount().getProfile().getRows()) {
            Account.Name accounting = profile.getAccount_name();
            if (finishedAccounts.contains(accounting)) continue;
            finishedAccounts.add(accounting);
            String code = profile.getCountry_code();
            int[] counter = (int[])counts.get(code);
            if (counter == null) {
                counter = new int[1];
                counts.put(code, counter);
            }
            counter[0] = counter[0] + 1;
        }
        ArrayList<String> biggest = new ArrayList<String>(prioritySize);
        for (String code : counts.keySet()) {
            int c;
            int count = ((int[])counts.get(code))[0];
            for (c = 0; c < biggest.size(); ++c) {
                int ccCount;
                String ccCode = (String)biggest.get(c);
                int[] ccCounter = (int[])counts.get(ccCode);
                int n = ccCount = ccCounter == null ? 0 : ccCounter[0];
                if (count > ccCount || count == ccCount && code.compareToIgnoreCase(ccCode) <= 0) break;
            }
            if (c >= prioritySize) continue;
            if (biggest.size() >= prioritySize) {
                biggest.remove(prioritySize - 1);
            }
            biggest.add(Math.min(c, biggest.size()), code);
        }
        List ccs = this.getRows();
        ArrayList<CountryCode> results = new ArrayList<CountryCode>(ccs.size() + biggest.size());
        for (String code : biggest) {
            results.add(this.get(code));
        }
        results.addAll(ccs);
        if (priorityCounter != null && priorityCounter.length >= 1) {
            priorityCounter[0] = biggest.size();
        }
        return results;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.COUNTRY_CODES;
    }
}

