/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.payment;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.math.SafeMath;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.Email;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.SQLUtility;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.payment.CountryCode;
import com.aoindustries.aoserv.client.payment.Processor;
import com.aoindustries.aoserv.client.pki.EncryptionKey;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.schema.Type;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;

public final class CreditCard
extends CachedObjectIntegerKey<CreditCard>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_PROCESSOR_ID = 1;
    static final int COLUMN_ACCOUNTING = 2;
    static final String COLUMN_ACCOUNTING_name = "accounting";
    static final String COLUMN_CREATED_name = "created";
    private String processorId;
    private Account.Name accounting;
    private String groupName;
    private String cardInfo;
    private Byte expirationMonth;
    private Short expirationYear;
    private String providerUniqueId;
    private String firstName;
    private String lastName;
    private String companyName;
    private Email email;
    private String phone;
    private String fax;
    private String customerId;
    private String customerTaxId;
    private String streetAddress1;
    private String streetAddress2;
    private String city;
    private String state;
    private String postalCode;
    private String countryCode;
    private UnmodifiableTimestamp created;
    private User.Name createdBy;
    private String principalName;
    private boolean useMonthly;
    private boolean isActive;
    private UnmodifiableTimestamp deactivatedOn;
    private String deactivateReason;
    private String description;
    private String encryptedCardNumber;
    private int encryptionCardNumberFrom;
    private int encryptionCardNumberRecipient;
    private String decryptCardNumberPassphrase;
    private String cardNumber;

    static String randomize(String original) {
        SecureRandom secureRandom = AoservConnector.getSecureRandom();
        StringBuilder randomized = new StringBuilder();
        int len = original.length();
        for (int c = 0; c <= len; ++c) {
            int randChars = secureRandom.nextInt(20);
            for (int d = 0; d < randChars; ++d) {
                int randVal = secureRandom.nextInt(211);
                if ((randVal += 33) >= 45) {
                    ++randVal;
                }
                if (randVal >= 47) {
                    randVal += 11;
                }
                randomized.append((char)randVal);
            }
            if (c >= len) continue;
            randomized.append(original.charAt(c));
        }
        return randomized.toString();
    }

    static String derandomize(String randomized) {
        StringBuilder stripped = new StringBuilder(randomized.length());
        int len = randomized.length();
        for (int c = 0; c < len; ++c) {
            char ch = randomized.charAt(c);
            if ((ch < '0' || ch > '9') && ch != ' ' && ch != '-' && ch != '/') continue;
            stripped.append(ch);
        }
        return stripped.toString();
    }

    @Deprecated
    public CreditCard() {
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    public void declined(String reason) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.CREDIT_CARD_DECLINED, this.pkey, reason);
    }

    public int getId() {
        return this.pkey;
    }

    public Processor getCreditCardProcessor() throws SQLException, IOException {
        Processor ccp = this.table.getConnector().getPayment().getProcessor().get(this.processorId);
        if (ccp == null) {
            throw new SQLException("Unable to find CreditCardProcessor: " + this.processorId);
        }
        return ccp;
    }

    public Account.Name getAccount_name() {
        return this.accounting;
    }

    public Account getAccount() throws SQLException, IOException {
        Account obj = this.table.getConnector().getAccount().getAccount().get(this.accounting);
        if (obj == null) {
            throw new SQLException("Unable to find Account: " + this.accounting);
        }
        return obj;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getCardInfo() {
        return this.cardInfo;
    }

    public Byte getExpirationMonth() {
        return this.expirationMonth;
    }

    public Short getExpirationYear() {
        return this.expirationYear;
    }

    public String getProviderUniqueId() {
        return this.providerUniqueId;
    }

    @Deprecated
    public static String getCardInfo(String cardNumber) {
        int maxLen = 4;
        int len = cardNumber.length();
        StringBuilder nums = new StringBuilder(Math.min(len, 4));
        for (int c = len - 1; c >= 0 && nums.length() < 4; --c) {
            char ch = cardNumber.charAt(c);
            if (ch < '0' || ch > '9') continue;
            nums.insert(0, ch);
        }
        return nums.toString();
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.processorId;
            }
            case 2: {
                return this.accounting;
            }
            case 3: {
                return this.groupName;
            }
            case 4: {
                return this.cardInfo;
            }
            case 5: {
                return this.expirationMonth == null ? null : Short.valueOf(this.expirationMonth.shortValue());
            }
            case 6: {
                return this.expirationYear;
            }
            case 7: {
                return this.providerUniqueId;
            }
            case 8: {
                return this.firstName;
            }
            case 9: {
                return this.lastName;
            }
            case 10: {
                return this.companyName;
            }
            case 11: {
                return this.email;
            }
            case 12: {
                return this.phone;
            }
            case 13: {
                return this.fax;
            }
            case 14: {
                return this.customerId;
            }
            case 15: {
                return this.customerTaxId;
            }
            case 16: {
                return this.streetAddress1;
            }
            case 17: {
                return this.streetAddress2;
            }
            case 18: {
                return this.city;
            }
            case 19: {
                return this.state;
            }
            case 20: {
                return this.postalCode;
            }
            case 21: {
                return this.countryCode;
            }
            case 22: {
                return this.created;
            }
            case 23: {
                return this.createdBy;
            }
            case 24: {
                return this.principalName;
            }
            case 25: {
                return this.useMonthly;
            }
            case 26: {
                return this.isActive;
            }
            case 27: {
                return this.deactivatedOn;
            }
            case 28: {
                return this.deactivateReason;
            }
            case 29: {
                return this.description;
            }
            case 30: {
                return this.encryptedCardNumber;
            }
            case 31: {
                return this.encryptionCardNumberFrom;
            }
            case 32: {
                return this.encryptionCardNumberRecipient;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public Email getEmail() {
        return this.email;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getFax() {
        return this.fax;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCustomerTaxId() {
        return this.customerTaxId;
    }

    public String getStreetAddress1() {
        return this.streetAddress1;
    }

    public String getStreetAddress2() {
        return this.streetAddress2;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public CountryCode getCountryCode() throws SQLException, IOException {
        CountryCode countryCodeObj = this.table.getConnector().getPayment().getCountryCode().get(this.countryCode);
        if (countryCodeObj == null) {
            throw new SQLException("Unable to find CountryCode: " + this.countryCode);
        }
        return countryCodeObj;
    }

    public UnmodifiableTimestamp getCreated() {
        return this.created;
    }

    public Administrator getCreatedBy() throws SQLException, IOException {
        Administrator administrator = this.table.getConnector().getAccount().getAdministrator().get(this.createdBy);
        if (administrator == null) {
            throw new SQLException("Unable to find Administrator: " + this.createdBy);
        }
        return administrator;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public UnmodifiableTimestamp getDeactivatedOn() {
        return this.deactivatedOn;
    }

    public String getDeactivatedOnString() {
        return SQLUtility.formatDate((Date)this.deactivatedOn, (TimeZone)Type.DATE_TIME_ZONE);
    }

    public String getDeactivateReason() {
        return this.deactivateReason;
    }

    public String getDescription() {
        return this.description;
    }

    public EncryptionKey getEncryptionCardNumberFrom() throws SQLException, IOException {
        if (this.encryptionCardNumberFrom == -1) {
            return null;
        }
        EncryptionKey ek = this.table.getConnector().getPki().getEncryptionKey().get(this.encryptionCardNumberFrom);
        if (ek == null) {
            throw new SQLException("Unable to find EncryptionKey: " + this.encryptionCardNumberFrom);
        }
        return ek;
    }

    public EncryptionKey getEncryptionCardNumberRecipient() throws SQLException, IOException {
        if (this.encryptionCardNumberRecipient == -1) {
            return null;
        }
        EncryptionKey er = this.table.getConnector().getPki().getEncryptionKey().get(this.encryptionCardNumberRecipient);
        if (er == null) {
            throw new SQLException("Unable to find EncryptionKey: " + this.encryptionCardNumberRecipient);
        }
        return er;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.CREDIT_CARDS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.processorId = result.getString(pos++);
            this.accounting = Account.Name.valueOf(result.getString(pos++));
            this.groupName = result.getString(pos++);
            this.cardInfo = result.getString(pos++);
            this.expirationMonth = SafeMath.castByte((int)result.getShort(pos++));
            if (result.wasNull()) {
                this.expirationMonth = null;
            }
            this.expirationYear = result.getShort(pos++);
            if (result.wasNull()) {
                this.expirationYear = null;
            }
            this.providerUniqueId = result.getString(pos++);
            this.firstName = result.getString(pos++);
            this.lastName = result.getString(pos++);
            this.companyName = result.getString(pos++);
            this.email = Email.valueOf((String)result.getString(pos++));
            this.phone = result.getString(pos++);
            this.fax = result.getString(pos++);
            this.customerId = result.getString(pos++);
            this.customerTaxId = result.getString(pos++);
            this.streetAddress1 = result.getString(pos++);
            this.streetAddress2 = result.getString(pos++);
            this.city = result.getString(pos++);
            this.state = result.getString(pos++);
            this.postalCode = result.getString(pos++);
            this.countryCode = result.getString(pos++);
            this.created = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
            this.createdBy = User.Name.valueOf(result.getString(pos++));
            this.principalName = result.getString(pos++);
            this.useMonthly = result.getBoolean(pos++);
            this.isActive = result.getBoolean(pos++);
            this.deactivatedOn = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
            this.deactivateReason = result.getString(pos++);
            this.description = result.getString(pos++);
            this.encryptedCardNumber = result.getString(pos++);
            this.encryptionCardNumberFrom = result.getInt(pos++);
            if (result.wasNull()) {
                this.encryptionCardNumberFrom = -1;
            }
            this.encryptionCardNumberRecipient = result.getInt(pos++);
            if (result.wasNull()) {
                this.encryptionCardNumberRecipient = -1;
            }
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.processorId = in.readUTF().intern();
            this.accounting = Account.Name.valueOf(in.readUTF()).intern();
            this.groupName = in.readNullUTF();
            this.cardInfo = in.readUTF();
            this.expirationMonth = in.readNullByte();
            this.expirationYear = in.readNullShort();
            this.providerUniqueId = in.readUTF();
            this.firstName = in.readUTF();
            this.lastName = in.readUTF();
            this.companyName = in.readNullUTF();
            this.email = Email.valueOf((String)in.readNullUTF());
            this.phone = in.readNullUTF();
            this.fax = in.readNullUTF();
            this.customerId = in.readNullUTF();
            this.customerTaxId = in.readNullUTF();
            this.streetAddress1 = in.readUTF();
            this.streetAddress2 = in.readNullUTF();
            this.city = in.readUTF();
            this.state = InternUtils.intern((String)in.readNullUTF());
            this.postalCode = in.readNullUTF();
            this.countryCode = in.readUTF().intern();
            this.created = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.createdBy = User.Name.valueOf(in.readUTF()).intern();
            this.principalName = in.readNullUTF();
            this.useMonthly = in.readBoolean();
            this.isActive = in.readBoolean();
            this.deactivatedOn = SQLStreamables.readNullUnmodifiableTimestamp((DataInputStream)in);
            this.deactivateReason = in.readNullUTF();
            this.description = in.readNullUTF();
            this.encryptedCardNumber = in.readNullUTF();
            this.encryptionCardNumberFrom = in.readCompressedInt();
            this.encryptionCardNumberRecipient = in.readCompressedInt();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.CREDIT_CARDS, this.pkey});
    }

    @Override
    public String toStringImpl() {
        return this.providerUniqueId != null ? this.providerUniqueId : this.cardInfo;
    }

    public boolean getUseMonthly() {
        return this.useMonthly;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_29) >= 0) {
            out.writeUTF(this.processorId);
        }
        out.writeUTF(this.accounting.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_28) <= 0) {
            out.writeCompressedInt(0);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_29) >= 0) {
            out.writeNullUTF(this.groupName);
        }
        out.writeUTF(this.cardInfo);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_82_0) >= 0) {
            out.writeNullByte(this.expirationMonth);
            out.writeNullShort(this.expirationYear);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_28) <= 0) {
            out.writeCompressedInt(0);
            out.writeCompressedInt(0);
            out.writeCompressedInt(0);
            out.writeCompressedInt(0);
            out.writeCompressedInt(0);
            if (this.state == null) {
                out.writeCompressedInt(-1);
            } else {
                out.writeCompressedInt(0);
            }
            out.writeCompressedInt(0);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_29) >= 0) {
            out.writeUTF(this.providerUniqueId);
            out.writeUTF(this.firstName);
            out.writeUTF(this.lastName);
            out.writeNullUTF(this.companyName);
            out.writeNullUTF(Objects.toString(this.email, null));
            out.writeNullUTF(this.phone);
            out.writeNullUTF(this.fax);
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_82_1) >= 0) {
                out.writeNullUTF(this.customerId);
            }
            out.writeNullUTF(this.customerTaxId);
            out.writeUTF(this.streetAddress1);
            out.writeNullUTF(this.streetAddress2);
            out.writeUTF(this.city);
            out.writeNullUTF(this.state);
            out.writeNullUTF(this.postalCode);
            out.writeUTF(this.countryCode);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.created.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.created, (DataOutputStream)out);
        }
        out.writeUTF(this.createdBy.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_29) >= 0) {
            out.writeNullUTF(this.principalName);
        }
        out.writeBoolean(this.useMonthly);
        out.writeBoolean(this.isActive);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.deactivatedOn == null ? -1L : this.deactivatedOn.getTime());
        } else {
            SQLStreamables.writeNullTimestamp((Timestamp)this.deactivatedOn, (DataOutputStream)out);
        }
        out.writeNullUTF(this.deactivateReason);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_28) <= 0) {
            out.writeCompressedInt(Integer.MAX_VALUE - this.pkey);
        }
        out.writeNullUTF(this.description);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_31) >= 0) {
            out.writeNullUTF(this.encryptedCardNumber);
            out.writeCompressedInt(this.encryptionCardNumberFrom);
            out.writeCompressedInt(this.encryptionCardNumberRecipient);
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_82_0) < 0) {
                out.writeNullUTF(null);
                out.writeCompressedInt(-1);
                out.writeCompressedInt(-1);
            }
        }
    }

    public void update(String cardInfo, String firstName, String lastName, String companyName, Email email, String phone, String fax, String customerId, String customerTaxId, String streetAddress1, String streetAddress2, String city, String state, String postalCode, CountryCode countryCode, String description) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.UPDATE_CREDIT_CARD, this.pkey, cardInfo, firstName, lastName, companyName == null ? "" : companyName, email == null ? "" : email.toString(), phone == null ? "" : phone, fax == null ? "" : fax, customerId == null ? "" : customerId, customerTaxId == null ? "" : customerTaxId, streetAddress1, streetAddress2 == null ? "" : streetAddress2, city, state == null ? "" : state, postalCode == null ? "" : postalCode, countryCode.getCode(), description == null ? "" : description);
    }

    public void updateCardNumberAndExpiration(final String maskedCardNumber, String cardNumber, final byte expirationMonth, final short expirationYear) throws IOException, SQLException {
        Processor processor = this.getCreditCardProcessor();
        final EncryptionKey encryptionFrom = processor.getEncryptionFrom();
        final EncryptionKey encryptionRecipient = processor.getEncryptionRecipient();
        final String encryptedCardNumber = encryptionFrom != null && encryptionRecipient != null ? encryptionFrom.encrypt(encryptionRecipient, CreditCard.randomize(cardNumber)) : null;
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.UPDATE_CREDIT_CARD_NUMBER_AND_EXPIRATION, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(CreditCard.this.pkey);
                out.writeUTF(maskedCardNumber);
                out.writeByte((int)expirationMonth);
                out.writeShort((int)expirationYear);
                out.writeNullUTF(encryptedCardNumber);
                out.writeCompressedInt(encryptionFrom == null ? -1 : encryptionFrom.getPkey());
                out.writeCompressedInt(encryptionRecipient == null ? -1 : encryptionRecipient.getPkey());
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unknown response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                CreditCard.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }

    public void updateCardExpiration(byte expirationMonth, short expirationYear) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.UPDATE_CREDIT_CARD_EXPIRATION, this.pkey, expirationMonth, expirationYear);
    }

    public void reactivate() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REACTIVATE_CREDIT_CARD, this.pkey);
    }

    public synchronized String getCardNumber(String passphrase) throws IOException, SQLException {
        if (this.decryptCardNumberPassphrase == null || !passphrase.equals(this.decryptCardNumberPassphrase)) {
            this.decryptCardNumberPassphrase = null;
            this.cardNumber = null;
            if (this.encryptedCardNumber != null) {
                this.cardNumber = CreditCard.derandomize(this.getEncryptionCardNumberRecipient().decrypt(this.encryptedCardNumber, passphrase));
            }
            this.decryptCardNumberPassphrase = passphrase;
        }
        return this.cardNumber;
    }
}

