/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.payment;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.net.Email;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.payment.CountryCode;
import com.aoindustries.aoserv.client.payment.CreditCard;
import com.aoindustries.aoserv.client.payment.Processor;
import com.aoindustries.aoserv.client.pki.EncryptionKey;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

public final class CreditCardTable
extends CachedTableIntegerKey<CreditCard> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("accounting", true), new AoservTable.OrderBy("created", true)};

    CreditCardTable(AoservConnector connector) {
        super(connector, CreditCard.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int addCreditCard(final Processor processor, final Account business, final String groupName, final String cardInfo, final byte expirationMonth, final short expirationYear, final String providerUniqueId, final String firstName, final String lastName, final String companyName, final Email email, final String phone, final String fax, final String customerId, final String customerTaxId, final String streetAddress1, final String streetAddress2, final String city, final String state, final String postalCode, final CountryCode countryCode, final String principalName, final String description, String cardNumber) throws IOException, SQLException {
        if (cardNumber == null) {
            throw new NullPointerException("billing_card_number is null");
        }
        if (cardNumber.indexOf(10) != -1) {
            throw new IllegalArgumentException("billing_card_number may not contain '\n'");
        }
        if (!this.connector.isSecure()) {
            throw new IOException("Credit cards may only be added when using secure protocols.  Currently using the " + this.connector.getProtocol() + " protocol, which is not secure.");
        }
        final EncryptionKey encryptionFrom = processor.getEncryptionFrom();
        final EncryptionKey encryptionRecipient = processor.getEncryptionRecipient();
        final String encryptedCardNumber = encryptionFrom != null && encryptionRecipient != null ? encryptionFrom.encrypt(encryptionRecipient, CreditCard.randomize(cardNumber)) : null;
        return this.connector.requestResult(true, AoservProtocol.CommandId.ADD, new AoservConnector.ResultRequest<Integer>(){
            private int pkey;
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.CREDIT_CARDS.ordinal());
                out.writeUTF(processor.getProviderId());
                out.writeUTF(business.getName().toString());
                out.writeNullUTF(groupName);
                out.writeUTF(cardInfo);
                out.writeByte((int)expirationMonth);
                out.writeShort((int)expirationYear);
                out.writeUTF(providerUniqueId);
                out.writeUTF(firstName);
                out.writeUTF(lastName);
                out.writeNullUTF(companyName);
                out.writeNullUTF(Objects.toString(email, null));
                out.writeNullUTF(phone);
                out.writeNullUTF(fax);
                out.writeNullUTF(customerId);
                out.writeNullUTF(customerTaxId);
                out.writeUTF(streetAddress1);
                out.writeNullUTF(streetAddress2);
                out.writeUTF(city);
                out.writeNullUTF(state);
                out.writeNullUTF(postalCode);
                out.writeUTF(countryCode.getCode());
                out.writeNullUTF(principalName);
                out.writeNullUTF(description);
                out.writeNullUTF(encryptedCardNumber);
                out.writeCompressedInt(encryptionFrom == null ? -1 : encryptionFrom.getPkey());
                out.writeCompressedInt(encryptionRecipient == null ? -1 : encryptionRecipient.getPkey());
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unknown response code: " + code);
                }
                this.pkey = in.readCompressedInt();
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public Integer afterRelease() {
                CreditCardTable.this.connector.tablesUpdated(this.invalidateList);
                return this.pkey;
            }
        });
    }

    @Override
    public CreditCard get(int pkey) throws SQLException, IOException {
        return (CreditCard)this.getUniqueRow(0, pkey);
    }

    public List<CreditCard> getCreditCards(Account business) throws IOException, SQLException {
        return this.getIndexedRows(2, business.getName());
    }

    List<CreditCard> getCreditCards(Processor processor) throws IOException, SQLException {
        return this.getIndexedRows(1, processor.getProviderId());
    }

    public CreditCard getMonthlyCreditCard(Account business) throws IOException, SQLException {
        Account.Name accounting = business.getName();
        List cards = this.getRows();
        int size = cards.size();
        for (int c = 0; c < size; ++c) {
            CreditCard tcard = (CreditCard)cards.get(c);
            if (!tcard.getIsActive() || !tcard.getUseMonthly() || !tcard.getAccount_name().equals(accounting)) continue;
            return tcard;
        }
        return null;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.CREDIT_CARDS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("decline_credit_card")) {
            if (Aosh.checkParamCount("decline_credit_card", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().declineCreditCard(Aosh.parseInt(args[1], "pkey"), args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_credit_card")) {
            if (Aosh.checkParamCount("remove_credit_card", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeCreditCard(Aosh.parseInt(args[1], "pkey"));
            }
            return true;
        }
        return false;
    }
}

