/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.payment;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.i18n.Money;
import com.aoapps.lang.math.SafeMath;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.Email;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.billing.MoneyUtil;
import com.aoindustries.aoserv.client.payment.CountryCode;
import com.aoindustries.aoserv.client.payment.Processor;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Currency;
import java.util.Objects;

public final class Payment
extends CachedObjectIntegerKey<Payment> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_PROCESSOR_ID = 1;
    static final String COLUMN_ACCOUNTING_name = "accounting";
    static final String COLUMN_AUTHORIZATION_TIME_name = "authorization_time";
    static final String COLUMN_PKEY_name = "pkey";
    private String processorId;
    private Account.Name accounting;
    private String groupName;
    private boolean testMode;
    private int duplicateWindow;
    private String orderNumber;
    private Money amount;
    private Money taxAmount;
    private boolean taxExempt;
    private Money shippingAmount;
    private Money dutyAmount;
    private String shippingFirstName;
    private String shippingLastName;
    private String shippingCompanyName;
    private String shippingStreetAddress1;
    private String shippingStreetAddress2;
    private String shippingCity;
    private String shippingState;
    private String shippingPostalCode;
    private String shippingCountryCode;
    private boolean emailCustomer;
    private Email merchantEmail;
    private String invoiceNumber;
    private String purchaseOrderNumber;
    private String description;
    private User.Name creditCardCreatedBy;
    private String creditCardPrincipalName;
    private Account.Name creditCardAccounting;
    private String creditCardGroupName;
    private String creditCardProviderUniqueId;
    private String creditCardMaskedCardNumber;
    private Byte creditCard_expirationMonth;
    private Short creditCard_expirationYear;
    private String creditCardFirstName;
    private String creditCardLastName;
    private String creditCardCompanyName;
    private Email creditCardEmail;
    private String creditCardPhone;
    private String creditCardFax;
    private String creditCardCustomerId;
    private String creditCardCustomerTaxId;
    private String creditCardStreetAddress1;
    private String creditCardStreetAddress2;
    private String creditCardCity;
    private String creditCardState;
    private String creditCardPostalCode;
    private String creditCardCountryCode;
    private String creditCardComments;
    private UnmodifiableTimestamp authorizationTime;
    private User.Name authorizationUsername;
    private String authorizationPrincipalName;
    private String authorizationCommunicationResult;
    private String authorizationProviderErrorCode;
    private String authorizationErrorCode;
    private String authorizationProviderErrorMessage;
    private String authorizationProviderUniqueId;
    private String authorizationResult_providerReplacementMaskedCardNumber;
    private String authorizationResult_replacementMaskedCardNumber;
    private String authorizationResult_providerReplacementExpiration;
    private Byte authorizationResult_replacementExpirationMonth;
    private Short authorizationResult_replacementExpirationYear;
    private String authorizationProviderApprovalResult;
    private String authorizationApprovalResult;
    private String authorizationProviderDeclineReason;
    private String authorizationDeclineReason;
    private String authorizationProviderReviewReason;
    private String authorizationReviewReason;
    private String authorizationProviderCvvResult;
    private String authorizationCvvResult;
    private String authorizationProviderAvsResult;
    private String authorizationAvsResult;
    private String authorizationApprovalCode;
    private UnmodifiableTimestamp captureTime;
    private User.Name captureUsername;
    private String capturePrincipalName;
    private String captureCommunicationResult;
    private String captureProviderErrorCode;
    private String captureErrorCode;
    private String captureProviderErrorMessage;
    private String captureProviderUniqueId;
    private UnmodifiableTimestamp voidTime;
    private User.Name voidUsername;
    private String voidPrincipalName;
    private String voidCommunicationResult;
    private String voidProviderErrorCode;
    private String voidErrorCode;
    private String voidProviderErrorMessage;
    private String voidProviderUniqueId;
    private String status;

    @Deprecated
    public Payment() {
    }

    public Processor getCreditCardProcessor() throws SQLException, IOException {
        Processor ccp = this.table.getConnector().getPayment().getProcessor().get(this.processorId);
        if (ccp == null) {
            throw new SQLException("Unable to find CreditCardProcessor: " + this.processorId);
        }
        return ccp;
    }

    public Account.Name getAccount_name() {
        return this.accounting;
    }

    public Account getAccount() throws SQLException, IOException {
        Account account = this.table.getConnector().getAccount().getAccount().get(this.accounting);
        if (account == null) {
            throw new SQLException("Unable to find Account: " + this.accounting);
        }
        return account;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean getTestMode() {
        return this.testMode;
    }

    public int getDuplicateWindow() {
        return this.duplicateWindow;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public Money getAmount() {
        return this.amount;
    }

    public Money getTaxAmount() {
        return this.taxAmount;
    }

    public boolean getTaxExempt() {
        return this.taxExempt;
    }

    public Money getShippingAmount() {
        return this.shippingAmount;
    }

    public Money getDutyAmount() {
        return this.dutyAmount;
    }

    public String getShippingFirstName() {
        return this.shippingFirstName;
    }

    public String getShippingLastName() {
        return this.shippingLastName;
    }

    public String getShippingCompanyName() {
        return this.shippingCompanyName;
    }

    public String getShippingStreetAddress1() {
        return this.shippingStreetAddress1;
    }

    public String getShippingStreetAddress2() {
        return this.shippingStreetAddress2;
    }

    public String getShippingCity() {
        return this.shippingCity;
    }

    public String getShippingState() {
        return this.shippingState;
    }

    public String getShippingPostalCode() {
        return this.shippingPostalCode;
    }

    public CountryCode getShippingCountryCode() throws SQLException, IOException {
        if (this.shippingCountryCode == null) {
            return null;
        }
        CountryCode cc = this.table.getConnector().getPayment().getCountryCode().get(this.shippingCountryCode);
        if (cc == null) {
            throw new SQLException("Unable to find CountryCode: " + this.shippingCountryCode);
        }
        return cc;
    }

    public boolean getEmailCustomer() {
        return this.emailCustomer;
    }

    public Email getMerchantEmail() {
        return this.merchantEmail;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public Administrator getCreditCardCreatedBy() throws SQLException, IOException {
        Administrator administrator = this.table.getConnector().getAccount().getAdministrator().get(this.creditCardCreatedBy);
        if (administrator == null) {
            throw new SQLException("Unable to find Administrator: " + this.creditCardCreatedBy);
        }
        return administrator;
    }

    public String getCreditCardPrincipalName() {
        return this.creditCardPrincipalName;
    }

    public Account getCreditCardAccount() throws SQLException, IOException {
        Account business = this.table.getConnector().getAccount().getAccount().get(this.creditCardAccounting);
        if (business == null) {
            throw new SQLException("Unable to find Account: " + this.creditCardAccounting);
        }
        return business;
    }

    public String getCreditCardGroupName() {
        return this.creditCardGroupName;
    }

    public String getCreditCardProviderUniqueId() {
        return this.creditCardProviderUniqueId;
    }

    public String getCreditCardMaskedCardNumber() {
        return this.creditCardMaskedCardNumber;
    }

    public Byte getCreditCard_expirationMonth() {
        return this.creditCard_expirationMonth;
    }

    public Short getCreditCard_expirationYear() {
        return this.creditCard_expirationYear;
    }

    public String getCreditCardFirstName() {
        return this.creditCardFirstName;
    }

    public String getCreditCardLastName() {
        return this.creditCardLastName;
    }

    public String getCreditCardCompanyName() {
        return this.creditCardCompanyName;
    }

    public Email getCreditCardEmail() {
        return this.creditCardEmail;
    }

    public String getCreditCardPhone() {
        return this.creditCardPhone;
    }

    public String getCreditCardFax() {
        return this.creditCardFax;
    }

    public String getCreditCardCustomerId() {
        return this.creditCardCustomerId;
    }

    public String getCreditCardCustomerTaxId() {
        return this.creditCardCustomerTaxId;
    }

    public String getCreditCardStreetAddress1() {
        return this.creditCardStreetAddress1;
    }

    public String getCreditCardStreetAddress2() {
        return this.creditCardStreetAddress2;
    }

    public String getCreditCardCity() {
        return this.creditCardCity;
    }

    public String getCreditCardState() {
        return this.creditCardState;
    }

    public String getCreditCardPostalCode() {
        return this.creditCardPostalCode;
    }

    public CountryCode getCreditCardCountryCode() throws SQLException, IOException {
        CountryCode cc = this.table.getConnector().getPayment().getCountryCode().get(this.creditCardCountryCode);
        if (cc == null) {
            throw new SQLException("Unable to find CountryCode: " + this.creditCardCountryCode);
        }
        return cc;
    }

    public String getCreditCardComments() {
        return this.creditCardComments;
    }

    public UnmodifiableTimestamp getAuthorizationTime() {
        return this.authorizationTime;
    }

    public Administrator getAuthorizationAdministrator() throws SQLException, IOException {
        if (this.authorizationUsername == null) {
            return null;
        }
        Administrator administrator = this.table.getConnector().getAccount().getAdministrator().get(this.authorizationUsername);
        if (administrator == null) {
            throw new SQLException("Unable to find Administrator: " + this.authorizationUsername);
        }
        return administrator;
    }

    public String getAuthorizationPrincipalName() {
        return this.authorizationPrincipalName;
    }

    public String getAuthorizationCommunicationResult() {
        return this.authorizationCommunicationResult;
    }

    public String getAuthorizationProviderErrorCode() {
        return this.authorizationProviderErrorCode;
    }

    public String getAuthorizationErrorCode() {
        return this.authorizationErrorCode;
    }

    public String getAuthorizationProviderErrorMessage() {
        return this.authorizationProviderErrorMessage;
    }

    public String getAuthorizationProviderUniqueId() {
        return this.authorizationProviderUniqueId;
    }

    public String getAuthorizationProviderReplacementMaskedCardNumber() {
        return this.authorizationResult_providerReplacementMaskedCardNumber;
    }

    public String getAuthorizationReplacementMaskedCardNumber() {
        return this.authorizationResult_replacementMaskedCardNumber;
    }

    public String getAuthorizationProviderReplacementExpiration() {
        return this.authorizationResult_providerReplacementExpiration;
    }

    public Byte getAuthorizationReplacementExpirationMonth() {
        return this.authorizationResult_replacementExpirationMonth;
    }

    public Short getAuthorizationReplacementExpirationYear() {
        return this.authorizationResult_replacementExpirationYear;
    }

    public String getAuthorizationProviderApprovalResult() {
        return this.authorizationProviderApprovalResult;
    }

    public String getAuthorizationApprovalResult() {
        return this.authorizationApprovalResult;
    }

    public String getAuthorizationProviderDeclineReason() {
        return this.authorizationProviderDeclineReason;
    }

    public String getAuthorizationDeclineReason() {
        return this.authorizationDeclineReason;
    }

    public String getAuthorizationProviderReviewReason() {
        return this.authorizationProviderReviewReason;
    }

    public String getAuthorizationReviewReason() {
        return this.authorizationReviewReason;
    }

    public String getAuthorizationProviderCvvResult() {
        return this.authorizationProviderCvvResult;
    }

    public String getAuthorizationCvvResult() {
        return this.authorizationCvvResult;
    }

    public String getAuthorizationProviderAvsResult() {
        return this.authorizationProviderAvsResult;
    }

    public String getAuthorizationAvsResult() {
        return this.authorizationAvsResult;
    }

    public String getAuthorizationApprovalCode() {
        return this.authorizationApprovalCode;
    }

    public UnmodifiableTimestamp getCaptureTime() {
        return this.captureTime;
    }

    public Administrator getCaptureAdministrator() throws SQLException, IOException {
        if (this.captureUsername == null) {
            return null;
        }
        Administrator administrator = this.table.getConnector().getAccount().getAdministrator().get(this.captureUsername);
        if (administrator == null) {
            throw new SQLException("Unable to find Administrator: " + this.captureUsername);
        }
        return administrator;
    }

    public String getCapturePrincipalName() {
        return this.capturePrincipalName;
    }

    public String getCaptureCommunicationResult() {
        return this.captureCommunicationResult;
    }

    public String getCaptureProviderErrorCode() {
        return this.captureProviderErrorCode;
    }

    public String getCaptureErrorCode() {
        return this.captureErrorCode;
    }

    public String getCaptureProviderErrorMessage() {
        return this.captureProviderErrorMessage;
    }

    public String getCaptureProviderUniqueId() {
        return this.captureProviderUniqueId;
    }

    public UnmodifiableTimestamp getVoidTime() {
        return this.voidTime;
    }

    public Administrator getVoidAdministrator() throws SQLException, IOException {
        if (this.voidUsername == null) {
            return null;
        }
        Administrator administrator = this.table.getConnector().getAccount().getAdministrator().get(this.voidUsername);
        if (administrator == null) {
            throw new SQLException("Unable to find Administrator: " + this.voidUsername);
        }
        return administrator;
    }

    public String getVoidPrincipalName() {
        return this.voidPrincipalName;
    }

    public String getVoidCommunicationResult() {
        return this.voidCommunicationResult;
    }

    public String getVoidProviderErrorCode() {
        return this.voidProviderErrorCode;
    }

    public String getVoidErrorCode() {
        return this.voidErrorCode;
    }

    public String getVoidProviderErrorMessage() {
        return this.voidProviderErrorMessage;
    }

    public String getVoidProviderUniqueId() {
        return this.voidProviderUniqueId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.processorId;
            }
            case 2: {
                return this.accounting;
            }
            case 3: {
                return this.groupName;
            }
            case 4: {
                return this.testMode;
            }
            case 5: {
                return this.duplicateWindow;
            }
            case 6: {
                return this.orderNumber;
            }
            case 7: {
                return this.amount;
            }
            case 8: {
                return this.taxAmount;
            }
            case 9: {
                return this.taxExempt;
            }
            case 10: {
                return this.shippingAmount;
            }
            case 11: {
                return this.dutyAmount;
            }
            case 12: {
                return this.shippingFirstName;
            }
            case 13: {
                return this.shippingLastName;
            }
            case 14: {
                return this.shippingCompanyName;
            }
            case 15: {
                return this.shippingStreetAddress1;
            }
            case 16: {
                return this.shippingStreetAddress2;
            }
            case 17: {
                return this.shippingCity;
            }
            case 18: {
                return this.shippingState;
            }
            case 19: {
                return this.shippingPostalCode;
            }
            case 20: {
                return this.shippingCountryCode;
            }
            case 21: {
                return this.emailCustomer;
            }
            case 22: {
                return this.merchantEmail;
            }
            case 23: {
                return this.invoiceNumber;
            }
            case 24: {
                return this.purchaseOrderNumber;
            }
            case 25: {
                return this.description;
            }
            case 26: {
                return this.creditCardCreatedBy;
            }
            case 27: {
                return this.creditCardPrincipalName;
            }
            case 28: {
                return this.creditCardAccounting;
            }
            case 29: {
                return this.creditCardGroupName;
            }
            case 30: {
                return this.creditCardProviderUniqueId;
            }
            case 31: {
                return this.creditCardMaskedCardNumber;
            }
            case 32: {
                return this.creditCard_expirationMonth == null ? null : Short.valueOf(this.creditCard_expirationMonth.shortValue());
            }
            case 33: {
                return this.creditCard_expirationYear;
            }
            case 34: {
                return this.creditCardFirstName;
            }
            case 35: {
                return this.creditCardLastName;
            }
            case 36: {
                return this.creditCardCompanyName;
            }
            case 37: {
                return this.creditCardEmail;
            }
            case 38: {
                return this.creditCardPhone;
            }
            case 39: {
                return this.creditCardFax;
            }
            case 40: {
                return this.creditCardCustomerId;
            }
            case 41: {
                return this.creditCardCustomerTaxId;
            }
            case 42: {
                return this.creditCardStreetAddress1;
            }
            case 43: {
                return this.creditCardStreetAddress2;
            }
            case 44: {
                return this.creditCardCity;
            }
            case 45: {
                return this.creditCardState;
            }
            case 46: {
                return this.creditCardPostalCode;
            }
            case 47: {
                return this.creditCardCountryCode;
            }
            case 48: {
                return this.creditCardComments;
            }
            case 49: {
                return this.authorizationTime;
            }
            case 50: {
                return this.authorizationUsername;
            }
            case 51: {
                return this.authorizationPrincipalName;
            }
            case 52: {
                return this.authorizationCommunicationResult;
            }
            case 53: {
                return this.authorizationProviderErrorCode;
            }
            case 54: {
                return this.authorizationErrorCode;
            }
            case 55: {
                return this.authorizationProviderErrorMessage;
            }
            case 56: {
                return this.authorizationProviderUniqueId;
            }
            case 57: {
                return this.authorizationResult_providerReplacementMaskedCardNumber;
            }
            case 58: {
                return this.authorizationResult_replacementMaskedCardNumber;
            }
            case 59: {
                return this.authorizationResult_providerReplacementExpiration;
            }
            case 60: {
                return this.authorizationResult_replacementExpirationMonth == null ? null : Short.valueOf(this.authorizationResult_replacementExpirationMonth.shortValue());
            }
            case 61: {
                return this.authorizationResult_replacementExpirationYear;
            }
            case 62: {
                return this.authorizationProviderApprovalResult;
            }
            case 63: {
                return this.authorizationApprovalResult;
            }
            case 64: {
                return this.authorizationProviderDeclineReason;
            }
            case 65: {
                return this.authorizationDeclineReason;
            }
            case 66: {
                return this.authorizationProviderReviewReason;
            }
            case 67: {
                return this.authorizationReviewReason;
            }
            case 68: {
                return this.authorizationProviderCvvResult;
            }
            case 69: {
                return this.authorizationCvvResult;
            }
            case 70: {
                return this.authorizationProviderAvsResult;
            }
            case 71: {
                return this.authorizationAvsResult;
            }
            case 72: {
                return this.authorizationApprovalCode;
            }
            case 73: {
                return this.captureTime;
            }
            case 74: {
                return this.captureUsername;
            }
            case 75: {
                return this.capturePrincipalName;
            }
            case 76: {
                return this.captureCommunicationResult;
            }
            case 77: {
                return this.captureProviderErrorCode;
            }
            case 78: {
                return this.captureErrorCode;
            }
            case 79: {
                return this.captureProviderErrorMessage;
            }
            case 80: {
                return this.captureProviderUniqueId;
            }
            case 81: {
                return this.voidTime;
            }
            case 82: {
                return this.voidUsername;
            }
            case 83: {
                return this.voidPrincipalName;
            }
            case 84: {
                return this.voidCommunicationResult;
            }
            case 85: {
                return this.voidProviderErrorCode;
            }
            case 86: {
                return this.voidErrorCode;
            }
            case 87: {
                return this.voidProviderErrorMessage;
            }
            case 88: {
                return this.voidProviderUniqueId;
            }
            case 89: {
                return this.status;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.CREDIT_CARD_TRANSACTIONS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.processorId = result.getString(pos++);
            this.accounting = Account.Name.valueOf(result.getString(pos++));
            this.groupName = result.getString(pos++);
            this.testMode = result.getBoolean(pos++);
            this.duplicateWindow = result.getInt(pos++);
            this.orderNumber = result.getString(pos++);
            Currency currency = Currency.getInstance(result.getString(pos++));
            this.amount = new Money(currency, result.getBigDecimal(pos++));
            this.taxAmount = MoneyUtil.getMoney(currency, result.getBigDecimal(pos++));
            this.taxExempt = result.getBoolean(pos++);
            this.shippingAmount = MoneyUtil.getMoney(currency, result.getBigDecimal(pos++));
            this.dutyAmount = MoneyUtil.getMoney(currency, result.getBigDecimal(pos++));
            this.shippingFirstName = result.getString(pos++);
            this.shippingLastName = result.getString(pos++);
            this.shippingCompanyName = result.getString(pos++);
            this.shippingStreetAddress1 = result.getString(pos++);
            this.shippingStreetAddress2 = result.getString(pos++);
            this.shippingCity = result.getString(pos++);
            this.shippingState = result.getString(pos++);
            this.shippingPostalCode = result.getString(pos++);
            this.shippingCountryCode = result.getString(pos++);
            this.emailCustomer = result.getBoolean(pos++);
            this.merchantEmail = Email.valueOf((String)result.getString(pos++));
            this.invoiceNumber = result.getString(pos++);
            this.purchaseOrderNumber = result.getString(pos++);
            this.description = result.getString(pos++);
            this.creditCardCreatedBy = User.Name.valueOf(result.getString(pos++));
            this.creditCardPrincipalName = result.getString(pos++);
            this.creditCardAccounting = Account.Name.valueOf(result.getString(pos++));
            this.creditCardGroupName = result.getString(pos++);
            this.creditCardProviderUniqueId = result.getString(pos++);
            this.creditCardMaskedCardNumber = result.getString(pos++);
            this.creditCard_expirationMonth = SafeMath.castByte((int)result.getShort(pos++));
            if (result.wasNull()) {
                this.creditCard_expirationMonth = null;
            }
            this.creditCard_expirationYear = result.getShort(pos++);
            if (result.wasNull()) {
                this.creditCard_expirationYear = null;
            }
            this.creditCardFirstName = result.getString(pos++);
            this.creditCardLastName = result.getString(pos++);
            this.creditCardCompanyName = result.getString(pos++);
            this.creditCardEmail = Email.valueOf((String)result.getString(pos++));
            this.creditCardPhone = result.getString(pos++);
            this.creditCardFax = result.getString(pos++);
            this.creditCardCustomerId = result.getString(pos++);
            this.creditCardCustomerTaxId = result.getString(pos++);
            this.creditCardStreetAddress1 = result.getString(pos++);
            this.creditCardStreetAddress2 = result.getString(pos++);
            this.creditCardCity = result.getString(pos++);
            this.creditCardState = result.getString(pos++);
            this.creditCardPostalCode = result.getString(pos++);
            this.creditCardCountryCode = result.getString(pos++);
            this.creditCardComments = result.getString(pos++);
            this.authorizationTime = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
            this.authorizationUsername = User.Name.valueOf(result.getString(pos++));
            this.authorizationPrincipalName = result.getString(pos++);
            this.authorizationCommunicationResult = result.getString(pos++);
            this.authorizationProviderErrorCode = result.getString(pos++);
            this.authorizationErrorCode = result.getString(pos++);
            this.authorizationProviderErrorMessage = result.getString(pos++);
            this.authorizationProviderUniqueId = result.getString(pos++);
            this.authorizationResult_providerReplacementMaskedCardNumber = result.getString(pos++);
            this.authorizationResult_replacementMaskedCardNumber = result.getString(pos++);
            this.authorizationResult_providerReplacementExpiration = result.getString(pos++);
            this.authorizationResult_replacementExpirationMonth = SafeMath.castByte((int)result.getShort(pos++));
            if (result.wasNull()) {
                this.authorizationResult_replacementExpirationMonth = null;
            }
            this.authorizationResult_replacementExpirationYear = result.getShort(pos++);
            if (result.wasNull()) {
                this.authorizationResult_replacementExpirationYear = null;
            }
            this.authorizationProviderApprovalResult = result.getString(pos++);
            this.authorizationApprovalResult = result.getString(pos++);
            this.authorizationProviderDeclineReason = result.getString(pos++);
            this.authorizationDeclineReason = result.getString(pos++);
            this.authorizationProviderReviewReason = result.getString(pos++);
            this.authorizationReviewReason = result.getString(pos++);
            this.authorizationProviderCvvResult = result.getString(pos++);
            this.authorizationCvvResult = result.getString(pos++);
            this.authorizationProviderAvsResult = result.getString(pos++);
            this.authorizationAvsResult = result.getString(pos++);
            this.authorizationApprovalCode = result.getString(pos++);
            this.captureTime = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
            this.captureUsername = User.Name.valueOf(result.getString(pos++));
            this.capturePrincipalName = result.getString(pos++);
            this.captureCommunicationResult = result.getString(pos++);
            this.captureProviderErrorCode = result.getString(pos++);
            this.captureErrorCode = result.getString(pos++);
            this.captureProviderErrorMessage = result.getString(pos++);
            this.captureProviderUniqueId = result.getString(pos++);
            this.voidTime = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
            this.voidUsername = User.Name.valueOf(result.getString(pos++));
            this.voidPrincipalName = result.getString(pos++);
            this.voidCommunicationResult = result.getString(pos++);
            this.voidProviderErrorCode = result.getString(pos++);
            this.voidErrorCode = result.getString(pos++);
            this.voidProviderErrorMessage = result.getString(pos++);
            this.voidProviderUniqueId = result.getString(pos++);
            this.status = result.getString(pos++);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.processorId = in.readUTF().intern();
            this.accounting = Account.Name.valueOf(in.readUTF()).intern();
            this.groupName = in.readNullUTF();
            this.testMode = in.readBoolean();
            this.duplicateWindow = in.readCompressedInt();
            this.orderNumber = in.readNullUTF();
            Currency currency = Currency.getInstance(in.readUTF());
            this.amount = new Money(currency, in.readLong(), in.readCompressedInt());
            this.taxAmount = in.readBoolean() ? new Money(currency, in.readLong(), in.readCompressedInt()) : null;
            this.taxExempt = in.readBoolean();
            this.shippingAmount = in.readBoolean() ? new Money(currency, in.readLong(), in.readCompressedInt()) : null;
            this.dutyAmount = in.readBoolean() ? new Money(currency, in.readLong(), in.readCompressedInt()) : null;
            this.shippingFirstName = in.readNullUTF();
            this.shippingLastName = in.readNullUTF();
            this.shippingCompanyName = in.readNullUTF();
            this.shippingStreetAddress1 = in.readNullUTF();
            this.shippingStreetAddress2 = in.readNullUTF();
            this.shippingCity = in.readNullUTF();
            this.shippingState = InternUtils.intern((String)in.readNullUTF());
            this.shippingPostalCode = in.readNullUTF();
            this.shippingCountryCode = InternUtils.intern((String)in.readNullUTF());
            this.emailCustomer = in.readBoolean();
            this.merchantEmail = Email.valueOf((String)in.readNullUTF());
            this.invoiceNumber = in.readNullUTF();
            this.purchaseOrderNumber = in.readNullUTF();
            this.description = in.readNullUTF();
            this.creditCardCreatedBy = User.Name.valueOf(in.readUTF()).intern();
            this.creditCardPrincipalName = in.readNullUTF();
            this.creditCardAccounting = Account.Name.valueOf(in.readUTF()).intern();
            this.creditCardGroupName = in.readNullUTF();
            this.creditCardProviderUniqueId = in.readNullUTF();
            this.creditCardMaskedCardNumber = in.readUTF();
            this.creditCard_expirationMonth = in.readNullByte();
            this.creditCard_expirationYear = in.readNullShort();
            this.creditCardFirstName = in.readUTF();
            this.creditCardLastName = in.readUTF();
            this.creditCardCompanyName = in.readNullUTF();
            this.creditCardEmail = Email.valueOf((String)in.readNullUTF());
            this.creditCardPhone = in.readNullUTF();
            this.creditCardFax = in.readNullUTF();
            this.creditCardCustomerId = in.readNullUTF();
            this.creditCardCustomerTaxId = in.readNullUTF();
            this.creditCardStreetAddress1 = in.readUTF();
            this.creditCardStreetAddress2 = in.readNullUTF();
            this.creditCardCity = in.readUTF();
            this.creditCardState = InternUtils.intern((String)in.readNullUTF());
            this.creditCardPostalCode = in.readNullUTF();
            this.creditCardCountryCode = in.readUTF().intern();
            this.creditCardComments = in.readNullUTF();
            this.authorizationTime = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.authorizationUsername = (User.Name)InternUtils.intern((Internable)User.Name.valueOf(in.readNullUTF()));
            this.authorizationPrincipalName = InternUtils.intern((String)in.readNullUTF());
            this.authorizationCommunicationResult = InternUtils.intern((String)in.readNullUTF());
            this.authorizationProviderErrorCode = InternUtils.intern((String)in.readNullUTF());
            this.authorizationErrorCode = InternUtils.intern((String)in.readNullUTF());
            this.authorizationProviderErrorMessage = in.readNullUTF();
            this.authorizationProviderUniqueId = in.readNullUTF();
            this.authorizationResult_providerReplacementMaskedCardNumber = in.readNullUTF();
            this.authorizationResult_replacementMaskedCardNumber = in.readNullUTF();
            this.authorizationResult_providerReplacementExpiration = in.readNullUTF();
            this.authorizationResult_replacementExpirationMonth = in.readNullByte();
            this.authorizationResult_replacementExpirationYear = in.readNullShort();
            this.authorizationProviderApprovalResult = InternUtils.intern((String)in.readNullUTF());
            this.authorizationApprovalResult = InternUtils.intern((String)in.readNullUTF());
            this.authorizationProviderDeclineReason = InternUtils.intern((String)in.readNullUTF());
            this.authorizationDeclineReason = InternUtils.intern((String)in.readNullUTF());
            this.authorizationProviderReviewReason = InternUtils.intern((String)in.readNullUTF());
            this.authorizationReviewReason = InternUtils.intern((String)in.readNullUTF());
            this.authorizationProviderCvvResult = InternUtils.intern((String)in.readNullUTF());
            this.authorizationCvvResult = InternUtils.intern((String)in.readNullUTF());
            this.authorizationProviderAvsResult = InternUtils.intern((String)in.readNullUTF());
            this.authorizationAvsResult = InternUtils.intern((String)in.readNullUTF());
            this.authorizationApprovalCode = in.readNullUTF();
            this.captureTime = SQLStreamables.readNullUnmodifiableTimestamp((DataInputStream)in);
            this.captureUsername = (User.Name)InternUtils.intern((Internable)User.Name.valueOf(in.readNullUTF()));
            this.capturePrincipalName = InternUtils.intern((String)in.readNullUTF());
            this.captureCommunicationResult = InternUtils.intern((String)in.readNullUTF());
            this.captureProviderErrorCode = InternUtils.intern((String)in.readNullUTF());
            this.captureErrorCode = InternUtils.intern((String)in.readNullUTF());
            this.captureProviderErrorMessage = in.readNullUTF();
            this.captureProviderUniqueId = in.readNullUTF();
            this.voidTime = SQLStreamables.readNullUnmodifiableTimestamp((DataInputStream)in);
            this.voidUsername = (User.Name)InternUtils.intern((Internable)User.Name.valueOf(in.readNullUTF()));
            this.voidPrincipalName = InternUtils.intern((String)in.readNullUTF());
            this.voidCommunicationResult = InternUtils.intern((String)in.readNullUTF());
            this.voidProviderErrorCode = InternUtils.intern((String)in.readNullUTF());
            this.voidErrorCode = InternUtils.intern((String)in.readNullUTF());
            this.voidProviderErrorMessage = in.readNullUTF();
            this.voidProviderUniqueId = in.readNullUTF();
            this.status = in.readUTF().intern();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.processorId);
        out.writeUTF(this.accounting.toString());
        out.writeNullUTF(this.groupName);
        out.writeBoolean(this.testMode);
        out.writeCompressedInt(this.duplicateWindow);
        out.writeNullUTF(this.orderNumber);
        out.writeUTF(this.amount.getCurrency().getCurrencyCode());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeUTF(this.amount.getValue().toString());
        } else {
            out.writeLong(this.amount.getUnscaledValue());
            out.writeCompressedInt(this.amount.getScale());
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeNullUTF(this.taxAmount == null ? null : this.taxAmount.getValue().toString());
        } else if (this.taxAmount != null) {
            out.writeBoolean(true);
            out.writeLong(this.taxAmount.getUnscaledValue());
            out.writeCompressedInt(this.taxAmount.getScale());
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.taxExempt);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeNullUTF(this.shippingAmount == null ? null : this.shippingAmount.getValue().toString());
        } else if (this.shippingAmount != null) {
            out.writeBoolean(true);
            out.writeLong(this.shippingAmount.getUnscaledValue());
            out.writeCompressedInt(this.shippingAmount.getScale());
        } else {
            out.writeBoolean(false);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeNullUTF(this.dutyAmount == null ? null : this.dutyAmount.getValue().toString());
        } else if (this.dutyAmount != null) {
            out.writeBoolean(true);
            out.writeLong(this.dutyAmount.getUnscaledValue());
            out.writeCompressedInt(this.dutyAmount.getScale());
        } else {
            out.writeBoolean(false);
        }
        out.writeNullUTF(this.shippingFirstName);
        out.writeNullUTF(this.shippingLastName);
        out.writeNullUTF(this.shippingCompanyName);
        out.writeNullUTF(this.shippingStreetAddress1);
        out.writeNullUTF(this.shippingStreetAddress2);
        out.writeNullUTF(this.shippingCity);
        out.writeNullUTF(this.shippingState);
        out.writeNullUTF(this.shippingPostalCode);
        out.writeNullUTF(this.shippingCountryCode);
        out.writeBoolean(this.emailCustomer);
        out.writeNullUTF(Objects.toString(this.merchantEmail, null));
        out.writeNullUTF(this.invoiceNumber);
        out.writeNullUTF(this.purchaseOrderNumber);
        out.writeNullUTF(this.description);
        out.writeUTF(this.creditCardCreatedBy.toString());
        out.writeNullUTF(this.creditCardPrincipalName);
        out.writeUTF(this.creditCardAccounting.toString());
        out.writeNullUTF(this.creditCardGroupName);
        out.writeNullUTF(this.creditCardProviderUniqueId);
        out.writeUTF(this.creditCardMaskedCardNumber);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_82_0) >= 0) {
            out.writeNullByte(this.creditCard_expirationMonth);
            out.writeNullShort(this.creditCard_expirationYear);
        }
        out.writeUTF(this.creditCardFirstName);
        out.writeUTF(this.creditCardLastName);
        out.writeNullUTF(this.creditCardCompanyName);
        out.writeNullUTF(Objects.toString(this.creditCardEmail, null));
        out.writeNullUTF(this.creditCardPhone);
        out.writeNullUTF(this.creditCardFax);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_82_1) >= 0) {
            out.writeNullUTF(this.creditCardCustomerId);
        }
        out.writeNullUTF(this.creditCardCustomerTaxId);
        out.writeUTF(this.creditCardStreetAddress1);
        out.writeNullUTF(this.creditCardStreetAddress2);
        out.writeUTF(this.creditCardCity);
        out.writeNullUTF(this.creditCardState);
        out.writeNullUTF(this.creditCardPostalCode);
        out.writeUTF(this.creditCardCountryCode);
        out.writeNullUTF(this.creditCardComments);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.authorizationTime.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.authorizationTime, (DataOutputStream)out);
        }
        out.writeNullUTF(Objects.toString(this.authorizationUsername, null));
        out.writeNullUTF(this.authorizationPrincipalName);
        out.writeNullUTF(this.authorizationCommunicationResult);
        out.writeNullUTF(this.authorizationProviderErrorCode);
        out.writeNullUTF(this.authorizationErrorCode);
        out.writeNullUTF(this.authorizationProviderErrorMessage);
        out.writeNullUTF(this.authorizationProviderUniqueId);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_82_0) >= 0) {
            out.writeNullUTF(this.authorizationResult_providerReplacementMaskedCardNumber);
            out.writeNullUTF(this.authorizationResult_replacementMaskedCardNumber);
            out.writeNullUTF(this.authorizationResult_providerReplacementExpiration);
            out.writeNullByte(this.authorizationResult_replacementExpirationMonth);
            out.writeNullShort(this.authorizationResult_replacementExpirationYear);
        }
        out.writeNullUTF(this.authorizationProviderApprovalResult);
        out.writeNullUTF(this.authorizationApprovalResult);
        out.writeNullUTF(this.authorizationProviderDeclineReason);
        out.writeNullUTF(this.authorizationDeclineReason);
        out.writeNullUTF(this.authorizationProviderReviewReason);
        out.writeNullUTF(this.authorizationReviewReason);
        out.writeNullUTF(this.authorizationProviderCvvResult);
        out.writeNullUTF(this.authorizationCvvResult);
        out.writeNullUTF(this.authorizationProviderAvsResult);
        out.writeNullUTF(this.authorizationAvsResult);
        out.writeNullUTF(this.authorizationApprovalCode);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.captureTime == null ? -1L : this.captureTime.getTime());
        } else {
            SQLStreamables.writeNullTimestamp((Timestamp)this.captureTime, (DataOutputStream)out);
        }
        out.writeNullUTF(Objects.toString(this.captureUsername, null));
        out.writeNullUTF(this.capturePrincipalName);
        out.writeNullUTF(this.captureCommunicationResult);
        out.writeNullUTF(this.captureProviderErrorCode);
        out.writeNullUTF(this.captureErrorCode);
        out.writeNullUTF(this.captureProviderErrorMessage);
        out.writeNullUTF(this.captureProviderUniqueId);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.voidTime == null ? -1L : this.voidTime.getTime());
        } else {
            SQLStreamables.writeNullTimestamp((Timestamp)this.voidTime, (DataOutputStream)out);
        }
        out.writeNullUTF(Objects.toString(this.voidUsername, null));
        out.writeNullUTF(this.voidPrincipalName);
        out.writeNullUTF(this.voidCommunicationResult);
        out.writeNullUTF(this.voidProviderErrorCode);
        out.writeNullUTF(this.voidErrorCode);
        out.writeNullUTF(this.voidProviderErrorMessage);
        out.writeNullUTF(this.voidProviderUniqueId);
        out.writeUTF(this.status);
    }

    public void saleCompleted(final String authorizationCommunicationResult, final String authorizationProviderErrorCode, final String authorizationErrorCode, final String authorizationProviderErrorMessage, final String authorizationProviderUniqueId, final String authorizationResult_providerReplacementMaskedCardNumber, final String authorizationResult_replacementMaskedCardNumber, final String authorizationResult_providerReplacementExpiration, final Byte authorizationResult_replacementExpirationMonth, final Short authorizationResult_replacementExpirationYear, final String providerApprovalResult, final String approvalResult, final String providerDeclineReason, final String declineReason, final String providerReviewReason, final String reviewReason, final String providerCvvResult, final String cvvResult, final String providerAvsResult, final String avsResult, final String approvalCode, final Timestamp captureTime, final String capturePrincipalName, final String captureCommunicationResult, final String captureProviderErrorCode, final String captureErrorCode, final String captureProviderErrorMessage, final String captureProviderUniqueId, final String status) throws IOException, SQLException {
        if (!this.table.getConnector().isSecure()) {
            throw new IOException("Credit card transactions may only be updated when using secure protocols.  Currently using the " + this.table.getConnector().getProtocol() + " protocol, which is not secure.");
        }
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.CREDIT_CARD_TRANSACTION_SALE_COMPLETED, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Payment.this.pkey);
                out.writeNullUTF(authorizationCommunicationResult);
                out.writeNullUTF(authorizationProviderErrorCode);
                out.writeNullUTF(authorizationErrorCode);
                out.writeNullUTF(authorizationProviderErrorMessage);
                out.writeNullUTF(authorizationProviderUniqueId);
                out.writeNullUTF(authorizationResult_providerReplacementMaskedCardNumber);
                out.writeNullUTF(authorizationResult_replacementMaskedCardNumber);
                out.writeNullUTF(authorizationResult_providerReplacementExpiration);
                out.writeNullByte(authorizationResult_replacementExpirationMonth);
                out.writeNullShort(authorizationResult_replacementExpirationYear);
                out.writeNullUTF(providerApprovalResult);
                out.writeNullUTF(approvalResult);
                out.writeNullUTF(providerDeclineReason);
                out.writeNullUTF(declineReason);
                out.writeNullUTF(providerReviewReason);
                out.writeNullUTF(reviewReason);
                out.writeNullUTF(providerCvvResult);
                out.writeNullUTF(cvvResult);
                out.writeNullUTF(providerAvsResult);
                out.writeNullUTF(avsResult);
                out.writeNullUTF(approvalCode);
                SQLStreamables.writeNullTimestamp((Timestamp)captureTime, (DataOutputStream)out);
                out.writeNullUTF(capturePrincipalName);
                out.writeNullUTF(captureCommunicationResult);
                out.writeNullUTF(captureProviderErrorCode);
                out.writeNullUTF(captureErrorCode);
                out.writeNullUTF(captureProviderErrorMessage);
                out.writeNullUTF(captureProviderUniqueId);
                out.writeNullUTF(status);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unknown response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                Payment.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }

    public void authorizeCompleted(final String authorizationCommunicationResult, final String authorizationProviderErrorCode, final String authorizationErrorCode, final String authorizationProviderErrorMessage, final String authorizationProviderUniqueId, final String authorizationResult_providerReplacementMaskedCardNumber, final String authorizationResult_replacementMaskedCardNumber, final String authorizationResult_providerReplacementExpiration, final Byte authorizationResult_replacementExpirationMonth, final Short authorizationResult_replacementExpirationYear, final String providerApprovalResult, final String approvalResult, final String providerDeclineReason, final String declineReason, final String providerReviewReason, final String reviewReason, final String providerCvvResult, final String cvvResult, final String providerAvsResult, final String avsResult, final String approvalCode, final String status) throws IOException, SQLException {
        if (!this.table.getConnector().isSecure()) {
            throw new IOException("Credit card transactions may only be updated when using secure protocols.  Currently using the " + this.table.getConnector().getProtocol() + " protocol, which is not secure.");
        }
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.CREDIT_CARD_TRANSACTION_AUTHORIZE_COMPLETED, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Payment.this.pkey);
                out.writeNullUTF(authorizationCommunicationResult);
                out.writeNullUTF(authorizationProviderErrorCode);
                out.writeNullUTF(authorizationErrorCode);
                out.writeNullUTF(authorizationProviderErrorMessage);
                out.writeNullUTF(authorizationProviderUniqueId);
                out.writeNullUTF(authorizationResult_providerReplacementMaskedCardNumber);
                out.writeNullUTF(authorizationResult_replacementMaskedCardNumber);
                out.writeNullUTF(authorizationResult_providerReplacementExpiration);
                out.writeNullByte(authorizationResult_replacementExpirationMonth);
                out.writeNullShort(authorizationResult_replacementExpirationYear);
                out.writeNullUTF(providerApprovalResult);
                out.writeNullUTF(approvalResult);
                out.writeNullUTF(providerDeclineReason);
                out.writeNullUTF(declineReason);
                out.writeNullUTF(providerReviewReason);
                out.writeNullUTF(reviewReason);
                out.writeNullUTF(providerCvvResult);
                out.writeNullUTF(cvvResult);
                out.writeNullUTF(providerAvsResult);
                out.writeNullUTF(avsResult);
                out.writeNullUTF(approvalCode);
                out.writeNullUTF(status);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unknown response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                Payment.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }
}

