/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.payment;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.GlobalTableStringKey;
import com.aoindustries.aoserv.client.payment.PaymentType;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;

public final class PaymentTypeTable
extends GlobalTableStringKey<PaymentType> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("name", true)};

    PaymentTypeTable(AoservConnector connector) {
        super(connector, PaymentType.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public PaymentType get(String name) throws IOException, SQLException {
        return (PaymentType)this.getUniqueRow(0, name);
    }

    public PaymentType getCreditCardType(String cardNumber) throws SQLException, IOException {
        StringBuilder numbers = new StringBuilder();
        int len = cardNumber.length();
        for (int c = 0; c < len; ++c) {
            char ch = cardNumber.charAt(c);
            if (ch >= '0' && ch <= '9') {
                numbers.append(ch);
                continue;
            }
            if (ch == '-' || ch == ' ') continue;
            throw new IllegalArgumentException("Invalid character in card number: " + ch);
        }
        PaymentType paymentType = null;
        if (numbers.length() >= 2 && numbers.charAt(0) == '3' && (numbers.charAt(1) == '4' || numbers.charAt(1) == '7')) {
            paymentType = this.get("amex");
        } else if (numbers.length() >= 4 && numbers.charAt(0) == '6' && numbers.charAt(1) == '0' && numbers.charAt(2) == '1' && numbers.charAt(3) == '1') {
            paymentType = this.get("discover");
        } else if (numbers.length() >= 2 && numbers.charAt(0) == '5' && numbers.charAt(1) >= '1' && numbers.charAt(1) <= '5') {
            paymentType = this.get("mastercard");
        } else if (numbers.length() >= 1 && numbers.charAt(0) == '4') {
            paymentType = this.get("visa");
        } else {
            throw new IllegalArgumentException("Unable to determine card type.");
        }
        if (paymentType == null) {
            throw new SQLException("Unable to find payment_type");
        }
        return paymentType;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.PAYMENT_TYPES;
    }
}

