/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.payment;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.CachedObjectStringKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.payment.CreditCard;
import com.aoindustries.aoserv.client.pki.EncryptionKey;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public final class Processor
extends CachedObjectStringKey<Processor> {
    static final int COLUMN_PROVIDER_ID = 0;
    static final int COLUMN_ACCOUNTING = 1;
    static final String COLUMN_ACCOUNTING_name = "accounting";
    static final String COLUMN_PROVIDER_ID_name = "provider_id";
    private Account.Name accounting;
    private String className;
    private String param1;
    private String param2;
    private String param3;
    private String param4;
    private boolean enabled;
    private int weight;
    private String description;
    private int encryptionFrom;
    private int encryptionRecipient;

    @Deprecated
    public Processor() {
    }

    public Account.Name getAccount_name() {
        return this.accounting;
    }

    public Account getAccount() throws SQLException, IOException {
        Account obj = this.table.getConnector().getAccount().getAccount().get(this.accounting);
        if (obj == null) {
            throw new SQLException("Unable to find Account: " + this.accounting);
        }
        return obj;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.accounting;
            }
            case 2: {
                return this.className;
            }
            case 3: {
                return this.param1;
            }
            case 4: {
                return this.param2;
            }
            case 5: {
                return this.param3;
            }
            case 6: {
                return this.param4;
            }
            case 7: {
                return this.enabled;
            }
            case 8: {
                return this.weight;
            }
            case 9: {
                return this.description;
            }
            case 10: {
                return this.encryptionFrom == -1 ? null : Integer.valueOf(this.encryptionFrom);
            }
            case 11: {
                return this.encryptionRecipient == -1 ? null : Integer.valueOf(this.encryptionRecipient);
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public String getProviderId() {
        return this.pkey;
    }

    public String getClassName() {
        return this.className;
    }

    public String getParam1() {
        return this.param1;
    }

    public String getParam2() {
        return this.param2;
    }

    public String getParam3() {
        return this.param3;
    }

    public String getParam4() {
        return this.param4;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getDescription() {
        return this.description;
    }

    public EncryptionKey getEncryptionFrom() throws SQLException, IOException {
        if (this.encryptionFrom == -1) {
            return null;
        }
        EncryptionKey ek = this.table.getConnector().getPki().getEncryptionKey().get(this.encryptionFrom);
        if (ek == null) {
            throw new SQLException("Unable to find EncryptionKey: " + this.encryptionFrom);
        }
        return ek;
    }

    public EncryptionKey getEncryptionRecipient() throws SQLException, IOException {
        if (this.encryptionRecipient == -1) {
            return null;
        }
        EncryptionKey ek = this.table.getConnector().getPki().getEncryptionKey().get(this.encryptionRecipient);
        if (ek == null) {
            throw new SQLException("Unable to find EncryptionKey: " + this.encryptionRecipient);
        }
        return ek;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.CREDIT_CARD_PROCESSORS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getString(pos++);
            this.accounting = Account.Name.valueOf(result.getString(pos++));
            this.className = result.getString(pos++);
            this.param1 = result.getString(pos++);
            this.param2 = result.getString(pos++);
            this.param3 = result.getString(pos++);
            this.param4 = result.getString(pos++);
            this.enabled = result.getBoolean(pos++);
            this.weight = result.getInt(pos++);
            this.description = result.getString(pos++);
            this.encryptionFrom = result.getInt(pos++);
            if (result.wasNull()) {
                this.encryptionFrom = -1;
            }
            this.encryptionRecipient = result.getInt(pos++);
            if (result.wasNull()) {
                this.encryptionRecipient = -1;
            }
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readUTF().intern();
            this.accounting = Account.Name.valueOf(in.readUTF()).intern();
            this.className = in.readUTF();
            this.param1 = in.readNullUTF();
            this.param2 = in.readNullUTF();
            this.param3 = in.readNullUTF();
            this.param4 = in.readNullUTF();
            this.enabled = in.readBoolean();
            this.weight = in.readCompressedInt();
            this.description = in.readNullUTF();
            this.encryptionFrom = in.readCompressedInt();
            this.encryptionRecipient = in.readCompressedInt();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey);
        out.writeUTF(this.accounting.toString());
        out.writeUTF(this.className);
        out.writeNullUTF(this.param1);
        out.writeNullUTF(this.param2);
        out.writeNullUTF(this.param3);
        out.writeNullUTF(this.param4);
        out.writeBoolean(this.enabled);
        out.writeCompressedInt(this.weight);
        out.writeNullUTF(this.description);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_31) >= 0) {
            out.writeCompressedInt(this.encryptionFrom);
            out.writeCompressedInt(this.encryptionRecipient);
        }
    }

    public List<CreditCard> getCreditCards() throws IOException, SQLException {
        return this.table.getConnector().getPayment().getCreditCard().getCreditCards(this);
    }
}

