/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.pki;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.email.CyrusImapdBind;
import com.aoindustries.aoserv.client.email.CyrusImapdServer;
import com.aoindustries.aoserv.client.email.SendmailServer;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.monitoring.AlertLevel;
import com.aoindustries.aoserv.client.pki.CertificateName;
import com.aoindustries.aoserv.client.pki.CertificateOtherUse;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.VirtualHost;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Certificate
extends CachedObjectIntegerKey<Certificate> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_AO_SERVER = 1;
    static final int COLUMN_PACKAGE = 2;
    static final String COLUMN_AO_SERVER_name = "ao_server";
    static final String COLUMN_CERT_FILE_name = "cert_file";
    private int aoServer;
    private int packageNum;
    private PosixPath keyFile;
    private PosixPath csrFile;
    private PosixPath certFile;
    private PosixPath chainFile;
    private String certbotName;

    @Deprecated
    public Certificate() {
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getCommonName().toStringImpl();
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.aoServer;
            }
            case 2: {
                return this.packageNum;
            }
            case 3: {
                return this.keyFile;
            }
            case 4: {
                return this.csrFile;
            }
            case 5: {
                return this.certFile;
            }
            case 6: {
                return this.chainFile;
            }
            case 7: {
                return this.certbotName;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SSL_CERTIFICATES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.aoServer = result.getInt(pos++);
            this.packageNum = result.getInt(pos++);
            this.keyFile = PosixPath.valueOf(result.getString(pos++));
            this.csrFile = PosixPath.valueOf(result.getString(pos++));
            this.certFile = PosixPath.valueOf(result.getString(pos++));
            this.chainFile = PosixPath.valueOf(result.getString(pos++));
            this.certbotName = result.getString(pos++);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.aoServer = in.readCompressedInt();
            this.packageNum = in.readCompressedInt();
            this.keyFile = PosixPath.valueOf(in.readUTF());
            this.csrFile = PosixPath.valueOf(in.readNullUTF());
            this.certFile = PosixPath.valueOf(in.readUTF());
            this.chainFile = PosixPath.valueOf(in.readNullUTF());
            this.certbotName = in.readNullUTF();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.aoServer);
        out.writeCompressedInt(this.packageNum);
        out.writeUTF(this.keyFile.toString());
        out.writeNullUTF(Objects.toString(this.csrFile, null));
        out.writeUTF(this.certFile.toString());
        out.writeNullUTF(Objects.toString(this.chainFile, null));
        out.writeNullUTF(this.certbotName);
    }

    public Server getLinuxServer() throws SQLException, IOException {
        Server obj = this.table.getConnector().getLinux().getServer().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find linux.Server: " + this.pkey);
        }
        return obj;
    }

    public Package getPackage() throws IOException, SQLException {
        Package obj = this.table.getConnector().getBilling().getPackage().get(this.packageNum);
        if (obj == null) {
            throw new SQLException("Unable to find Package: " + this.packageNum);
        }
        return obj;
    }

    public PosixPath getKeyFile() {
        return this.keyFile;
    }

    public PosixPath getCsrFile() {
        return this.csrFile;
    }

    public PosixPath getCertFile() {
        return this.certFile;
    }

    public PosixPath getChainFile() {
        return this.chainFile;
    }

    public String getCertbotName() {
        return this.certbotName;
    }

    public List<CertificateName> getNames() throws IOException, SQLException {
        return this.table.getConnector().getPki().getCertificateName().getNames(this);
    }

    public CertificateName getCommonName() throws SQLException, IOException {
        return this.table.getConnector().getPki().getCertificateName().getCommonName(this);
    }

    public List<CertificateName> getAltNames() throws IOException, SQLException {
        return this.table.getConnector().getPki().getCertificateName().getAltNames(this);
    }

    public List<CertificateOtherUse> getOtherUses() throws IOException, SQLException {
        return this.table.getConnector().getPki().getCertificateOtherUse().getOtherUses(this);
    }

    public List<CyrusImapdBind> getCyrusImapdBinds() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getCyrusImapdBind().getCyrusImapdBinds(this);
    }

    public List<CyrusImapdServer> getCyrusImapdServers() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getCyrusImapdServer().getCyrusImapdServers(this);
    }

    public List<VirtualHost> getHttpdSiteBinds() throws IOException, SQLException {
        return this.table.getConnector().getWeb().getVirtualHost().getHttpdSiteBinds(this);
    }

    public List<SendmailServer> getSendmailServersByServerCertificate() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getSendmailServer().getSendmailServersByServerCertificate(this);
    }

    public List<SendmailServer> getSendmailServersByClientCertificate() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getSendmailServer().getSendmailServersByClientCertificate(this);
    }

    public List<Check> check(final boolean allowCached) throws IOException, SQLException {
        return this.table.getConnector().requestResult(true, AoservProtocol.CommandId.CHECK_SSL_CERTIFICATE, new AoservConnector.ResultRequest<List<Check>>(){
            private List<Check> result;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Certificate.this.pkey);
                out.writeBoolean(allowCached);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                ArrayList<Check> results;
                byte code = in.readByte();
                if (code == 0) {
                    int size = in.readCompressedInt();
                    results = new ArrayList<Check>(size);
                    for (int c = 0; c < size; ++c) {
                        results.add(new Check(in.readUTF(), in.readUTF(), AlertLevel.valueOf(in.readUTF()), in.readNullUTF()));
                    }
                } else {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.result = results;
            }

            @Override
            public List<Check> afterRelease() {
                return Collections.unmodifiableList(this.result);
            }
        });
    }

    public static class Check
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String check;
        private final String value;
        private final AlertLevel alertLevel;
        private final String message;

        public Check(String check, String value, AlertLevel alertLevel, String message) {
            this.check = check;
            this.value = value;
            this.alertLevel = alertLevel;
            this.message = message;
        }

        public String getCheck() {
            return this.check;
        }

        public String getValue() {
            return this.value;
        }

        public AlertLevel getAlertLevel() {
            return this.alertLevel;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

