/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.pki;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.pki.Certificate;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class CertificateName
extends CachedObjectIntegerKey<CertificateName> {
    public static final String WILDCARD_PREFIX = "*.";
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_SSL_CERTIFICATE = 1;
    static final String COLUMN_SSL_CERTIFICATE_name = "ssl_certificate";
    static final String COLUMN_IS_COMMON_NAME_name = "is_common_name";
    static final String COLUMN_IS_WILDCARD_name = "is_wildcard";
    static final String COLUMN_DOMAIN_name = "domain";
    private int sslCertificate;
    private boolean isCommonName;
    private boolean isWildcard;
    private DomainName domain;

    @Deprecated
    public CertificateName() {
    }

    @Override
    public String toStringImpl() {
        if (this.isCommonName) {
            return this.getName();
        }
        return this.getName() + " (Alt)";
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.sslCertificate;
            }
            case 2: {
                return this.isCommonName;
            }
            case 3: {
                return this.isWildcard;
            }
            case 4: {
                return this.domain;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SSL_CERTIFICATE_NAMES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.sslCertificate = result.getInt(pos++);
            this.isCommonName = result.getBoolean(pos++);
            this.isWildcard = result.getBoolean(pos++);
            this.domain = DomainName.valueOf((String)result.getString(pos++));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.sslCertificate = in.readCompressedInt();
            this.isCommonName = in.readBoolean();
            this.isWildcard = in.readBoolean();
            this.domain = DomainName.valueOf((String)in.readUTF());
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.sslCertificate);
        out.writeBoolean(this.isCommonName);
        out.writeBoolean(this.isWildcard);
        out.writeUTF(this.domain.toString());
    }

    public Certificate getSslCertificate() throws SQLException, IOException {
        Certificate obj = this.table.getConnector().getPki().getCertificate().get(this.sslCertificate);
        if (obj == null) {
            throw new SQLException("Unable to find SslCertificate: " + this.sslCertificate);
        }
        return obj;
    }

    public boolean isCommon() {
        return this.isCommonName;
    }

    public boolean isWildcard() {
        return this.isWildcard;
    }

    public DomainName getDomain() {
        return this.domain;
    }

    public String getName() {
        if (this.isWildcard) {
            return WILDCARD_PREFIX + this.domain;
        }
        return this.domain.toString();
    }
}

