/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.pki;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.pki.Certificate;
import com.aoindustries.aoserv.client.pki.CertificateName;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class CertificateNameTable
extends CachedTableIntegerKey<CertificateName> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("ssl_certificate.ao_server.hostname", true), new AoservTable.OrderBy("ssl_certificate.cert_file", true), new AoservTable.OrderBy("is_common_name", false), new AoservTable.OrderBy("domain", true), new AoservTable.OrderBy("is_wildcard", false)};

    CertificateNameTable(AoservConnector connector) {
        super(connector, CertificateName.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public CertificateName get(int pkey) throws IOException, SQLException {
        return (CertificateName)this.getUniqueRow(0, pkey);
    }

    List<CertificateName> getNames(Certificate sslCert) throws IOException, SQLException {
        return this.getIndexedRows(1, sslCert.getPkey());
    }

    CertificateName getCommonName(Certificate sslCert) throws SQLException, IOException {
        for (CertificateName name : this.getNames(sslCert)) {
            if (!name.isCommon()) continue;
            return name;
        }
        throw new SQLException("Unable to find Common Name (CN) for SslCertificate with pkey = " + sslCert.getPkey());
    }

    List<CertificateName> getAltNames(Certificate sslCert) throws IOException, SQLException {
        List<CertificateName> cached = this.getNames(sslCert);
        int size = cached.size();
        ArrayList<CertificateName> matches = new ArrayList<CertificateName>(size - 1);
        for (int c = 0; c < size; ++c) {
            CertificateName name = cached.get(c);
            if (name.isCommon()) continue;
            matches.add(name);
        }
        return matches;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SSL_CERTIFICATE_NAMES;
    }
}

