/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.pki;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.pki.Certificate;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class CertificateOtherUse
extends CachedObjectIntegerKey<CertificateOtherUse> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_SSL_CERTIFICATE = 1;
    static final String COLUMN_SSL_CERTIFICATE_name = "ssl_certificate";
    static final String COLUMN_SORT_ORDER_name = "sort_order";
    private int sslCertificate;
    private short sortOrder;
    private int count;
    private String display;

    @Deprecated
    public CertificateOtherUse() {
    }

    @Override
    public String toStringImpl() {
        return this.count + " " + this.display;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.sslCertificate;
            }
            case 2: {
                return this.sortOrder;
            }
            case 3: {
                return this.count;
            }
            case 4: {
                return this.display;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SSL_CERTIFICATE_OTHER_USES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getInt(pos++);
        this.sslCertificate = result.getInt(pos++);
        this.sortOrder = result.getShort(pos++);
        this.count = result.getInt(pos++);
        this.display = result.getString(pos++);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.sslCertificate = in.readCompressedInt();
        this.sortOrder = in.readShort();
        this.count = in.readCompressedInt();
        this.display = in.readUTF();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.sslCertificate);
        out.writeShort((int)this.sortOrder);
        out.writeCompressedInt(this.count);
        out.writeUTF(this.display);
    }

    public Certificate getSslCertificate() throws SQLException, IOException {
        Certificate obj = this.table.getConnector().getPki().getCertificate().get(this.sslCertificate);
        if (obj == null) {
            throw new SQLException("Unable to find SslCertificate: " + this.sslCertificate);
        }
        return obj;
    }

    public short getSortOrder() {
        return this.sortOrder;
    }

    public int getCount() {
        return this.count;
    }

    public String getDisplay() {
        return this.display;
    }
}

