/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.pki;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.sql.SQLUtility;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.pki.Certificate;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class CertificateTable
extends CachedTableIntegerKey<Certificate> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("ao_server.hostname", true), new AoservTable.OrderBy("cert_file", true)};

    CertificateTable(AoservConnector connector) {
        super(connector, Certificate.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public Certificate get(int pkey) throws IOException, SQLException {
        return (Certificate)this.getUniqueRow(0, pkey);
    }

    public List<Certificate> getSslCertificates(Server aoServer) throws IOException, SQLException {
        return this.getIndexedRows(1, aoServer.getPkey());
    }

    public List<Certificate> getSslCertificates(Package pk) throws IOException, SQLException {
        return this.getIndexedRows(2, pk.getPkey());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SSL_CERTIFICATES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("pki.Certificate.check")) {
            if (Aosh.checkParamCount("pki.Certificate.check", args, 3, (PrintWriter)err)) {
                List<Certificate.Check> results = this.connector.getSimpleClient().checkSslCertificate(args[1], args[2], Aosh.parseBoolean(args[3], "allowCached"));
                int size = results.size();
                ArrayList<Object[]> rows = new ArrayList<Object[]>(size);
                for (int i = 0; i < size; ++i) {
                    Certificate.Check status = results.get(i);
                    rows.add(new Object[]{status.getCheck(), status.getValue(), status.getAlertLevel(), status.getMessage()});
                }
                SQLUtility.printTable((Object[])new String[]{"check", "value", "alert_level", "message"}, rows, (Appendable)out, (boolean)isInteractive, (boolean[])new boolean[]{false, false, false, false});
                out.flush();
            }
            return true;
        }
        return false;
    }
}

