/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.pki;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class EncryptionKey
extends CachedObjectIntegerKey<EncryptionKey> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_ACCOUNTING = 1;
    static final String COLUMN_ACCOUNTING_name = "accounting";
    static final String COLUMN_ID_name = "id";
    private Account.Name accounting;
    private String id;

    public static String encrypt(String signer, String recipient, String plaintext) throws IOException {
        String[] command = new String[]{"/usr/bin/gpg", "--batch", "--sign", "--encrypt", "--armor", "--default-key", '=' + signer, "--recipient", '=' + recipient};
        Process p = Runtime.getRuntime().exec(command);
        try {
            String string;
            try (OutputStreamWriter out = new OutputStreamWriter(p.getOutputStream());){
                out.write(plaintext);
                ((Writer)out).flush();
            }
            try (InputStreamReader in = new InputStreamReader(p.getInputStream());){
                int count;
                StringBuilder sb = new StringBuilder();
                char[] buff = new char[4096];
                while ((count = ((Reader)in).read(buff, 0, 4096)) != -1) {
                    sb.append(buff, 0, count);
                }
                string = sb.toString();
            }
            return string;
        }
        finally {
            CharArrayWriter cout = new CharArrayWriter();
            try (InputStreamReader errIn = new InputStreamReader(p.getErrorStream());){
                int ret;
                char[] buff = new char[4096];
                while ((ret = ((Reader)errIn).read(buff, 0, 4096)) != -1) {
                    cout.write(buff, 0, ret);
                }
            }
            try {
                int retCode = p.waitFor();
                if (retCode != 0) {
                    throw new IOException("Non-zero exit value from gpg: " + retCode + ", standard error was: " + cout.toString());
                }
            }
            catch (InterruptedException err) {
                InterruptedIOException ioErr = new InterruptedIOException("Interrupted while waiting for gpg");
                ioErr.initCause(err);
                Thread.currentThread().interrupt();
                throw ioErr;
            }
        }
    }

    public static String decrypt(String recipient, String ciphertext, String passphrase) throws IOException {
        String[] command = new String[]{"/usr/bin/gpg", "--batch", "--decrypt", "--armor", "--passphrase-fd", "0"};
        Process p = Runtime.getRuntime().exec(command);
        try {
            String string;
            try (OutputStreamWriter out = new OutputStreamWriter(p.getOutputStream());){
                out.write(passphrase);
                out.write(ciphertext);
                ((Writer)out).flush();
            }
            try (InputStreamReader in = new InputStreamReader(p.getInputStream());){
                int count;
                StringBuilder sb = new StringBuilder();
                char[] buff = new char[4096];
                while ((count = ((Reader)in).read(buff, 0, 4096)) != -1) {
                    sb.append(buff, 0, count);
                }
                string = sb.toString();
            }
            return string;
        }
        finally {
            try {
                int retCode = p.waitFor();
                if (retCode != 0) {
                    throw new IOException("Non-zero exit value from gpg: " + retCode);
                }
            }
            catch (InterruptedException err) {
                InterruptedIOException ioErr = new InterruptedIOException("Interrupted while waiting for gpg");
                ioErr.initCause(err);
                Thread.currentThread().interrupt();
                throw ioErr;
            }
        }
    }

    @Deprecated
    public EncryptionKey() {
    }

    public Account.Name getAccount_name() {
        return this.accounting;
    }

    public Account getAccount() throws SQLException, IOException {
        Account obj = this.table.getConnector().getAccount().getAccount().get(this.accounting);
        if (obj == null) {
            throw new SQLException("Unable to find Account: " + this.accounting);
        }
        return obj;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.accounting;
            }
            case 2: {
                return this.id;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.ENCRYPTION_KEYS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.accounting = Account.Name.valueOf(result.getString(2));
            this.id = result.getString(3);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.accounting = Account.Name.valueOf(in.readUTF()).intern();
            this.id = in.readUTF();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.accounting.toString());
        out.writeUTF(this.id);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_43) <= 0) {
            out.writeBoolean(false);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_25) >= 0 && protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_43) <= 0) {
            out.writeBoolean(false);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeBoolean(false);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_25) >= 0 && protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeBoolean(false);
        }
    }

    public String encrypt(EncryptionKey recipient, String plaintext) throws IOException {
        return EncryptionKey.encrypt(this.id, recipient.getId(), plaintext);
    }

    public String decrypt(String ciphertext, String passphrase) throws IOException {
        return EncryptionKey.decrypt(this.id, ciphertext, passphrase);
    }
}

