/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.postgresql;

import com.aoapps.hodgepodge.io.ByteCountInputStream;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.Strings;
import com.aoapps.lang.dto.DtoFactory;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.io.IoUtils;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.InvalidResult;
import com.aoapps.lang.validation.ValidResult;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import com.aoapps.net.InetAddress;
import com.aoapps.net.Port;
import com.aoapps.net.URIEncoder;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Dumpable;
import com.aoindustries.aoserv.client.JdbcProvider;
import com.aoindustries.aoserv.client.NestedInputStream;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.StreamHandler;
import com.aoindustries.aoserv.client.dto.PostgresDatabaseName;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.net.IpAddress;
import com.aoindustries.aoserv.client.postgresql.Encoding;
import com.aoindustries.aoserv.client.postgresql.Server;
import com.aoindustries.aoserv.client.postgresql.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Database
extends CachedObjectIntegerKey<Database>
implements Dumpable,
Removable,
JdbcProvider {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, Database.class);
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_POSTGRES_SERVER = 2;
    static final int COLUMN_DATDBA = 3;
    static final String COLUMN_NAME_name = "name";
    static final String COLUMN_POSTGRES_SERVER_name = "postgres_server";
    public static final String JDBC_DRIVER = "org.postgresql.Driver";
    public static final Name TEMPLATE0;
    public static final Name TEMPLATE1;
    public static final Name POSTGRESMON;
    public static final Name AOINDUSTRIES;
    public static final Name AOSERV;
    public static final Name AOSERV_MASTER;
    public static final Name AOWEB;
    private Name name;
    private int postgresServer;
    private int datdba;
    private int encoding;
    private boolean isTemplate;
    private boolean allowConn;
    private boolean enablePostgis;
    public static final Charset DUMP_ENCODING;

    public static boolean isSpecial(Name name) {
        return name.equals(TEMPLATE0) || name.equals(TEMPLATE1) || name.equals(POSTGRESMON) || name.equals(AOINDUSTRIES) || name.equals(AOSERV) || name.equals(AOSERV_MASTER) || name.equals(AOWEB);
    }

    @Deprecated
    public Database() {
    }

    public boolean allowsConnections() {
        return this.allowConn;
    }

    @Override
    public void dump(PrintWriter out) throws IOException, SQLException {
        this.dump((Writer)out);
    }

    public void dump(final Writer out) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.DUMP_POSTGRES_DATABASE, new AoservConnector.UpdateRequest(){

            @Override
            public void writeRequest(StreamableOutput masterOut) throws IOException {
                masterOut.writeCompressedInt(Database.this.pkey);
                masterOut.writeBoolean(false);
            }

            @Override
            public void readResponse(StreamableInput masterIn) throws IOException, SQLException {
                long bytesRead;
                long dumpSize = masterIn.readLong();
                if (dumpSize < 0L) {
                    throw new IOException("dumpSize < 0: " + dumpSize);
                }
                try (ByteCountInputStream byteCountIn = new ByteCountInputStream((InputStream)new NestedInputStream(masterIn));
                     InputStreamReader nestedIn = new InputStreamReader((InputStream)byteCountIn, DUMP_ENCODING);){
                    IoUtils.copy((Reader)nestedIn, (Writer)out);
                    bytesRead = byteCountIn.getCount();
                }
                if (bytesRead < dumpSize) {
                    throw new IOException("Too few bytes read: " + bytesRead + " < " + dumpSize);
                }
                if (bytesRead > dumpSize) {
                    throw new IOException("Too many bytes read: " + bytesRead + " > " + dumpSize);
                }
            }

            @Override
            public void afterRelease() {
            }
        });
    }

    public void dump(final boolean gzip, final StreamHandler streamHandler) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.DUMP_POSTGRES_DATABASE, new AoservConnector.UpdateRequest(){

            @Override
            public void writeRequest(StreamableOutput masterOut) throws IOException {
                masterOut.writeCompressedInt(Database.this.pkey);
                masterOut.writeBoolean(gzip);
            }

            @Override
            public void readResponse(StreamableInput masterIn) throws IOException, SQLException {
                long bytesRead;
                long dumpSize = masterIn.readLong();
                if (dumpSize < -1L) {
                    throw new IOException("dumpSize < -1: " + dumpSize);
                }
                streamHandler.onDumpSize(dumpSize);
                try (NestedInputStream nestedIn = new NestedInputStream(masterIn);){
                    bytesRead = IoUtils.copy((InputStream)nestedIn, (OutputStream)streamHandler.getOut());
                }
                if (dumpSize != -1L) {
                    if (bytesRead < dumpSize) {
                        throw new IOException("Too few bytes read: " + bytesRead + " < " + dumpSize);
                    }
                    if (bytesRead > dumpSize) {
                        throw new IOException("Too many bytes read: " + bytesRead + " > " + dumpSize);
                    }
                }
            }

            @Override
            public void afterRelease() {
            }
        });
    }

    public boolean getEnablePostgis() {
        return this.enablePostgis;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.postgresServer;
            }
            case 3: {
                return this.datdba;
            }
            case 4: {
                return this.encoding;
            }
            case 5: {
                return this.isTemplate;
            }
            case 6: {
                return this.allowConn;
            }
            case 7: {
                return this.enablePostgis;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getDatdba_id() {
        return this.datdba;
    }

    public UserServer getDatdba() throws SQLException, IOException {
        UserServer obj = this.table.getConnector().getPostgresql().getUserServer().get(this.datdba);
        if (obj == null) {
            throw new SQLException("Unable to find PostgresServerUser: " + this.datdba);
        }
        return obj;
    }

    @Override
    public String getJdbcDriver() {
        return JDBC_DRIVER;
    }

    @Override
    public String getJdbcUrl(boolean ipOnly) throws SQLException, IOException {
        Server ps = this.getPostgresServer();
        com.aoindustries.aoserv.client.linux.Server ao = ps.getLinuxServer();
        StringBuilder jdbcUrl = new StringBuilder();
        jdbcUrl.append("jdbc:postgresql://");
        Bind nb = ps.getBind();
        IpAddress ip = nb.getIpAddress();
        InetAddress ia = ip.getInetAddress();
        if (ipOnly) {
            if (ia.isUnspecified()) {
                jdbcUrl.append(ao.getHost().getNetDevice(ao.getDaemonDeviceId().getName()).getPrimaryIpAddress().getInetAddress().toBracketedString());
            } else {
                jdbcUrl.append(ia.toBracketedString());
            }
        } else if (ia.isUnspecified()) {
            jdbcUrl.append(ao.getHostname());
        } else if (ia.isLoopback()) {
            jdbcUrl.append(ia.toBracketedString());
        } else {
            jdbcUrl.append(ip.getHostname());
        }
        Port port = nb.getPort();
        if (!port.equals((Object)Server.DEFAULT_PORT)) {
            jdbcUrl.append(':').append(port.getPort());
        }
        jdbcUrl.append('/');
        URIEncoder.encodeURIComponent((String)this.getName().toString(), (StringBuilder)jdbcUrl);
        return jdbcUrl.toString();
    }

    @Override
    public String getJdbcDocumentationUrl() throws SQLException, IOException {
        String list = "https://jdbc.postgresql.org/documentation/documentation.html";
        String head = "https://jdbc.postgresql.org/documentation/head/index.html";
        String version = this.getPostgresServer().getVersion().getTechnologyVersion(this.table.getConnector()).getVersion();
        List split = Strings.split((String)version, (char)'.');
        if (split.size() < 2) {
            return "https://jdbc.postgresql.org/documentation/documentation.html";
        }
        String major = (String)split.get(0);
        String minor = (String)split.get(1);
        if ("7".equals(major)) {
            return "https://www.postgresql.org/docs/" + URIEncoder.encodeURIComponent((String)major) + "." + URIEncoder.encodeURIComponent((String)minor) + "/jdbc.html";
        }
        if ("8".equals(major) || "9".equals(major) && ("0".equals(minor) || "1".equals(minor) || "2".equals(minor) || "3".equals(minor) || "4".equals(minor))) {
            return "https://jdbc.postgresql.org/documentation/" + URIEncoder.encodeURIComponent((String)major) + URIEncoder.encodeURIComponent((String)minor) + "/index.html";
        }
        return "https://jdbc.postgresql.org/documentation/head/index.html";
    }

    public Name getName() {
        return this.name;
    }

    public boolean isSpecial() {
        return Database.isSpecial(this.name);
    }

    public Encoding getPostgresEncoding() throws SQLException, IOException {
        Encoding obj = this.table.getConnector().getPostgresql().getEncoding().get(this.encoding);
        if (obj == null) {
            throw new SQLException("Unable to find PostgresEncoding: " + this.encoding);
        }
        if (obj.getPostgresVersion(this.table.getConnector()).getPkey() != this.getPostgresServer().getVersion().getPkey()) {
            throw new SQLException("encoding/postgres server version mismatch on PostgresDatabase: #" + this.pkey);
        }
        return obj;
    }

    public int getPostgresServer_bind_id() {
        return this.postgresServer;
    }

    public Server getPostgresServer() throws SQLException, IOException {
        Server obj = this.table.getConnector().getPostgresql().getServer().get(this.postgresServer);
        if (obj == null) {
            throw new SQLException("Unable to find PostgresServer: " + this.postgresServer);
        }
        return obj;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.POSTGRES_DATABASES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.name = Name.valueOf(result.getString(2));
            this.postgresServer = result.getInt(3);
            this.datdba = result.getInt(4);
            this.encoding = result.getInt(5);
            this.isTemplate = result.getBoolean(6);
            this.allowConn = result.getBoolean(7);
            this.enablePostgis = result.getBoolean(8);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.name = Name.valueOf(in.readUTF());
            this.postgresServer = in.readCompressedInt();
            this.datdba = in.readCompressedInt();
            this.encoding = in.readCompressedInt();
            this.isTemplate = in.readBoolean();
            this.allowConn = in.readBoolean();
            this.enablePostgis = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<Database>> getCannotRemoveReasons() throws SQLException, IOException {
        ArrayList<CannotRemoveReason<Database>> reasons = new ArrayList<CannotRemoveReason<Database>>();
        Server ps = this.getPostgresServer();
        if (!this.allowConn) {
            reasons.add(new CannotRemoveReason<Database>("Not allowed to drop a PostgreSQL database that does not allow connections: " + this.name + " on " + ps.getName() + " on " + ps.getLinuxServer().getHostname(), this));
        }
        if (this.isTemplate) {
            reasons.add(new CannotRemoveReason<Database>("Not allowed to drop a template PostgreSQL database: " + this.name + " on " + ps.getName() + " on " + ps.getLinuxServer().getHostname(), this));
        }
        if (this.isSpecial()) {
            reasons.add(new CannotRemoveReason<Database>("Not allowed to drop a special PostgreSQL database: " + this.name + " on " + ps.getName() + " on " + ps.getLinuxServer().getHostname(), this));
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to remove special PostgreSQL database: " + this);
        }
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.POSTGRES_DATABASES, this.pkey});
    }

    @Override
    public String toStringImpl() {
        return this.name.toString();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.name.toString());
        out.writeCompressedInt(this.postgresServer);
        out.writeCompressedInt(this.datdba);
        out.writeCompressedInt(this.encoding);
        out.writeBoolean(this.isTemplate);
        out.writeBoolean(this.allowConn);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeShort(0);
            out.writeShort(7);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_27) >= 0) {
            out.writeBoolean(this.enablePostgis);
        }
    }

    static {
        try {
            TEMPLATE0 = Name.valueOf("template0");
            TEMPLATE1 = Name.valueOf("template1");
            POSTGRESMON = Name.valueOf("postgresmon");
            AOINDUSTRIES = Name.valueOf("aoindustries");
            AOSERV = Name.valueOf("aoserv");
            AOSERV_MASTER = Name.valueOf("aoserv-master");
            AOWEB = Name.valueOf("aoweb");
        }
        catch (ValidationException e) {
            throw new AssertionError("These hard-coded values are valid", e);
        }
        DUMP_ENCODING = StandardCharsets.ISO_8859_1;
    }

    public static final class Name
    implements Comparable<Name>,
    Serializable,
    DtoFactory<PostgresDatabaseName>,
    Internable<Name> {
        private static final long serialVersionUID = 5843440870677129701L;
        public static final int MAX_LENGTH = 31;
        private static final ConcurrentMap<String, Name> interned = new ConcurrentHashMap<String, Name>();
        private final String name;

        public static ValidationResult validate(String name) {
            if (name == null) {
                return new InvalidResult(RESOURCES, "Name.validate.isNull");
            }
            int len = name.length();
            if (len == 0) {
                return new InvalidResult(RESOURCES, "Name.validate.isEmpty");
            }
            if (len > 31) {
                return new InvalidResult(RESOURCES, "Name.validate.tooLong", new Serializable[]{Integer.valueOf(31), Integer.valueOf(len)});
            }
            for (int c = 0; c < len; ++c) {
                char ch = name.charAt(c);
                if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '-' || ch == '.' || ch == ' ') continue;
                return new InvalidResult(RESOURCES, "Name.validate.illegalCharacter");
            }
            return ValidResult.getInstance();
        }

        public static Name valueOf(String name) throws ValidationException {
            if (name == null) {
                return null;
            }
            return new Name(name, true);
        }

        private Name(String name, boolean validate) throws ValidationException {
            this.name = name;
            if (validate) {
                this.validate();
            }
        }

        private Name(String name) {
            ValidationResult result;
            assert ((result = Name.validate(name)).isValid()) : result.toString();
            this.name = name;
        }

        private void validate() throws ValidationException {
            ValidationResult result = Name.validate(this.name);
            if (!result.isValid()) {
                throw new ValidationException(result);
            }
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            try {
                this.validate();
            }
            catch (ValidationException err) {
                InvalidObjectException newErr = new InvalidObjectException(err.getMessage());
                newErr.initCause(err);
                throw newErr;
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof Name && this.name.equals(((Name)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(Name other) {
            return this == other ? 0 : this.name.compareTo(other.name);
        }

        public String toString() {
            return this.name;
        }

        public Name intern() {
            Name addMe;
            String internedName;
            Name existing = (Name)interned.get(this.name);
            if (existing == null && (existing = interned.putIfAbsent(internedName, addMe = this.name == (internedName = this.name.intern()) ? this : new Name(internedName))) == null) {
                existing = addMe;
            }
            return existing;
        }

        public PostgresDatabaseName getDto() {
            return new PostgresDatabaseName(this.name);
        }
    }
}

