/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.postgresql;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.StreamHandler;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.postgresql.Database;
import com.aoindustries.aoserv.client.postgresql.Encoding;
import com.aoindustries.aoserv.client.postgresql.Server;
import com.aoindustries.aoserv.client.postgresql.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class DatabaseTable
extends CachedTableIntegerKey<Database> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("name", true), new AoservTable.OrderBy("postgres_server.name", true), new AoservTable.OrderBy("postgres_server.ao_server.hostname", true)};

    DatabaseTable(AoservConnector connector) {
        super(connector, Database.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addPostgresDatabase(Database.Name name, Server postgresServer, UserServer datdba, Encoding encoding, boolean enablePostgis) throws IOException, SQLException {
        if (Database.isSpecial(name)) {
            throw new SQLException("Refusing to add special PostgreSQL database: " + name + " on " + postgresServer);
        }
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.POSTGRES_DATABASES, name, postgresServer.getBind_id(), datdba.getPkey(), encoding.getPkey(), enablePostgis});
    }

    public Database.Name generatePostgresDatabaseName(String templateBase, String templateAdded) throws IOException, SQLException {
        try {
            return Database.Name.valueOf(this.connector.requestStringQuery(true, AoservProtocol.CommandId.GENERATE_POSTGRES_DATABASE_NAME, templateBase, templateAdded));
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Database get(int pkey) throws IOException, SQLException {
        return (Database)this.getUniqueRow(0, pkey);
    }

    Database getPostgresDatabase(Database.Name name, Server postgresServer) throws IOException, SQLException {
        for (Database pd : this.getPostgresDatabases(postgresServer)) {
            if (!pd.getName().equals(name)) continue;
            return pd;
        }
        return null;
    }

    public List<Database> getPostgresDatabases(Package pack) throws IOException, SQLException {
        Account.Name name = pack.getName();
        List cached = this.getRows();
        int size = cached.size();
        ArrayList<Database> matches = new ArrayList<Database>(size);
        for (int c = 0; c < size; ++c) {
            Database pd = (Database)cached.get(c);
            if (!pd.getDatdba().getPostgresUser().getUsername().getPackage_name().equals(name)) continue;
            matches.add(pd);
        }
        return matches;
    }

    List<Database> getPostgresDatabases(UserServer psu) throws IOException, SQLException {
        return this.getIndexedRows(3, psu.getPkey());
    }

    List<Database> getPostgresDatabases(Server postgresServer) throws IOException, SQLException {
        return this.getIndexedRows(2, postgresServer.getBind_id());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.POSTGRES_DATABASES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, SQLException, IOException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_postgres_database")) {
            if (Aosh.checkParamCount("add_postgres_database", args, 6, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addPostgresDatabase(Aosh.parsePostgresDatabaseName(args[1], "database_name"), Aosh.parsePostgresServerName(args[2], "postgres_server"), args[3], Aosh.parsePostgresUserName(args[4], "datdba"), args[5], Aosh.parseBoolean(args[6], "enable_postgis")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("check_postgres_database_name")) {
            if (Aosh.checkParamCount("check_postgres_database_name", args, 1, (PrintWriter)err)) {
                ValidationResult validationResult = Database.Name.validate(args[1]);
                out.println(validationResult.isValid());
                out.flush();
                if (!validationResult.isValid()) {
                    err.print("aosh: check_postgres_database_name: ");
                    err.println(validationResult.toString());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("dump_postgres_database")) {
            if (Aosh.checkParamCount("dump_postgres_database", args, 4, (PrintWriter)err)) {
                try {
                    Database.Name dbName = Aosh.parsePostgresDatabaseName(args[1], "database_name");
                    Server.Name serverName = Aosh.parsePostgresServerName(args[2], "postgres_server");
                    String aoServer = args[3];
                    if (Aosh.parseBoolean(args[4], "gzip")) {
                        this.connector.getSimpleClient().dumpPostgresDatabase(dbName, serverName, aoServer, true, new StreamHandler(){

                            @Override
                            public void onDumpSize(long dumpSize) {
                            }

                            @Override
                            public OutputStream getOut() {
                                return System.out;
                            }
                        });
                        System.out.flush();
                    } else {
                        this.connector.getSimpleClient().dumpPostgresDatabase(dbName, serverName, aoServer, (Writer)out);
                        out.flush();
                    }
                }
                catch (IllegalArgumentException iae) {
                    err.print("aosh: dump_postgres_database: ");
                    err.println(iae.getMessage());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("generate_postgres_database_name")) {
            if (Aosh.checkParamCount("generate_postgres_database_name", args, 2, (PrintWriter)err)) {
                out.println((Object)this.connector.getSimpleClient().generatePostgresDatabaseName(args[1], args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("is_postgres_database_name_available")) {
            if (Aosh.checkParamCount("is_postgres_database_name_available", args, 3, (PrintWriter)err)) {
                try {
                    out.println(this.connector.getSimpleClient().isPostgresDatabaseNameAvailable(Aosh.parsePostgresDatabaseName(args[1], "database_name"), Aosh.parsePostgresServerName(args[2], "postgres_server"), args[3]));
                    out.flush();
                }
                catch (IllegalArgumentException iae) {
                    err.print("aosh: is_postgres_database_name_available: ");
                    err.println(iae.getMessage());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_postgres_database")) {
            if (Aosh.checkParamCount("remove_postgres_database", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().removePostgresDatabase(Aosh.parsePostgresDatabaseName(args[1], "database_name"), Aosh.parsePostgresServerName(args[2], "postgres_server"), args[3]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("wait_for_postgres_database_rebuild")) {
            if (Aosh.checkParamCount("wait_for_postgres_database_rebuild", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().waitForPostgresDatabaseRebuild(args[1]);
            }
            return true;
        }
        return false;
    }

    boolean isPostgresDatabaseNameAvailable(Database.Name name, Server postgresServer) throws IOException, SQLException {
        return this.connector.requestBooleanQuery(true, AoservProtocol.CommandId.IS_POSTGRES_DATABASE_NAME_AVAILABLE, name, postgresServer.getBind_id());
    }

    public void waitForRebuild(com.aoindustries.aoserv.client.linux.Server aoServer) throws IOException, SQLException {
        this.connector.requestUpdate(true, AoservProtocol.CommandId.WAIT_FOR_REBUILD, new Object[]{Table.TableId.POSTGRES_DATABASES, aoServer.getPkey()});
    }
}

