/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.postgresql;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.GlobalObjectIntegerKey;
import com.aoindustries.aoserv.client.postgresql.Version;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class Encoding
extends GlobalObjectIntegerKey<Encoding> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_POSTGRES_VERSION = 2;
    static final String COLUMN_ENCODING_name = "encoding";
    static final String COLUMN_POSTGRES_VERSION_name = "postgres_version";
    static final String COLUMN_PKEY_name = "pkey";
    public static final String ALT = "ALT";
    public static final String BIG5 = "BIG5";
    public static final String EUC_CN = "EUC_CN";
    public static final String EUC_JIS_2004 = "EUC_JIS_2004";
    public static final String EUC_JP = "EUC_JP";
    public static final String EUC_KR = "EUC_KR";
    public static final String EUC_TW = "EUC_TW";
    public static final String GB18030 = "GB18030";
    public static final String GBK = "GBK";
    public static final String ISO_8859_5 = "ISO_8859_5";
    public static final String ISO_8859_6 = "ISO_8859_6";
    public static final String ISO_8859_7 = "ISO_8859_7";
    public static final String ISO_8859_8 = "ISO_8859_8";
    public static final String JOHAB = "JOHAB";
    public static final String KOI8 = "KOI8";
    public static final String KOI8R = "KOI8R";
    public static final String KOI8U = "KOI8U";
    public static final String LATIN1 = "LATIN1";
    public static final String LATIN2 = "LATIN2";
    public static final String LATIN3 = "LATIN3";
    public static final String LATIN4 = "LATIN4";
    public static final String LATIN5 = "LATIN5";
    public static final String LATIN6 = "LATIN6";
    public static final String LATIN7 = "LATIN7";
    public static final String LATIN8 = "LATIN8";
    public static final String LATIN9 = "LATIN9";
    public static final String LATIN10 = "LATIN10";
    public static final String MULE_INTERNAL = "MULE_INTERNAL";
    public static final String SJIS = "SJIS";
    public static final String SQL_ASCII = "SQL_ASCII";
    public static final String UTF8 = "UTF8";
    public static final String TCVN = "TCVN";
    public static final String UHC = "UHC";
    public static final String UNICODE = "UNICODE";
    public static final String WIN = "WIN";
    public static final String WIN866 = "WIN866";
    public static final String WIN874 = "WIN874";
    public static final String WIN1250 = "WIN1250";
    public static final String WIN1251 = "WIN1251";
    public static final String WIN1252 = "WIN1252";
    public static final String WIN1253 = "WIN1253";
    public static final String WIN1254 = "WIN1254";
    public static final String WIN1255 = "WIN1255";
    public static final String WIN1256 = "WIN1256";
    public static final String WIN1257 = "WIN1257";
    public static final String WIN1258 = "WIN1258";
    private String encoding;
    private int postgresVersion;

    public static String getDefaultEncoding(String version) {
        if (version.startsWith("7.") || version.startsWith("8.")) {
            return SQL_ASCII;
        }
        return UTF8;
    }

    @Deprecated
    public Encoding() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.encoding;
            }
            case 2: {
                return this.postgresVersion;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Version getPostgresVersion(AoservConnector connector) throws SQLException, IOException {
        Version pv = connector.getPostgresql().getVersion().get(this.postgresVersion);
        if (pv == null) {
            throw new SQLException("Unable to find PostgresVersion: " + this.postgresVersion);
        }
        return pv;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.POSTGRES_ENCODINGS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.encoding = result.getString(2);
        this.postgresVersion = result.getInt(3);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.encoding = in.readUTF().intern();
        this.postgresVersion = in.readCompressedInt();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.encoding);
        out.writeCompressedInt(this.postgresVersion);
    }
}

