/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.postgresql;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.GlobalTableIntegerKey;
import com.aoindustries.aoserv.client.postgresql.Encoding;
import com.aoindustries.aoserv.client.postgresql.Version;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public final class EncodingTable
extends GlobalTableIntegerKey<Encoding> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("encoding", true), new AoservTable.OrderBy("postgres_version.minor_version", true), new AoservTable.OrderBy("pkey", true)};

    EncodingTable(AoservConnector connector) {
        super(connector, Encoding.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public Encoding get(int pkey) throws IOException, SQLException {
        return (Encoding)this.getUniqueRow(0, pkey);
    }

    List<Encoding> getPostgresEncodings(Version version) throws IOException, SQLException {
        return this.getIndexedRows(2, version.getPkey());
    }

    Encoding getPostgresEncoding(Version pv, String encoding) throws IOException, SQLException {
        List<Encoding> cached = this.getPostgresEncodings(pv);
        int cachedLen = cached.size();
        for (int c = 0; c < cachedLen; ++c) {
            Encoding pe = cached.get(c);
            if (!pe.getEncoding().equals(encoding)) continue;
            return pe;
        }
        return null;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.POSTGRES_ENCODINGS;
    }
}

