/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.postgresql;

import com.aoapps.collections.AoCollections;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.dto.DtoFactory;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.InvalidResult;
import com.aoapps.lang.validation.ValidResult;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import com.aoapps.net.Port;
import com.aoapps.net.Protocol;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.dto.PostgresServerName;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.postgresql.Database;
import com.aoindustries.aoserv.client.postgresql.Encoding;
import com.aoindustries.aoserv.client.postgresql.User;
import com.aoindustries.aoserv.client.postgresql.UserServer;
import com.aoindustries.aoserv.client.postgresql.Version;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Server
extends CachedObjectIntegerKey<Server> {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, Server.class);
    public static final Port DEFAULT_PORT;
    public static final PosixPath DATA_BASE_DIR;
    static final int COLUMN_BIND = 0;
    static final int COLUMN_AO_SERVER = 2;
    static final String COLUMN_NAME_name = "name";
    static final String COLUMN_AO_SERVER_name = "ao_server";
    private Name name;
    private int aoServer;
    private int version;
    private int maxConnections;
    private int sortMem;
    private int sharedBuffers;
    private boolean fsync;

    @Deprecated
    public Server() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.aoServer;
            }
            case 3: {
                return this.version;
            }
            case 4: {
                return this.maxConnections;
            }
            case 5: {
                return this.sortMem;
            }
            case 6: {
                return this.sharedBuffers;
            }
            case 7: {
                return this.fsync;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getBind_id() {
        return this.pkey;
    }

    public Bind getBind() throws SQLException, IOException {
        Bind nb = this.table.getConnector().getNet().getBind().get(this.pkey);
        if (nb == null) {
            throw new SQLException("Unable to find NetBind: " + this.pkey);
        }
        return nb;
    }

    public int getAoServer_server_pkey() {
        return this.aoServer;
    }

    public com.aoindustries.aoserv.client.linux.Server getLinuxServer() throws SQLException, IOException {
        com.aoindustries.aoserv.client.linux.Server ao = this.table.getConnector().getLinux().getServer().get(this.aoServer);
        if (ao == null) {
            throw new SQLException("Unable to find linux.Server: " + this.aoServer);
        }
        return ao;
    }

    public int getVersion_version_id() {
        return this.version;
    }

    public Version getVersion() throws SQLException, IOException {
        Version obj = this.table.getConnector().getPostgresql().getVersion().get(this.version);
        if (obj == null) {
            throw new SQLException("Unable to find PostgresVersion: " + this.version);
        }
        if (obj.getTechnologyVersion(this.table.getConnector()).getOperatingSystemVersion(this.table.getConnector()).getPkey() != this.getLinuxServer().getHost().getOperatingSystemVersion_id()) {
            throw new SQLException("resource/operating system version mismatch on PostgresServer: #" + this.pkey);
        }
        return obj;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getSortMem() {
        return this.sortMem;
    }

    public int getSharedBuffers() {
        return this.sharedBuffers;
    }

    public boolean getFsync() {
        return this.fsync;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.name = Name.valueOf(result.getString(pos++));
            this.aoServer = result.getInt(pos++);
            this.version = result.getInt(pos++);
            this.maxConnections = result.getInt(pos++);
            this.sortMem = result.getInt(pos++);
            this.sharedBuffers = result.getInt(pos++);
            this.fsync = result.getBoolean(pos++);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.name = Name.valueOf(in.readUTF()).intern();
            this.aoServer = in.readCompressedInt();
            this.version = in.readCompressedInt();
            this.maxConnections = in.readCompressedInt();
            this.sortMem = in.readCompressedInt();
            this.sharedBuffers = in.readCompressedInt();
            this.fsync = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.name.toString());
        out.writeCompressedInt(this.aoServer);
        out.writeCompressedInt(this.version);
        out.writeCompressedInt(this.maxConnections);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_17) <= 0) {
            out.writeCompressedInt(this.pkey);
        }
        out.writeCompressedInt(this.sortMem);
        out.writeCompressedInt(this.sharedBuffers);
        out.writeBoolean(this.fsync);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_130) <= 0) {
            out.writeCompressedInt(-1);
        }
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.POSTGRES_SERVERS;
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.name + " on " + this.getLinuxServer().getHostname();
    }

    public int addPostgresDatabase(Database.Name name, UserServer datdba, Encoding encoding, boolean enablePostgis) throws IOException, SQLException {
        return this.table.getConnector().getPostgresql().getDatabase().addPostgresDatabase(name, this, datdba, encoding, enablePostgis);
    }

    public PosixPath getDataDirectory() {
        try {
            return PosixPath.valueOf(DATA_BASE_DIR.toString() + '/' + this.name.toString());
        }
        catch (ValidationException e) {
            throw new AssertionError("Generated data directory should always be valid", e);
        }
    }

    public Name getName() {
        return this.name;
    }

    public Database getPostgresDatabase(Database.Name name) throws IOException, SQLException {
        return this.table.getConnector().getPostgresql().getDatabase().getPostgresDatabase(name, this);
    }

    public List<Database> getPostgresDatabases() throws IOException, SQLException {
        return this.table.getConnector().getPostgresql().getDatabase().getPostgresDatabases(this);
    }

    public UserServer getPostgresServerUser(User.Name username) throws IOException, SQLException {
        return this.table.getConnector().getPostgresql().getUserServer().getPostgresServerUser(username, this);
    }

    public List<UserServer> getPostgresServerUsers() throws IOException, SQLException {
        return this.table.getConnector().getPostgresql().getUserServer().getPostgresServerUsers(this);
    }

    public List<User> getPostgresUsers() throws SQLException, IOException {
        List<UserServer> psu = this.getPostgresServerUsers();
        int len = psu.size();
        ArrayList<User> pu = new ArrayList<User>(len);
        for (int c = 0; c < len; ++c) {
            pu.add(psu.get(c).getPostgresUser());
        }
        return pu;
    }

    public boolean isPostgresDatabaseNameAvailable(Database.Name name) throws IOException, SQLException {
        return this.table.getConnector().getPostgresql().getDatabase().isPostgresDatabaseNameAvailable(name, this);
    }

    public void restartPostgresql() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.RESTART_POSTGRESQL, this.pkey);
    }

    public void startPostgresql() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.START_POSTGRESQL, this.pkey);
    }

    public void stopPostgresql() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.STOP_POSTGRESQL, this.pkey);
    }

    static {
        try {
            DEFAULT_PORT = Port.valueOf((int)5432, (Protocol)Protocol.TCP);
        }
        catch (ValidationException e) {
            throw new AssertionError("These hard-coded values are valid", e);
        }
        try {
            DATA_BASE_DIR = PosixPath.valueOf("/var/lib/pgsql");
        }
        catch (ValidationException e) {
            throw new AssertionError("These hard-coded values are valid", e);
        }
    }

    @Deprecated
    public static enum ReservedWord {
        ABORT,
        ALL,
        ANALYSE,
        ANALYZE,
        AND,
        ANY,
        AS,
        ASC,
        BETWEEN,
        BINARY,
        BIT,
        BOTH,
        CASE,
        CAST,
        CHAR,
        CHARACTER,
        CHECK,
        CLUSTER,
        COALESCE,
        COLLATE,
        COLUMN,
        CONSTRAINT,
        COPY,
        CROSS,
        CURRENT_DATE,
        CURRENT_TIME,
        CURRENT_TIMESTAMP,
        CURRENT_USER,
        DEC,
        DECIMAL,
        DEFAULT,
        DEFERRABLE,
        DESC,
        DISTINCT,
        DO,
        ELSE,
        END,
        EXCEPT,
        EXISTS,
        EXPLAIN,
        EXTEND,
        EXTRACT,
        FALSE,
        FLOAT,
        FOR,
        FOREIGN,
        FROM,
        FULL,
        GLOBAL,
        GROUP,
        HAVING,
        ILIKE,
        IN,
        INITIALLY,
        INNER,
        INOUT,
        INTERSECT,
        INTO,
        IS,
        ISNULL,
        JOIN,
        LEADING,
        LEFT,
        LIKE,
        LIMIT,
        LISTEN,
        LOAD,
        LOCAL,
        LOCK,
        MOVE,
        NATURAL,
        NCHAR,
        NEW,
        NOT,
        NOTNULL,
        NULL,
        NULLIF,
        NUMERIC,
        OFF,
        OFFSET,
        OLD,
        ON,
        ONLY,
        OR,
        ORDER,
        OUT,
        OUTER,
        OVERLAPS,
        POSITION,
        PRECISION,
        PRIMARY,
        PUBLIC,
        REFERENCES,
        RESET,
        RIGHT,
        SELECT,
        SESSION_USER,
        SETOF,
        SHOW,
        SOME,
        SUBSTRING,
        TABLE,
        THEN,
        TO,
        TRAILING,
        TRANSACTION,
        TRIM,
        TRUE,
        UNION,
        UNIQUE,
        USER,
        USING,
        VACUUM,
        VARCHAR,
        VERBOSE,
        WHEN,
        WHERE;

        private static volatile Set<String> reservedWords;

        public static boolean isReservedWord(String value) {
            HashSet words = reservedWords;
            if (words == null) {
                ReservedWord[] values = ReservedWord.values();
                words = AoCollections.newHashSet((int)values.length);
                for (ReservedWord word : values) {
                    words.add(word.name().toUpperCase(Locale.ROOT));
                }
                reservedWords = words;
            }
            return words.contains(value.toUpperCase(Locale.ROOT));
        }

        static {
            reservedWords = null;
        }
    }

    public static final class Name
    implements Comparable<Name>,
    Serializable,
    DtoFactory<PostgresServerName>,
    Internable<Name> {
        private static final long serialVersionUID = 7935268259991524802L;
        public static final int MAX_LENGTH = 255;
        private static final ConcurrentMap<String, Name> interned = new ConcurrentHashMap<String, Name>();
        private final String name;

        public static ValidationResult validate(String name) {
            if (name == null) {
                return new InvalidResult(RESOURCES, "Name.validate.isNull");
            }
            int len = name.length();
            if (len == 0) {
                return new InvalidResult(RESOURCES, "Name.validate.isEmpty");
            }
            if (len > 255) {
                return new InvalidResult(RESOURCES, "Name.validate.tooLong", new Serializable[]{Integer.valueOf(255), Integer.valueOf(len)});
            }
            char ch = name.charAt(0);
            if (!(ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9')) {
                return new InvalidResult(RESOURCES, "Name.validate.startAtoZor0to9");
            }
            for (int c = 1; c < len; ++c) {
                ch = name.charAt(c);
                if (ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '.' || ch == '-' || ch == '_') continue;
                return new InvalidResult(RESOURCES, "Name.validate.illegalCharacter");
            }
            return ValidResult.getInstance();
        }

        public static Name valueOf(String name) throws ValidationException {
            if (name == null) {
                return null;
            }
            return new Name(name, true);
        }

        private Name(String name, boolean validate) throws ValidationException {
            this.name = name;
            if (validate) {
                this.validate();
            }
        }

        private Name(String name) {
            ValidationResult result;
            assert ((result = Name.validate(name)).isValid()) : result.toString();
            this.name = name;
        }

        private void validate() throws ValidationException {
            ValidationResult result = Name.validate(this.name);
            if (!result.isValid()) {
                throw new ValidationException(result);
            }
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            try {
                this.validate();
            }
            catch (ValidationException err) {
                InvalidObjectException newErr = new InvalidObjectException(err.getMessage());
                newErr.initCause(err);
                throw newErr;
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof Name && this.name.equals(((Name)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(Name other) {
            return this == other ? 0 : this.name.compareTo(other.name);
        }

        public String toString() {
            return this.name;
        }

        public Name intern() {
            Name addMe;
            String internedName;
            Name existing = (Name)interned.get(this.name);
            if (existing == null && (existing = interned.putIfAbsent(internedName, addMe = this.name == (internedName = this.name.intern()) ? this : new Name(internedName))) == null) {
                existing = addMe;
            }
            return existing;
        }

        public PostgresServerName getDto() {
            return new PostgresServerName(this.name);
        }
    }
}

